/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.integral;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;

public class IntegralCursor<T>
extends AbstractEuclideanSpace
implements Cursor<T> {
    private int index = 0;
    private int code = 0;
    private final int maxIndex;
    private final RandomAccess<T> source;
    private final RectangleNeighborhood<T> neighborhood;

    public IntegralCursor(RectangleNeighborhood<T> neighborhood) {
        super(neighborhood.numDimensions());
        this.neighborhood = neighborhood;
        this.source = neighborhood.getSourceRandomAccess();
        this.maxIndex = (int)Math.round(Math.pow(2.0, neighborhood.numDimensions())) - 1;
        this.reset();
    }

    protected IntegralCursor(IntegralCursor<T> cursor) {
        super(cursor.numDimensions());
        this.neighborhood = cursor.neighborhood;
        this.source = cursor.source.copyRandomAccess();
        this.index = cursor.index;
        this.code = cursor.code;
        this.maxIndex = cursor.maxIndex;
    }

    public void reset() {
        this.index = -1;
        this.code = 0;
        this.neighborhood.min(this.source);
    }

    public void fwd() {
        if (this.index == -1) {
            ++this.index;
            return;
        }
        ++this.index;
        int mask = Integer.lowestOneBit(this.index);
        this.code ^= mask;
        int updatedDimension = Integer.numberOfTrailingZeros(this.index);
        int bitInDimension = (this.code & mask) >> updatedDimension;
        if (bitInDimension == 1) {
            this.source.setPosition(this.neighborhood.max(updatedDimension) - 1L, updatedDimension);
        } else {
            this.source.setPosition(this.neighborhood.min(updatedDimension), updatedDimension);
        }
    }

    public void jumpFwd(long steps) {
        for (long i = 0L; i < steps; ++i) {
            this.fwd();
        }
    }

    public T get() {
        return (T)this.source.get();
    }

    public boolean hasNext() {
        return this.index < this.maxIndex;
    }

    public T next() {
        this.fwd();
        return this.get();
    }

    public IntegralCursor<T> copy() {
        return new IntegralCursor<T>(this);
    }

    public IntegralCursor<T> copyCursor() {
        return this.copy();
    }

    public int getCornerRepresentation() {
        return this.code;
    }

    public void remove() {
    }

    public float getFloatPosition(int d) {
        return this.source.getFloatPosition(d);
    }

    public double getDoublePosition(int d) {
        return this.source.getDoublePosition(d);
    }

    public int getIntPosition(int d) {
        return this.source.getIntPosition(d);
    }

    public long getLongPosition(int d) {
        return this.source.getLongPosition(d);
    }

    public void localize(long[] position) {
        this.source.localize(position);
    }

    public void localize(float[] position) {
        this.source.localize(position);
    }

    public void localize(double[] position) {
        this.source.localize(position);
    }

    public void localize(int[] position) {
        this.source.localize(position);
    }
}

