/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.math;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.hybrid.AbstractBinaryHybridCFI;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import org.scijava.plugin.Plugin;

public final class NumericTypeBinaryMath {
    private NumericTypeBinaryMath() {
    }

    private static boolean compatible(NumericType in1, NumericType in2, NumericType out) {
        if (out == null) {
            return in1 == null || in2 == null || in1.getClass() == in2.getClass();
        }
        return in1.getClass() == in2.getClass() && in1.getClass() == out.getClass();
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=100.0)
    public static class Multiply<T extends NumericType<T>>
    extends AbstractBinaryHybridCFI<T, T>
    implements Ops.Math.Multiply,
    Contingent {
        @Override
        public boolean conforms() {
            return NumericTypeBinaryMath.compatible((NumericType)this.in1(), (NumericType)this.in2(), (NumericType)this.out());
        }

        @Override
        public void compute(T input1, T input2, T output) {
            output.set(input1);
            output.mul(input2);
        }

        @Override
        public T createOutput(T input1, T input2) {
            return (T)((NumericType)input1.createVariable());
        }

        @Override
        public void mutate1(T arg, T in) {
            NumericType result = (NumericType)arg.createVariable();
            this.compute(arg, in, (T)result);
            arg.set((Type)result);
        }

        @Override
        public void mutate2(T in, T arg) {
            NumericType result = (NumericType)arg.createVariable();
            this.compute(in, arg, (T)result);
            arg.set((Type)result);
        }

        @Override
        public Multiply<T> getIndependentInstance() {
            return this;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=100.0)
    public static class Subtract<T extends NumericType<T>>
    extends AbstractBinaryHybridCFI<T, T>
    implements Ops.Math.Subtract,
    Contingent {
        @Override
        public boolean conforms() {
            return NumericTypeBinaryMath.compatible((NumericType)this.in1(), (NumericType)this.in2(), (NumericType)this.out());
        }

        @Override
        public void compute(T input1, T input2, T output) {
            output.set(input1);
            output.sub(input2);
        }

        @Override
        public T createOutput(T input1, T input2) {
            return (T)((NumericType)input1.createVariable());
        }

        @Override
        public void mutate1(T arg, T in) {
            NumericType result = (NumericType)arg.createVariable();
            this.compute(arg, in, (T)result);
            arg.set((Type)result);
        }

        @Override
        public void mutate2(T in, T arg) {
            NumericType result = (NumericType)arg.createVariable();
            this.compute(in, arg, (T)result);
            arg.set((Type)result);
        }

        @Override
        public Subtract<T> getIndependentInstance() {
            return this;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=100.0)
    public static class Divide<T extends NumericType<T>>
    extends AbstractBinaryHybridCFI<T, T>
    implements Ops.Math.Divide,
    Contingent {
        @Override
        public boolean conforms() {
            return NumericTypeBinaryMath.compatible((NumericType)this.in1(), (NumericType)this.in2(), (NumericType)this.out());
        }

        @Override
        public void compute(T input1, T input2, T output) {
            output.set(input1);
            output.div(input2);
        }

        @Override
        public T createOutput(T input1, T input2) {
            return (T)((NumericType)input1.createVariable());
        }

        @Override
        public void mutate1(T arg, T in) {
            NumericType result = (NumericType)arg.createVariable();
            this.compute(arg, in, (T)result);
            arg.set((Type)result);
        }

        @Override
        public void mutate2(T in, T arg) {
            NumericType result = (NumericType)arg.createVariable();
            this.compute(in, arg, (T)result);
            arg.set((Type)result);
        }

        @Override
        public Divide<T> getIndependentInstance() {
            return this;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=100.0)
    public static class Add<T extends NumericType<T>>
    extends AbstractBinaryHybridCFI<T, T>
    implements Ops.Math.Add,
    Contingent {
        @Override
        public boolean conforms() {
            return NumericTypeBinaryMath.compatible((NumericType)this.in1(), (NumericType)this.in2(), (NumericType)this.out());
        }

        @Override
        public void compute(T input1, T input2, T output) {
            output.set(input1);
            output.add(input2);
        }

        @Override
        public T createOutput(T input1, T input2) {
            return (T)((NumericType)input1.createVariable());
        }

        @Override
        public void mutate1(T arg, T in) {
            NumericType result = (NumericType)arg.createVariable();
            this.compute(arg, in, (T)result);
            arg.set((Type)result);
        }

        @Override
        public void mutate2(T in, T arg) {
            NumericType result = (NumericType)arg.createVariable();
            this.compute(in, arg, (T)result);
            arg.set((Type)result);
        }

        @Override
        public Add<T> getIndependentInstance() {
            return this;
        }
    }
}

