/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.stats;

import net.imagej.ops.Ops;
import net.imagej.ops.image.integral.IntegralCursor;
import net.imagej.ops.stats.AbstractStatsOp;
import net.imagej.ops.stats.IntegralMean;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.converter.RealDoubleConverter;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Stats.IntegralSum.class)
public class IntegralSum<I extends RealType<I>>
extends AbstractStatsOp<RectangleNeighborhood<I>, DoubleType>
implements Ops.Stats.IntegralSum {
    @Override
    public void compute(RectangleNeighborhood<I> input, DoubleType output) {
        IntegralCursor<I> cursor = new IntegralCursor<I>(input);
        int dimensions = input.numDimensions();
        DoubleType sum = new DoubleType();
        sum.setZero();
        RealDoubleConverter conv = new RealDoubleConverter();
        DoubleType valueAsDoubleType = new DoubleType();
        while (cursor.hasNext()) {
            RealType value = (RealType)((RealType)cursor.next()).copy();
            conv.convert((Object)value, (Object)valueAsDoubleType);
            int cornerInteger = cursor.getCornerRepresentation();
            DoubleType factor = new DoubleType(Math.pow(-1.0, dimensions - IntegralMean.norm(cornerInteger)));
            valueAsDoubleType.mul((AbstractRealType)factor);
            sum.add((AbstractRealType)valueAsDoubleType);
        }
        output.set((AbstractRealType)sum);
    }
}

