/*
 * Decompiled with CFR 0.152.
 */
package fiji.expressionparser;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;

public class ImgLibUtils {
    public static final <T extends RealType<T>> Img<FloatType> copyToFloatTypeImage(Img<T> img) {
        long[] dimensions = new long[img.numDimensions()];
        img.dimensions(dimensions);
        ArrayImg target = new ArrayImgFactory().create(dimensions, (NativeType)new FloatType());
        boolean compatible_containers = Util.equalIterationOrder((IterableInterval[])new IterableInterval[]{img, target});
        if (compatible_containers) {
            Cursor ic = img.cursor();
            Cursor tc = target.cursor();
            while (ic.hasNext()) {
                ic.fwd();
                tc.fwd();
                ((FloatType)tc.get()).set(((RealType)ic.get()).getRealFloat());
            }
        } else {
            Cursor tc = target.localizingCursor();
            RandomAccess ic = img.randomAccess();
            while (tc.hasNext()) {
                tc.fwd();
                ic.setPosition((Localizable)tc);
                ((FloatType)tc.get()).set(((RealType)ic.get()).getRealFloat());
            }
        }
        return target;
    }
}

