/*
 * Decompiled with CFR 0.152.
 */
import Utilities.Counter3D;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;

public class _3D_objects_counter
implements PlugIn,
AdjustmentListener,
FocusListener {
    ImagePlus imp;
    ImageProcessor ip;
    int width;
    int height;
    int nbSlices;
    int length;
    double min;
    double max;
    String title;
    String redirectTo;
    int thr;
    int minSize;
    int maxSize;
    int dotSize;
    int fontSize;
    boolean excludeOnEdges;
    boolean showObj;
    boolean showSurf;
    boolean showCentro;
    boolean showCOM;
    boolean showNb;
    boolean whiteNb;
    boolean newRT;
    boolean showStat;
    boolean showMaskedImg;
    boolean closeImg;
    boolean showSummary;
    boolean redirect;
    Vector sliders;
    Vector values;

    public void run(String arg) {
        if (IJ.versionLessThan((String)"1.39i")) {
            return;
        }
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.error((String)"You need to open an image first.");
            return;
        }
        if (this.imp.getBitDepth() > 16) {
            IJ.error((String)"3D objects counter only works on 8- or 16-bits images.");
            return;
        }
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        this.nbSlices = this.imp.getStackSize();
        this.length = this.height * this.width * this.nbSlices;
        this.title = this.imp.getTitle();
        this.min = Math.pow(2.0, this.imp.getBitDepth());
        this.max = 0.0;
        for (int i = 1; i <= this.nbSlices; ++i) {
            this.imp.setSlice(i);
            this.ip = this.imp.getProcessor();
            this.min = Math.min(this.min, this.imp.getStatistics().min);
            this.max = Math.max(this.max, this.imp.getStatistics().max);
        }
        this.imp.setSlice(this.nbSlices / 2);
        this.imp.resetDisplayRange();
        this.thr = this.ip.getAutoThreshold();
        this.ip.setThreshold((double)this.thr, this.max, 0);
        this.imp.updateAndDraw();
        this.minSize = (int)Prefs.get((String)"3D-OC_minSize.double", (double)10.0);
        this.maxSize = this.length;
        this.excludeOnEdges = Prefs.get((String)"3D-OC_excludeOnEdges.boolean", (boolean)true);
        this.showObj = Prefs.get((String)"3D-OC_showObj.boolean", (boolean)true);
        this.showSurf = Prefs.get((String)"3D-OC_showSurf.boolean", (boolean)true);
        this.showCentro = Prefs.get((String)"3D-OC_showCentro.boolean", (boolean)true);
        this.showCOM = Prefs.get((String)"3D-OC_showCOM.boolean", (boolean)true);
        this.showStat = Prefs.get((String)"3D-OC_showStat.boolean", (boolean)true);
        this.showSummary = Prefs.get((String)"3D-OC_summary.boolean", (boolean)true);
        this.showMaskedImg = Prefs.get((String)"3D-OC-Options_showMaskedImg.boolean", (boolean)true);
        this.closeImg = Prefs.get((String)"3D-OC-Options_closeImg.boolean", (boolean)false);
        this.redirectTo = Prefs.get((String)"3D-OC-Options_redirectTo.string", (String)"none");
        boolean bl = this.redirect = !this.redirectTo.equals("none") && WindowManager.getImage((String)this.redirectTo) != null;
        if (this.redirect) {
            ImagePlus imgRedir = WindowManager.getImage((String)this.redirectTo);
            if (imgRedir.getWidth() != this.width || imgRedir.getHeight() != this.height || imgRedir.getNSlices() != this.nbSlices || imgRedir.getBitDepth() > 16) {
                this.redirect = false;
                this.showMaskedImg = false;
                IJ.log((String)"Redirection canceled: images should have the same size and a depth of 8- or 16-bits.");
            }
            if (imgRedir.getTitle().equals(this.title)) {
                this.redirect = false;
                this.showMaskedImg = false;
                IJ.log((String)"Redirection canceled: both images have the same title.");
            }
        }
        if (!this.redirect) {
            Prefs.set((String)"3D-OC-Options_redirectTo.string", (String)"none");
            Prefs.set((String)"3D-OC-Options_showMaskedImg.boolean", (boolean)false);
        }
        GenericDialog gd = new GenericDialog("3D Object Counter v2.0");
        gd.addSlider("Threshold", this.min, this.max, (double)this.thr);
        gd.addSlider("Slice", 1.0, (double)this.nbSlices, (double)(this.nbSlices / 2));
        this.sliders = gd.getSliders();
        ((Scrollbar)this.sliders.elementAt(0)).addAdjustmentListener(this);
        ((Scrollbar)this.sliders.elementAt(1)).addAdjustmentListener(this);
        this.values = gd.getNumericFields();
        ((TextField)this.values.elementAt(0)).addFocusListener(this);
        ((TextField)this.values.elementAt(1)).addFocusListener(this);
        gd.addMessage("Size filter: ");
        gd.addNumericField("Min.", (double)this.minSize, 0);
        gd.addNumericField("Max.", (double)this.maxSize, 0);
        gd.addCheckbox("Exclude_objects_on_edges", this.excludeOnEdges);
        gd.addMessage("Maps to show: ");
        gd.addCheckbox("Objects", this.showObj);
        gd.addCheckbox("Surfaces", this.showSurf);
        gd.addCheckbox("Centroids", this.showCentro);
        gd.addCheckbox("Centres_of_masses", this.showCOM);
        gd.addMessage("Results tables to show: ");
        gd.addCheckbox("Statistics", this.showStat);
        gd.addCheckbox("Summary", this.showSummary);
        if (this.redirect) {
            gd.addMessage("\nRedirection:\nImage used as a mask: " + this.title + "\nMeasures will be done on: " + this.redirectTo + (this.showMaskedImg ? "\nMasked image will be shown" : "") + ".");
        }
        if (this.closeImg) {
            gd.addMessage("\nCaution:\nImage(s) will be closed during the processing\n(see 3D-OC options to change this setting).");
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.ip.resetThreshold();
            this.imp.updateAndDraw();
            return;
        }
        this.thr = (int)gd.getNextNumber();
        gd.getNextNumber();
        this.minSize = (int)gd.getNextNumber();
        this.maxSize = (int)gd.getNextNumber();
        this.excludeOnEdges = gd.getNextBoolean();
        this.showObj = gd.getNextBoolean();
        this.showSurf = gd.getNextBoolean();
        this.showCentro = gd.getNextBoolean();
        this.showCOM = gd.getNextBoolean();
        this.showStat = gd.getNextBoolean();
        this.showSummary = gd.getNextBoolean();
        Prefs.set((String)"3D-OC_minSize.double", (int)this.minSize);
        Prefs.set((String)"3D-OC_excludeOnEdges.boolean", (boolean)this.excludeOnEdges);
        Prefs.set((String)"3D-OC_showObj.boolean", (boolean)this.showObj);
        Prefs.set((String)"3D-OC_showSurf.boolean", (boolean)this.showSurf);
        Prefs.set((String)"3D-OC_showCentro.boolean", (boolean)this.showCentro);
        Prefs.set((String)"3D-OC_showCOM.boolean", (boolean)this.showCOM);
        Prefs.set((String)"3D-OC_showStat.boolean", (boolean)this.showStat);
        Prefs.set((String)"3D-OC_summary.boolean", (boolean)this.showSummary);
        if (!this.redirect) {
            Prefs.set((String)"3D-OC-Options_redirectTo.string", (String)"none");
        }
        this.ip.resetThreshold();
        this.imp.updateAndDraw();
        Counter3D OC = new Counter3D(this.imp, this.thr, this.minSize, this.maxSize, this.excludeOnEdges, this.redirect);
        this.dotSize = (int)Prefs.get((String)"3D-OC-Options_dotSize.double", (double)5.0);
        this.fontSize = (int)Prefs.get((String)"3D-OC-Options_fontSize.double", (double)10.0);
        this.showNb = Prefs.get((String)"3D-OC-Options_showNb.boolean", (boolean)true);
        this.whiteNb = Prefs.get((String)"3D-OC-Options_whiteNb.boolean", (boolean)true);
        if (this.showObj) {
            OC.getObjMap(this.showNb, this.fontSize).show();
            IJ.run((String)"Fire");
        }
        if (this.showSurf) {
            OC.getSurfPixMap(this.showNb, this.whiteNb, this.fontSize).show();
            IJ.run((String)"Fire");
        }
        if (this.showCentro) {
            OC.getCentroidMap(this.showNb, this.whiteNb, this.dotSize, this.fontSize).show();
            IJ.run((String)"Fire");
        }
        if (this.showCOM) {
            OC.getCentreOfMassMap(this.showNb, this.whiteNb, this.dotSize, this.fontSize).show();
            IJ.run((String)"Fire");
        }
        this.newRT = Prefs.get((String)"3D-OC-Options_newRT.boolean", (boolean)true);
        if (this.showStat) {
            OC.showStatistics(this.newRT);
        }
        if (this.showSummary) {
            OC.showSummary();
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.updateImg();
    }

    @Override
    public void focusLost(FocusEvent e) {
        int val;
        if (e.getSource().equals(this.values.elementAt(0))) {
            val = (int)Tools.parseDouble((String)((TextField)this.values.elementAt(0)).getText());
            val = (int)Math.min(this.max, Math.max(this.min, (double)val));
            ((TextField)this.values.elementAt(0)).setText("" + val);
        }
        if (e.getSource().equals(this.values.elementAt(1))) {
            val = (int)Tools.parseDouble((String)((TextField)this.values.elementAt(1)).getText());
            val = (int)Math.min(this.max, Math.max(this.min, (double)val));
            ((TextField)this.values.elementAt(1)).setText("" + val);
        }
        this.updateImg();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    private void updateImg() {
        this.thr = ((Scrollbar)this.sliders.elementAt(0)).getValue();
        this.imp.setSlice(((Scrollbar)this.sliders.elementAt(1)).getValue());
        this.imp.resetDisplayRange();
        this.ip.setThreshold((double)this.thr, this.max, 0);
    }
}

