/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.omevisual;

import io.scif.services.TranslatorService;
import loci.formats.ome.OMEXMLMetadata;
import net.imagej.Dataset;
import net.imagej.ImageJ;
import net.imagej.display.ImageDisplay;
import org.scijava.command.Command;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.omevisual.OMEUtils;
import sc.fiji.omevisual.gui.MainAppFrame;

@Plugin(type=Command.class, menuPath="Plugins>Utilities>Visualize OME Metadata")
public class OMEVisual
implements Command {
    @Parameter
    private ImageJ ij;
    @Parameter
    private LogService log;
    @Parameter
    private TranslatorService translatorService;
    @Parameter
    private ImageDisplay image;
    public static final String PLUGIN_NAME = "OMEVisual";
    public static final String VERSION = OMEVisual.version();

    private static String version() {
        String version = null;
        Package pack = OMEVisual.class.getPackage();
        if (pack != null) {
            version = pack.getImplementationVersion();
        }
        return version == null ? "DEVELOPMENT" : version;
    }

    public void run() {
        this.log.info((Object)("Running OMEVisual version " + VERSION));
        Dataset data = (Dataset)this.image.getActiveView().getData();
        OMEXMLMetadata md = OMEUtils.getOMEXMLMetadata(data, this.ij, this.translatorService);
        if (md == null) {
            return;
        }
        MainAppFrame app = new MainAppFrame(this.ij, this.image, md);
        app.setTitle("OMEVisual version " + VERSION);
        app.init();
    }
}

