/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.util.Intervals;
import sc.fiji.labkit.pixel_classification.gpu.algorithms.GpuNeighborhoodOperation;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuImage;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuView;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuViews;

class GpuConcatenatedNeighborhoodOperation
implements GpuNeighborhoodOperation {
    private final GpuApi gpu;
    private final List<? extends GpuNeighborhoodOperation> convolutions;

    public GpuConcatenatedNeighborhoodOperation(GpuApi gpu, List<? extends GpuNeighborhoodOperation> convolutions) {
        this.gpu = gpu;
        this.convolutions = convolutions;
    }

    @Override
    public Interval getRequiredInputInterval(Interval targetInterval) {
        return this.intervals(targetInterval).get(0);
    }

    @Override
    public void apply(GpuView input, GpuView output) {
        try (GpuApi scope = this.gpu.subScope();){
            int i;
            List<Interval> intervals = this.intervals((Interval)new FinalInterval(output.dimensions()));
            if (!Intervals.equalDimensions((Interval)new FinalInterval(input.dimensions()), (Interval)intervals.get(0))) {
                throw new IllegalArgumentException("Dimensions of the input image are not as expected.");
            }
            int n = this.convolutions.size();
            ArrayList<GpuView> buffers = new ArrayList<GpuView>(n);
            buffers.add(input);
            for (i = 1; i < n; ++i) {
                long[] dimensions = Intervals.dimensionsAsLongArray((Dimensions)((Dimensions)intervals.get(i)));
                GpuImage buffer = scope.create(dimensions, NativeTypeEnum.Float);
                buffers.add(GpuViews.wrap(buffer));
            }
            buffers.add(output);
            for (i = 0; i < this.convolutions.size(); ++i) {
                GpuNeighborhoodOperation convolution = this.convolutions.get(i);
                convolution.apply((GpuView)buffers.get(i), (GpuView)buffers.get(i + 1));
            }
        }
    }

    private List<Interval> intervals(Interval outputInterval) {
        int n = this.convolutions.size();
        ArrayList<Interval> intervals = new ArrayList<Interval>(n + 1);
        intervals.add(outputInterval);
        Interval t = outputInterval;
        for (int i = n - 1; i >= 0; --i) {
            GpuNeighborhoodOperation convolution = this.convolutions.get(i);
            t = convolution.getRequiredInputInterval(t);
            intervals.add(t);
        }
        Collections.reverse(intervals);
        return intervals;
    }
}

