/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import ij.ImagePlus;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.display.imagej.CalibrationUtils;
import net.imglib2.img.display.imagej.ImageJVirtualStack;
import net.imglib2.img.display.imagej.ImageJVirtualStackARGB;
import net.imglib2.img.display.imagej.ImageJVirtualStackFloat;
import net.imglib2.img.display.imagej.ImageJVirtualStackUnsignedByte;
import net.imglib2.img.display.imagej.ImageJVirtualStackUnsignedShort;
import net.imglib2.img.display.imagej.ImgPlusViews;
import net.imglib2.transform.integer.Mixed;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;

public class ImgToVirtualStack {
    private static final List<AxisType> imagePlusAxisOrder = Arrays.asList(Axes.X, Axes.Y, Axes.CHANNEL, Axes.Z, Axes.TIME);

    public static ImagePlus wrap(ImgPlus<? extends RealType<?>> imgPlus, boolean mergeRGB) {
        ImgPlus<? extends RealType<?>> imgPlus2 = mergeRGB && ImgPlusViews.canFuseColor(imgPlus) ? ImgPlusViews.fuseColor(imgPlus) : imgPlus;
        return ImgToVirtualStack.wrap(imgPlus2);
    }

    public static ImagePlus wrap(ImgPlus<?> imgPlus) {
        return ImgToVirtualStack.wrap(imgPlus, ImgToVirtualStack::createVirtualStack);
    }

    public static ImagePlus wrapAndScaleBitType(ImgPlus<BitType> imgPlus) {
        return ImgToVirtualStack.wrap(imgPlus, ImgToVirtualStack::createVirtualStackBits);
    }

    private static <T> ImagePlus wrap(ImgPlus<T> imgPlus, Function<RandomAccessibleInterval<T>, ImageJVirtualStack<?>> imageStackWrapper) {
        imgPlus = ImgPlusViews.fixAxes(imgPlus);
        RandomAccessibleInterval<T> sorted = ImgToVirtualStack.ensureXYCZT(imgPlus);
        ImageJVirtualStack<?> stack = imageStackWrapper.apply(sorted);
        ImagePlus result = new ImagePlus(imgPlus.getName(), stack);
        stack.setWritable(true);
        result.setDimensions((int)sorted.dimension(2), (int)sorted.dimension(3), (int)sorted.dimension(4));
        CalibrationUtils.copyCalibrationToImagePlus(imgPlus, result);
        return result;
    }

    private static ImageJVirtualStack<?> createVirtualStackBits(RandomAccessibleInterval<BitType> sorted) {
        return ImageJVirtualStackUnsignedByte.wrapAndScaleBitType(sorted);
    }

    private static ImageJVirtualStack<?> createVirtualStack(RandomAccessibleInterval<?> rai) {
        Object type = rai.randomAccess().get();
        if (type instanceof RealType) {
            return ImgToVirtualStack.createVirtualStackRealType((RandomAccessibleInterval)ImgToVirtualStack.cast(rai));
        }
        if (type instanceof ARGBType) {
            return ImageJVirtualStackARGB.wrap((RandomAccessibleInterval<ARGBType>)((RandomAccessibleInterval)ImgToVirtualStack.cast(rai)));
        }
        throw new IllegalArgumentException("Unsupported type");
    }

    private static <T> T cast(Object in) {
        Object out = in;
        return (T)out;
    }

    private static ImageJVirtualStack<?> createVirtualStackRealType(RandomAccessibleInterval<? extends RealType<?>> rai) {
        boolean isSigned;
        RealType type = (RealType)rai.randomAccess().get();
        int bitDepth = type.getBitsPerPixel();
        boolean bl = isSigned = type.getMinValue() < 0.0;
        if (bitDepth <= 8 && !isSigned) {
            return ImageJVirtualStackUnsignedByte.wrap(rai);
        }
        if (bitDepth <= 16 && !isSigned) {
            return ImageJVirtualStackUnsignedShort.wrap(rai);
        }
        return ImageJVirtualStackFloat.wrap(rai);
    }

    private static <T> RandomAccessibleInterval<T> ensureXYCZT(ImgPlus<T> imgPlus) {
        int[] axes = ImgToVirtualStack.getPermutation(ImgToVirtualStack.getAxes(imgPlus));
        return ImgToVirtualStack.permute(imgPlus, axes);
    }

    private static int[] getPermutation(List<AxisType> axes) {
        return axes.stream().mapToInt(axis -> {
            int index = imagePlusAxisOrder.indexOf(axis);
            if (index < 0) {
                throw new IllegalArgumentException("Unsupported axis type: " + axis);
            }
            return index;
        }).toArray();
    }

    private static List<AxisType> getAxes(ImgPlus<?> imgPlus) {
        return IntStream.range(0, imgPlus.numDimensions()).mapToObj(i -> ((CalibratedAxis)imgPlus.axis(i)).type()).collect(Collectors.toList());
    }

    private static <T> RandomAccessibleInterval<T> permute(ImgPlus<T> imgPlus, int[] axes) {
        boolean inNaturalOrder = true;
        boolean[] matchedDimensions = new boolean[5];
        long[] min = new long[5];
        long[] max = new long[5];
        for (int d = 0; d < axes.length; ++d) {
            int index = axes[d];
            matchedDimensions[index] = true;
            min[index] = imgPlus.min(d);
            max[index] = imgPlus.max(d);
            if (index == d) continue;
            inNaturalOrder = false;
        }
        if (imgPlus.numDimensions() != 5) {
            inNaturalOrder = false;
        }
        if (inNaturalOrder) {
            return imgPlus;
        }
        axes = Arrays.copyOf(axes, 5);
        IntervalView rai = imgPlus;
        for (int i = 0; i < 5; ++i) {
            if (matchedDimensions[i]) continue;
            axes[rai.numDimensions()] = i;
            min[i] = 0L;
            max[i] = 0L;
            rai = Views.addDimension(rai, (long)0L, (long)0L);
        }
        MixedTransform t = new MixedTransform(rai.numDimensions(), 5);
        t.setComponentMapping(axes);
        return Views.interval((RandomAccessible)new MixedTransformView(rai, (Mixed)t), (long[])min, (long[])max);
    }
}

