/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettingsIO;
import fiji.plugin.trackmate.gui.wizard.TrackMateWizardSequence;
import fiji.plugin.trackmate.gui.wizard.WizardSequence;
import fiji.plugin.trackmate.io.SettingsPersistence;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.hyperstack.HyperStackDisplayer;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.plugin.PlugIn;
import java.awt.Component;
import java.io.File;
import javax.swing.JFrame;
import org.scijava.object.ObjectService;

public class TrackMatePlugIn
implements PlugIn {
    public static File lastLoadedFile;

    public void run(String imagePath) {
        try {
            ImagePlus imp;
            lastLoadedFile = null;
            if (imagePath != null && imagePath.length() > 0) {
                imp = IJ.openImage((String)imagePath);
                if (imp == null || null == imp.getOriginalFileInfo()) {
                    IJ.error((String)("TrackMate v" + TrackMate.PLUGIN_NAME_VERSION), (String)("Could not load image with path " + imagePath + "."));
                    return;
                }
            } else {
                imp = WindowManager.getCurrentImage();
                if (null == imp) {
                    IJ.error((String)("TrackMate v" + TrackMate.PLUGIN_NAME_VERSION), (String)"Please open an image before running TrackMate.");
                    return;
                }
                if (imp.getType() == 4) {
                    IJ.error((String)("TrackMate v" + TrackMate.PLUGIN_NAME_VERSION), (String)"TrackMate does not work on RGB images.");
                    return;
                }
            }
            imp.setOpenAsHyperStack(true);
            imp.setDisplayMode(1);
            if (!imp.isVisible()) {
                imp.show();
            }
            GuiUtils.userCheckImpDimensions(imp);
            Settings settings = this.createSettings(imp);
            Model model = this.createModel(imp);
            TrackMate trackmate = this.createTrackMate(model, settings);
            SelectionModel selectionModel = new SelectionModel(model);
            DisplaySettings displaySettings = this.createDisplaySettings();
            HyperStackDisplayer displayer = new HyperStackDisplayer(model, selectionModel, imp, displaySettings);
            displayer.render();
            WizardSequence sequence = this.createSequence(trackmate, selectionModel, displaySettings);
            JFrame frame = sequence.run("TrackMate on " + imp.getShortTitle());
            frame.setIconImage(Icons.TRACKMATE_ICON.getImage());
            GuiUtils.positionWindow(frame, (Component)imp.getWindow());
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = e.getMessage();
            if (msg == null || msg.isEmpty()) {
                msg = e.getClass() + "\n" + e.getStackTrace()[0].toString();
            }
            IJ.error((String)("TrackMate v" + TrackMate.PLUGIN_NAME_VERSION), (String)("An unexpected error occurred:\n" + msg));
            return;
        }
    }

    protected WizardSequence createSequence(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings) {
        return new TrackMateWizardSequence(trackmate, selectionModel, displaySettings);
    }

    protected Model createModel(ImagePlus imp) {
        Model model = new Model();
        model.setPhysicalUnits(imp.getCalibration().getUnit(), imp.getCalibration().getTimeUnit());
        return model;
    }

    protected Settings createSettings(ImagePlus imp) {
        Settings ls = SettingsPersistence.readLastUsedSettings(imp, Logger.DEFAULT_LOGGER);
        ls.addAllAnalyzers();
        return ls;
    }

    protected TrackMate createTrackMate(Model model, Settings settings) {
        String spaceUnits = settings.imp.getCalibration().getXUnit();
        String timeUnits = settings.imp.getCalibration().getTimeUnit();
        model.setPhysicalUnits(spaceUnits, timeUnits);
        TrackMate trackmate = new TrackMate(model, settings);
        ObjectService objectService = (ObjectService)TMUtils.getContext().service(ObjectService.class);
        if (objectService != null) {
            objectService.addObject((Object)trackmate);
        }
        trackmate.setNumThreads(Prefs.getThreads());
        return trackmate;
    }

    protected DisplaySettings createDisplaySettings() {
        return DisplaySettingsIO.readUserDefault().copy("CurrentDisplaySettings");
    }

    public static void main(String[] args) {
        ImageJ.main((String[])args);
        new TrackMatePlugIn().run("samples/MAX_Merged.tif");
    }
}

