/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.io.IcyTrackFormatWriter;
import java.awt.Frame;
import java.io.File;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

public class IcyTrackExporter
extends AbstractTMAction {
    private static final String INFO_TEXT = "<html>Export the visible tracks in the current model to a XML file that can be read by the TrackManager plugin of the <a href='http://icy.bioimageanalysis.org/'>Icy software</a>.</html>";
    private static final String NAME = "Export tracks to Icy";
    private static final String KEY = "ICY_EXPORTER";

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        File file;
        File folder;
        this.logger.log("Exporting tracks to Icy format.\n");
        Model model = trackmate.getModel();
        int ntracks = model.getTrackModel().nTracks(true);
        if (ntracks == 0) {
            this.logger.log("No visible track found. Aborting.\n");
            return;
        }
        try {
            folder = new File(trackmate.getSettings().imp.getOriginalFileInfo().directory);
        }
        catch (NullPointerException npe) {
            folder = new File(System.getProperty("user.dir")).getParentFile().getParentFile();
        }
        try {
            String filename = trackmate.getSettings().imageFileName;
            int dotLoca = filename.indexOf(".");
            if (dotLoca > 0) {
                filename = filename.substring(0, dotLoca);
            }
            file = new File(folder.getPath() + File.separator + filename + "_Icy.xml");
        }
        catch (NullPointerException npe) {
            file = new File(folder.getPath() + File.separator + "IcyTracks.xml");
        }
        file = IOUtils.askForFileForSaving(file, parent);
        if (null == file) {
            this.logger.log("Exporting to Icy aborted.\n");
            return;
        }
        this.logger.log("  Writing to file.\n");
        double[] calibration = new double[]{trackmate.getSettings().dx, trackmate.getSettings().dy, trackmate.getSettings().dz};
        IcyTrackFormatWriter writer = new IcyTrackFormatWriter(file, model, calibration);
        if (!writer.checkInput() || !writer.process()) {
            this.logger.error(writer.getErrorMessage());
        } else {
            this.logger.log("Done.\n");
        }
    }

    @Plugin(type=TrackMateActionFactory.class, enabled=true)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return IcyTrackExporter.INFO_TEXT;
        }

        @Override
        public String getName() {
            return IcyTrackExporter.NAME;
        }

        @Override
        public String getKey() {
            return IcyTrackExporter.KEY;
        }

        @Override
        public TrackMateAction create() {
            return new IcyTrackExporter();
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.ICY_ICON;
        }
    }
}

