/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.table.BranchTableView;
import java.awt.Frame;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

public class TrackBranchAnalysis
extends AbstractTMAction {
    private static final String INFO_TEXT = "<html>This action analyzes each branch of all tracks, and outputs in an ImageJ results table the number of its predecessors, of successors, and its duration.<p>The results table is in sync with the selection. Clicking on a line will select the target branch.</html>";
    private static final String KEY = "TRACK_BRANCH_ANALYSIS";
    private static final String NAME = "Branch hierarchy analysis";
    public static final String DOC_URL = "https://imagej.net/plugins/trackmate/actions/branch-hierarchy-analysis";

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        TrackBranchAnalysis.createBranchTable(trackmate.getModel(), selectionModel, TMUtils.getImagePathWithoutExtension(trackmate.getSettings())).render();
    }

    public static final BranchTableView createBranchTable(Model model, SelectionModel selectionModel, String imageFileName) {
        return new BranchTableView(model, selectionModel, imageFileName);
    }

    @Plugin(type=TrackMateActionFactory.class, enabled=true)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return TrackBranchAnalysis.INFO_TEXT;
        }

        @Override
        public String getName() {
            return TrackBranchAnalysis.NAME;
        }

        @Override
        public String getKey() {
            return TrackBranchAnalysis.KEY;
        }

        @Override
        public TrackMateAction create() {
            return new TrackBranchAnalysis();
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.BRANCH_ICON_16x16;
        }

        @Override
        public String getUrl() {
            return TrackBranchAnalysis.DOC_URL;
        }
    }
}

