/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.util.TMUtils;
import ij.IJ;
import ij.ImagePlus;
import ij.measure.Calibration;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.color.ColorSpace;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import org.scijava.prefs.PrefService;

public class GuiUtils {
    private static final FocusListener selectAllFocusListener = new FocusListener(){

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void focusGained(FocusEvent fe) {
            if (!(fe.getSource() instanceof JTextField)) {
                return;
            }
            JTextField txt = (JTextField)fe.getSource();
            SwingUtilities.invokeLater(() -> txt.selectAll());
        }
    };

    public static final void selectAllOnFocus(JTextField tf) {
        tf.addFocusListener(selectAllFocusListener);
    }

    public static final void setFont(JComponent panel, Font font) {
        for (Component c : panel.getComponents()) {
            c.setFont(font);
        }
    }

    public static Color textColorForBackground(Color backgroundColor) {
        if ((double)backgroundColor.getRed() * 0.299 + (double)backgroundColor.getGreen() * 0.587 + (double)backgroundColor.getBlue() * 0.114 > 150.0) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    public static double colorDistance(Color a, Color b) {
        double c2;
        float[] labA = GuiUtils.toCIELab(a);
        float[] labB = GuiUtils.toCIELab(b);
        float deltaL = labA[0] - labB[0];
        float deltaA = labA[1] - labB[1];
        float deltaB = labA[2] - labB[2];
        double c1 = Math.sqrt(labA[1] * labA[1] + labA[2] * labA[2]);
        double deltaC = c1 - (c2 = Math.sqrt(labB[1] * labB[1] + labB[2] * labB[2]));
        double deltaH = (double)(deltaA * deltaA + deltaB * deltaB) - deltaC * deltaC;
        deltaH = deltaH < 0.0 ? 0.0 : Math.sqrt(deltaH);
        double sc = 1.0 + 0.045 * c1;
        double sh = 1.0 + 0.015 * c1;
        double deltaLKlsl = (double)deltaL / 1.0;
        double deltaCkcsc = deltaC / sc;
        double deltaHkhsh = deltaH / sh;
        double i = deltaLKlsl * deltaLKlsl + deltaCkcsc * deltaCkcsc + deltaHkhsh * deltaHkhsh;
        return i < 0.0 ? 0.0 : Math.sqrt(i);
    }

    private static final float[] fromCIEXYZ(float[] colorvalue) {
        double l = GuiUtils.f(colorvalue[1]);
        double L = 116.0 * l - 16.0;
        double a = 500.0 * (GuiUtils.f(colorvalue[0]) - l);
        double b = 200.0 * (l - GuiUtils.f(colorvalue[2]));
        return new float[]{(float)L, (float)a, (float)b};
    }

    private static double f(double x) {
        double N = 0.13793103448275862;
        if (x > 0.008856451679035631) {
            return Math.cbrt(x);
        }
        return 7.787037037037037 * x + 0.13793103448275862;
    }

    public static final float[] toCIELab(Color color) {
        float[] rgbvalue = color.getColorComponents(null);
        ColorSpace CIEXYZ = ColorSpace.getInstance(1001);
        float[] xyz = CIEXYZ.fromRGB(rgbvalue);
        return GuiUtils.fromCIEXYZ(xyz);
    }

    public static void positionWindow(Window gui, Component component) {
        if (null != component) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gs = ge.getScreenDevices();
            int screenWidth = 0;
            for (int i = 0; i < gs.length; ++i) {
                DisplayMode dm = gs[i].getDisplayMode();
                screenWidth += dm.getWidth();
            }
            Point windowLoc = component.getLocation();
            Dimension windowSize = component.getSize();
            Dimension guiSize = gui.getSize();
            if (guiSize.width > windowLoc.x) {
                if (guiSize.width > screenWidth - (windowLoc.x + windowSize.width)) {
                    gui.setLocationRelativeTo(null);
                } else {
                    gui.setLocation(windowLoc.x + windowSize.width, windowLoc.y);
                }
            } else {
                gui.setLocation(windowLoc.x - guiSize.width, windowLoc.y);
            }
        } else {
            gui.setLocationRelativeTo(null);
        }
    }

    public static final void userCheckImpDimensions(ImagePlus imp) {
        int[] dims = imp.getDimensions();
        if (dims[4] == 1 && dims[3] > 1) {
            switch (JOptionPane.showConfirmDialog(null, "It appears this image has 1 timepoint but " + dims[3] + " slices.\nDo you want to swap Z and T?", "Z/T swapped?", 1)) {
                case 0: {
                    imp.setDimensions(dims[2], dims[4], dims[3]);
                    Calibration calibration = imp.getCalibration();
                    if (0.0 != calibration.frameInterval) break;
                    calibration.frameInterval = 1.0;
                    calibration.setTimeUnit("frame");
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
    }

    public static void setSystemLookAndFeel() {
        if (IJ.isMacOSX() || IJ.isWindows()) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addOnClosingEvent(final JComponent component, final Runnable runnable) {
        component.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                SwingUtilities.getWindowAncestor(component).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        runnable.run();
                    }
                });
            }
        });
    }

    public static JEditorPane infoDisplay() {
        return GuiUtils.infoDisplay("");
    }

    public static JEditorPane infoDisplay(String html) {
        return GuiUtils.infoDisplay(html, true);
    }

    public static JEditorPane infoDisplay(String html, final boolean justify) {
        JEditorPane jep = new JEditorPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setText(String t) {
                String text = justify ? t.replace("<br>", "").replace("<p>", "<p align=\"justify\">").replace("<html>", "<html><p align=\"justify\">") : t;
                super.setText(text);
            }
        };
        jep.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jep.setContentType("text/html");
        jep.setText(html);
        jep.setEditable(false);
        jep.setOpaque(false);
        jep.setFont(Fonts.FONT.deriveFont(2));
        jep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.browse(hle.getURL().toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        return jep;
    }

    public static JScrollPane textInScrollPanel(JComponent component) {
        JScrollPane scrollPane = new JScrollPane(component, 20, 31);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        return scrollPane;
    }

    public static final ImageIcon scaleImage(ImageIcon icon, int w, int h) {
        int nw = icon.getIconWidth();
        int nh = icon.getIconHeight();
        if (icon.getIconWidth() > w) {
            nw = w;
            nh = nw * icon.getIconHeight() / icon.getIconWidth();
        }
        if (nh > h) {
            nh = h;
            nw = icon.getIconWidth() * nh / icon.getIconHeight();
        }
        return new ImageIcon(icon.getImage().getScaledInstance(nw, nh, 4));
    }

    public static URL getResource(String name, Class<?> clazz) {
        return clazz.getClassLoader().getResource(name);
    }

    public static MouseListener createURLMouseListener(final JLabel label, final String url, final String text) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (IOException | URISyntaxException ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setText(text);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setText("<html><a href=''>" + url + "</a></html>");
            }
        };
    }

    public static void setTextFieldDefaultOrPrefs(JTextComponent tf, String actualValue, String defaultValue, String prefKey, Class<?> klass) {
        if (actualValue == null || actualValue.equals(defaultValue)) {
            PrefService prefService = (PrefService)TMUtils.getContext().getService(PrefService.class);
            String val = prefService.get(klass, prefKey, defaultValue);
            tf.setText(val);
            return;
        }
        tf.setText(actualValue);
    }
}

