/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.model;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotRoi;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.util.Util;
import sc.fiji.labkit.ui.labeling.Labeling;

public class TMLabKitUtils {
    static final int timeAxis(Labeling labeling) {
        List axes = labeling.axes();
        for (int d = 0; d < axes.size(); ++d) {
            CalibratedAxis axis = (CalibratedAxis)axes.get(d);
            if (!axis.type().equals(Axes.TIME)) continue;
            return d;
        }
        return -1;
    }

    static final void boundingBox(Spot spot, ImgPlus<UnsignedIntType> img, long[] min, long[] max) {
        double[] calibration = TMUtils.getSpatialCalibration(img);
        SpotRoi roi = spot.getRoi();
        if (roi == null) {
            double cx = spot.getDoublePosition(0);
            double cy = spot.getDoublePosition(1);
            double r = spot.getFeature("RADIUS");
            min[0] = (long)Math.floor((cx - r) / calibration[0]);
            min[1] = (long)Math.floor((cy - r) / calibration[1]);
            max[0] = (long)Math.ceil((cx + r) / calibration[0]);
            max[1] = (long)Math.ceil((cy + r) / calibration[1]);
        } else {
            double[] x = roi.toPolygonX(calibration[0], 0.0, spot.getDoublePosition(0), 1.0);
            double[] y = roi.toPolygonY(calibration[1], 0.0, spot.getDoublePosition(1), 1.0);
            min[0] = (long)Math.floor(Util.min((double[])x));
            min[1] = (long)Math.floor(Util.min((double[])y));
            max[0] = (long)Math.ceil(Util.max((double[])x));
            max[1] = (long)Math.ceil(Util.max((double[])y));
        }
        min[0] = Math.max(0L, min[0]);
        min[1] = Math.max(0L, min[1]);
        long width = img.min(img.dimensionIndex(Axes.X)) + img.dimension(img.dimensionIndex(Axes.X));
        long height = img.min(img.dimensionIndex(Axes.Y)) + img.dimension(img.dimensionIndex(Axes.Y));
        max[0] = Math.min(width, max[0]);
        max[1] = Math.min(height, max[1]);
    }

    static final Img<UnsignedIntType> copy(RandomAccessibleInterval<UnsignedIntType> in) {
        ImgFactory factory = Util.getArrayOrCellImgFactory(in, (NativeType)((NativeType)in.getType()));
        Img out = factory.create(in);
        LoopBuilder.setImages(in, (RandomAccessibleInterval)out).multiThreaded().forEachPixel((i, o) -> o.setInteger(i.getInteger()));
        return out;
    }

    public static final boolean isDifferent(RandomAccessibleInterval<UnsignedIntType> previousIndexImg, RandomAccessibleInterval<UnsignedIntType> indexImg) {
        AtomicBoolean modified = new AtomicBoolean(false);
        LoopBuilder.setImages(previousIndexImg, indexImg).multiThreaded().forEachChunk(chunk -> {
            if (modified.get()) {
                return null;
            }
            chunk.forEachPixel((p1, p2) -> {
                if (p1.getInteger() != p2.getInteger()) {
                    modified.set(true);
                    return;
                }
            });
            return null;
        });
        return modified.get();
    }

    static final Set<Integer> getModifiedIndices(RandomAccessibleInterval<UnsignedIntType> img1, RandomAccessibleInterval<UnsignedIntType> img2) {
        ConcurrentSkipListSet<Integer> modifiedIDs = new ConcurrentSkipListSet<Integer>();
        LoopBuilder.setImages(img1, img2).multiThreaded(false).forEachPixel((c, p) -> {
            int ci = c.getInteger();
            int pi = p.getInteger();
            if (ci == 0 && pi == 0) {
                return;
            }
            if (ci != pi) {
                modifiedIDs.add(pi);
                modifiedIDs.add(ci);
            }
        });
        modifiedIDs.remove(0);
        return modifiedIDs;
    }
}

