/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.geometry;

import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.geometry.GeometryMatrix;
import org.ojalgo.matrix.geometry.Primitive64Vector3;
import org.ojalgo.matrix.geometry.Primitive64Vector4;
import org.ojalgo.matrix.transformation.TransformationMatrix;

public class Primitive64Matrix4
implements GeometryMatrix<Primitive64Matrix4>,
TransformationMatrix<Double, Primitive64Vector4> {
    public double m00;
    public double m10;
    public double m20;
    public double m30;
    public double m01;
    public double m11;
    public double m21;
    public double m31;
    public double m02;
    public double m12;
    public double m22;
    public double m32;
    public double m03;
    public double m13;
    public double m23;
    public double m33;

    public Primitive64Matrix4() {
    }

    public Primitive64Matrix4(double m00, double m10, double m20, double m30, double m01, double m11, double m21, double m31, double m02, double m12, double m22, double m32, double m03, double m13, double m23, double m33) {
        this.m00 = m00;
        this.m10 = m10;
        this.m20 = m20;
        this.m30 = m30;
        this.m01 = m01;
        this.m11 = m11;
        this.m21 = m21;
        this.m31 = m31;
        this.m02 = m02;
        this.m12 = m12;
        this.m22 = m22;
        this.m32 = m32;
        this.m03 = m03;
        this.m13 = m13;
        this.m23 = m23;
        this.m33 = m33;
    }

    @Override
    public final long countColumns() {
        return 4L;
    }

    @Override
    public final long countRows() {
        return 4L;
    }

    @Override
    public final double doubleValue(int row, int col) {
        switch (col) {
            case 0: {
                switch (row) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m10;
                    }
                    case 2: {
                        return this.m20;
                    }
                    case 3: {
                        return this.m30;
                    }
                }
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return this.m01;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m21;
                    }
                    case 3: {
                        return this.m31;
                    }
                }
            }
            case 2: {
                switch (row) {
                    case 0: {
                        return this.m02;
                    }
                    case 1: {
                        return this.m12;
                    }
                    case 2: {
                        return this.m22;
                    }
                    case 3: {
                        return this.m32;
                    }
                }
            }
            case 3: {
                switch (row) {
                    case 0: {
                        return this.m03;
                    }
                    case 1: {
                        return this.m13;
                    }
                    case 2: {
                        return this.m23;
                    }
                    case 3: {
                        return this.m33;
                    }
                }
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Primitive64Matrix4)) {
            return false;
        }
        Primitive64Matrix4 other = (Primitive64Matrix4)obj;
        if (Double.doubleToLongBits(this.m00) != Double.doubleToLongBits(other.m00)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m01) != Double.doubleToLongBits(other.m01)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m02) != Double.doubleToLongBits(other.m02)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m03) != Double.doubleToLongBits(other.m03)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m10) != Double.doubleToLongBits(other.m10)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m11) != Double.doubleToLongBits(other.m11)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m12) != Double.doubleToLongBits(other.m12)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m13) != Double.doubleToLongBits(other.m13)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m20) != Double.doubleToLongBits(other.m20)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m21) != Double.doubleToLongBits(other.m21)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m22) != Double.doubleToLongBits(other.m22)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m23) != Double.doubleToLongBits(other.m23)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m30) != Double.doubleToLongBits(other.m30)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m31) != Double.doubleToLongBits(other.m31)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m32) != Double.doubleToLongBits(other.m32)) {
            return false;
        }
        return Double.doubleToLongBits(this.m33) == Double.doubleToLongBits(other.m33);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.m00);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m01);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m02);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m03);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m10);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m11);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m12);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m13);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m20);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m21);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m22);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m23);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m30);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m31);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m32);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m33);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public final void multiply(Primitive64Vector3 right, double right3, Primitive64Vector3 product) {
        double right0 = right.v0;
        double right1 = right.v1;
        double right2 = right.v2;
        product.v0 = this.m00 * right0 + this.m01 * right1 + this.m02 * right2 + this.m03 * right3;
        product.v1 = this.m10 * right0 + this.m11 * right1 + this.m12 * right2 + this.m13 * right3;
        product.v2 = this.m20 * right0 + this.m21 * right1 + this.m22 * right2 + this.m23 * right3;
    }

    public final void multiply(Primitive64Vector4 right, Primitive64Vector4 product) {
        double right0 = right.v0;
        double right1 = right.v1;
        double right2 = right.v2;
        double right3 = right.v3;
        product.v0 = this.m00 * right0 + this.m01 * right1 + this.m02 * right2 + this.m03 * right3;
        product.v1 = this.m10 * right0 + this.m11 * right1 + this.m12 * right2 + this.m13 * right3;
        product.v2 = this.m20 * right0 + this.m21 * right1 + this.m22 * right2 + this.m23 * right3;
        product.v3 = this.m30 * right0 + this.m31 * right1 + this.m32 * right2 + this.m33 * right3;
    }

    @Override
    public final void negate(Primitive64Matrix4 matrix) {
        this.m00 = -matrix.m00;
        this.m01 = -matrix.m01;
        this.m02 = -matrix.m02;
        this.m03 = -matrix.m03;
        this.m10 = -matrix.m10;
        this.m11 = -matrix.m11;
        this.m12 = -matrix.m12;
        this.m13 = -matrix.m13;
        this.m20 = -matrix.m20;
        this.m21 = -matrix.m21;
        this.m22 = -matrix.m22;
        this.m23 = -matrix.m23;
        this.m30 = -matrix.m30;
        this.m31 = -matrix.m31;
        this.m32 = -matrix.m32;
        this.m33 = -matrix.m33;
    }

    public final String toString() {
        return Access2D.toString(this);
    }

    public final void transform(Primitive64Vector3 transformable, double v3) {
        this.multiply(transformable, v3, transformable);
    }

    @Override
    public final void transform(Primitive64Vector4 transformable) {
        this.multiply(transformable, transformable);
    }

    @Override
    public final void transpose(Primitive64Matrix4 matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m10;
        this.m02 = matrix.m20;
        this.m03 = matrix.m30;
        this.m10 = matrix.m01;
        this.m11 = matrix.m11;
        this.m12 = matrix.m21;
        this.m13 = matrix.m31;
        this.m20 = matrix.m02;
        this.m21 = matrix.m12;
        this.m22 = matrix.m22;
        this.m23 = matrix.m32;
        this.m30 = matrix.m03;
        this.m31 = matrix.m13;
        this.m32 = matrix.m23;
        this.m33 = matrix.m33;
    }
}

