/*
 * Decompiled with CFR 0.152.
 */
package bdv.spimdata;

import bdv.ViewerImgLoader;
import bdv.ViewerSetupImgLoader;
import bdv.cache.CacheControl;
import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicSetupImgLoader;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.realtransform.AffineTransform3D;

public class WrapBasicImgLoader
implements ViewerImgLoader {
    private static final double[][] mipmapResolutions = new double[][]{{1.0, 1.0, 1.0}};
    private static final AffineTransform3D[] mipmapTransforms = new AffineTransform3D[]{new AffineTransform3D()};
    private static final CacheControl cache = new CacheControl.Dummy();
    private final HashMap<Integer, WrapSetupImgLoader<?, ?>> wrapped;
    private final BasicImgLoader source;

    public static boolean wrapImgLoaderIfNecessary(AbstractSpimData<?> spimData) {
        AbstractSequenceDescription seq = spimData.getSequenceDescription();
        BasicImgLoader imgLoader = seq.getImgLoader();
        if (!(imgLoader instanceof ViewerImgLoader)) {
            WrapBasicImgLoader.setImgLoader(seq, (BasicImgLoader)new WrapBasicImgLoader(imgLoader, seq.getViewSetups()));
            return true;
        }
        return false;
    }

    public static boolean removeWrapperIfPresent(AbstractSpimData<?> spimData) {
        AbstractSequenceDescription seq = spimData.getSequenceDescription();
        BasicImgLoader imgLoader = seq.getImgLoader();
        if (imgLoader instanceof WrapBasicImgLoader) {
            WrapBasicImgLoader.setImgLoader(seq, ((WrapBasicImgLoader)imgLoader).source);
            return true;
        }
        return false;
    }

    private static <L extends BasicImgLoader> void setImgLoader(AbstractSequenceDescription<?, ?, L> seq, BasicImgLoader newLoader) {
        seq.setImgLoader(newLoader);
    }

    public WrapBasicImgLoader(BasicImgLoader source, Map<Integer, ?> setupsMap) {
        this.source = source;
        this.wrapped = new HashMap();
        for (int setupId : setupsMap.keySet()) {
            this.wrapped.put(setupId, new WrapSetupImgLoader(source.getSetupImgLoader(setupId)));
        }
    }

    @Override
    public ViewerSetupImgLoader<?, ?> getSetupImgLoader(int setupId) {
        return this.wrapped.get(setupId);
    }

    @Override
    public CacheControl getCacheControl() {
        return cache;
    }

    private class WrapSetupImgLoader<T, V extends Volatile<T>>
    implements ViewerSetupImgLoader<T, V> {
        private final BasicSetupImgLoader<T> source;

        private WrapSetupImgLoader(BasicSetupImgLoader<T> source) {
            this.source = source;
        }

        public RandomAccessibleInterval<T> getImage(int timepointId, ImgLoaderHint ... hints) {
            return this.source.getImage(timepointId, hints);
        }

        public RandomAccessibleInterval<T> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
            return this.source.getImage(timepointId, hints);
        }

        public T getImageType() {
            return (T)this.source.getImageType();
        }

        @Override
        public RandomAccessibleInterval<V> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V getVolatileImageType() {
            return null;
        }

        public double[][] getMipmapResolutions() {
            return mipmapResolutions;
        }

        public AffineTransform3D[] getMipmapTransforms() {
            return mipmapTransforms;
        }

        public int numMipmapLevels() {
            return 1;
        }
    }
}

