/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.AbstractSource;
import bdv.viewer.Interpolation;
import java.util.Arrays;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Intervals;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;

public class RandomAccessibleSource4D<T extends NumericType<T>>
extends AbstractSource<T> {
    private final RandomAccessible<T> source;
    private final Interval interval;
    private final Interval timeSliceInterval;
    protected int currentTimePointIndex;
    private RandomAccessibleInterval<T> currentSource;
    private final RealRandomAccessible<T>[] currentInterpolatedSources;
    private final AffineTransform3D sourceTransform;

    public RandomAccessibleSource4D(RandomAccessible<T> img, Interval interval, T type, String name) {
        this(img, interval, type, new AffineTransform3D(), name, false);
    }

    public RandomAccessibleSource4D(RandomAccessible<T> img, Interval interval, T type, AffineTransform3D sourceTransform, String name) {
        this(img, interval, type, sourceTransform, name, false);
    }

    public RandomAccessibleSource4D(RandomAccessible<T> img, Interval interval, T type, AffineTransform3D sourceTransform, String name, boolean doBoundingBoxCulling) {
        super(type, name, doBoundingBoxCulling);
        this.source = img;
        this.interval = interval;
        this.timeSliceInterval = Intervals.createMinMax(interval.min(0), interval.min(1), interval.min(2), interval.max(0), interval.max(1), interval.max(2));
        this.sourceTransform = sourceTransform;
        this.currentInterpolatedSources = new RealRandomAccessible[Interpolation.values().length];
        this.loadTimepoint(0);
    }

    private void loadTimepoint(int timepointIndex) {
        this.currentTimePointIndex = timepointIndex;
        if (this.isPresent(timepointIndex)) {
            NumericType zero = (NumericType)this.getType().createVariable();
            zero.setZero();
            MixedTransformView<T> slice = Views.hyperSlice(this.source, 3, (long)timepointIndex);
            this.currentSource = Views.interval(slice, this.timeSliceInterval);
            for (Interpolation method : Interpolation.values()) {
                this.currentInterpolatedSources[method.ordinal()] = Views.interpolate(slice, this.interpolators.get(method));
            }
        } else {
            this.currentSource = null;
            Arrays.fill(this.currentInterpolatedSources, null);
        }
    }

    @Override
    public boolean isPresent(int t) {
        return this.interval.min(3) <= (long)t && (long)t <= this.interval.max(3);
    }

    @Override
    public RandomAccessibleInterval<T> getSource(int t, int level) {
        if (t != this.currentTimePointIndex) {
            this.loadTimepoint(t);
        }
        return this.currentSource;
    }

    @Override
    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        if (t != this.currentTimePointIndex) {
            this.loadTimepoint(t);
        }
        return this.currentInterpolatedSources[method.ordinal()];
    }

    @Override
    public synchronized void getSourceTransform(int t, int level, AffineTransform3D transform) {
        transform.set(this.sourceTransform);
    }
}

