/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging.filters;

import ij.process.ImageProcessor;
import ini.trakem2.imaging.filters.IFilter;
import java.util.Map;

public class GaussianBlur
implements IFilter {
    protected double sigmaX = 2.0;
    protected double sigmaY = 2.0;
    protected double accuracy = 0.002;

    public GaussianBlur() {
    }

    public GaussianBlur(double sigmaX, double sigmaY, double accuracy) {
        this.sigmaX = sigmaX;
        this.sigmaY = sigmaY;
        this.accuracy = accuracy;
    }

    public GaussianBlur(Map<String, String> params) {
        try {
            this.sigmaX = Double.parseDouble(params.get("sigmax"));
            this.sigmaY = Double.parseDouble(params.get("sigmay"));
            this.accuracy = Double.parseDouble(params.get("accuracy"));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Could not create Smooth filter!", nfe);
        }
    }

    @Override
    public ImageProcessor process(ImageProcessor ip) {
        ij.plugin.filter.GaussianBlur g = new ij.plugin.filter.GaussianBlur();
        g.blurGaussian(ip, this.sigmaX, this.sigmaY, this.accuracy);
        return ip;
    }

    @Override
    public String toXML(String indent) {
        return indent + "<t2_filter class=\"" + this.getClass().getName() + "\" sigmax=\"" + this.sigmaX + "\" sigmay=\"" + this.sigmaY + "\" accuracy=\"" + this.accuracy + "\" />\n";
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o.getClass() == GaussianBlur.class) {
            GaussianBlur g = (GaussianBlur)o;
            return this.sigmaX == g.sigmaX && this.sigmaY == g.sigmaY && this.accuracy == g.accuracy;
        }
        return false;
    }
}

