/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJClassifier;
import VolumeJ.VJClassifierIsosurface;
import VolumeJ.VJClassifierLevoy;
import VolumeJ.VJClassifierValue;
import VolumeJ.VJClassifiers;
import VolumeJ.VJCutout;
import VolumeJ.VJInterpolator;
import VolumeJ.VJIsosurfaceRender;
import VolumeJ.VJLight;
import VolumeJ.VJNearestNeighbor;
import VolumeJ.VJPhongShader;
import VolumeJ.VJRender;
import VolumeJ.VJRenderView;
import VolumeJ.VJRenderViewCine;
import VolumeJ.VJRenderViewInteractive;
import VolumeJ.VJRenderViewSingle;
import VolumeJ.VJRenderViewStereo;
import VolumeJ.VJRenderer;
import VolumeJ.VJShader;
import VolumeJ.VJTrilinear;
import VolumeJ.VJViewerCanvas;
import VolumeJ.VJViewspaceRender;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.frame.PlugInFrame;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import volume.Volume;
import volume.VolumeFloat;
import volume.VolumeRGB;
import volume.VolumeShort;

public class VJUserInterface
extends PlugInFrame
implements ActionListener,
ClipboardOwner,
ItemListener,
KeyListener {
    protected Button render;
    protected Button renderCine;
    protected Button renderStereo;
    protected Button renderStop;
    protected Button renderExtra;
    protected Choice gradientChoice;
    protected Choice classificationChoice;
    protected Choice axisChoice;
    protected Choice sourceChoice;
    protected Choice indexChoice;
    protected Choice mappingChoice;
    protected Choice interpolationChoice;
    protected Choice lutChoice;
    protected Checkbox testCheckbox;
    protected Checkbox cutoutCheckbox;
    protected Checkbox traceCheckbox;
    protected Checkbox backCheckbox;
    protected Checkbox diskCheckbox;
    protected TextField[] rotField;
    protected TextField[] aspectField;
    protected TextField[] lightField;
    protected TextField[] cutoutField;
    protected TextField[] traceField;
    protected TextField cineField;
    protected TextField cineNField;
    protected TextField widthField;
    protected TextField thresholdField;
    protected TextField scaleField;
    protected TextArea classifierTextArea;
    protected static String defaultDirectory = null;
    protected int[] iList;
    protected static final String VERSION = "1.8";
    protected static final int RAYTRACE = 0;
    protected static final int ISOSURFACE = 1;
    protected static final int VIEWSPACE = 2;
    protected VJRenderView rs;
    protected VJRenderer renderer;
    protected Volume v;
    protected VJShader shader;
    protected VJClassifier classifier;
    protected static int number = 0;
    protected static int axis = 0;
    protected static int interpolation;
    protected static float aspectx;
    protected static float aspecty;
    protected static float aspectz;
    protected static float scale;
    protected static float xrot;
    protected static float yrot;
    protected static float zrot;
    protected static float lightx;
    protected static float lighty;
    protected static float lightz;
    protected static float threshold;
    protected static float deviation;
    static Frame instance;
    protected boolean initializing = false;

    public VJUserInterface() {
        super("VolumeJ");
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow((Frame)((Object)this));
        instance = this;
        this.showDialog();
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowClosing(WindowEvent e) {
        super.windowClosing(e);
        instance = null;
        if (this.rs instanceof VJRenderView) {
            this.rs.kill();
        }
        this.rs = null;
        this.v = null;
        this.renderer = null;
        System.gc();
        VJUserInterface vJUserInterface = this;
        synchronized (vJUserInterface) {
            this.notify();
        }
    }

    public void showDialog() {
        this.initializing = true;
        this.setTitle("VolumeJ 1.8");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constr = new GridBagConstraints();
        this.setLayout(layout);
        Panel buttons = new Panel();
        constr.weightx = 1.0;
        constr.anchor = 11;
        constr.insets = new Insets(10, 10, 10, 10);
        layout.setConstraints(buttons, constr);
        this.add(buttons);
        buttons.setLayout(new GridLayout(0, 1));
        Panel allParams = new Panel();
        constr.gridwidth = 0;
        constr.anchor = 12;
        layout.setConstraints(allParams, constr);
        this.add(allParams);
        allParams.setLayout(new FlowLayout());
        Panel classifierOptions = new Panel();
        constr.weightx = 0.0;
        constr.anchor = 17;
        constr.fill = 0;
        layout.setConstraints(classifierOptions, constr);
        this.add(classifierOptions);
        Label l = new Label("VolumeJ: \u00a92000-2005 michael-abramoff@uiowa.edu", 0);
        buttons.add(l);
        Label l1 = new Label("Volume visualization in Java. Now supports macros", 0);
        buttons.add(l1);
        buttons.setLayout(new GridLayout(0, 1));
        this.render = new Button("Render");
        this.render.addActionListener(this);
        buttons.add(this.render);
        this.renderCine = new Button("Render Cine-mode");
        this.renderCine.addActionListener(this);
        buttons.add(this.renderCine);
        this.renderStereo = new Button("Render stereo pair (\u0394=" + IJ.d2s((double)5.0, (int)1) + "\u00ba)");
        this.renderStereo.addActionListener(this);
        buttons.add(this.renderStereo);
        this.renderStop = new Button("Stop renderer");
        this.renderStop.addActionListener(this);
        buttons.add(this.renderStop);
        this.renderStop.setEnabled(false);
        this.renderExtra = new Button("Interactive rendering");
        this.renderExtra.addActionListener(this);
        buttons.add(this.renderExtra);
        this.diskCheckbox = new Checkbox("Cine rendering to disk, do not display.");
        this.diskCheckbox.setState(false);
        this.diskCheckbox.addItemListener(this);
        buttons.add(this.diskCheckbox);
        this.backCheckbox = new Checkbox("Render backfaces (MRI's)");
        this.backCheckbox.setState(false);
        this.backCheckbox.addItemListener(this);
        buttons.add(this.backCheckbox);
        this.iList = this.getImageWindows();
        String[] stitles = this.getWindowNames(this.iList);
        if (this.iList.length > 0) {
            this.sourceChoice = this.createChoice(buttons, "Volume stack", stitles, 0);
            this.sourceChoice.addItemListener(this);
        }
        if (this.iList.length > 1) {
            this.indexChoice = this.createChoice(buttons, "Index stack, if any", stitles, 1);
            this.indexChoice.addItemListener(this);
        }
        String[] smapping = new String[]{VJRender.desc() + " rendering algorithm", VJIsosurfaceRender.desc() + " rendering algorithm", VJViewspaceRender.desc() + " rendering algorithm"};
        this.mappingChoice = this.createChoice(buttons, "", smapping, 0);
        layout = new GridBagLayout();
        classifierOptions.setLayout(layout);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.anchor = 17;
        String[] sclassifiers = VJClassifiers.getNames();
        this.classificationChoice = this.createChoice(classifierOptions, constr, layout, "Classifier:", sclassifiers, 0);
        if (this.indexChoice instanceof Choice) {
            this.indexChoice.setEnabled(true);
        }
        Label lT = new Label("Description", 2);
        constr.gridwidth = -1;
        layout.setConstraints(lT, constr);
        classifierOptions.add(lT);
        this.classifierTextArea = new TextArea("", 3, 60, 3);
        this.classifierTextArea.setEditable(false);
        constr.gridwidth = 0;
        layout.setConstraints(this.classifierTextArea, constr);
        classifierOptions.add(this.classifierTextArea);
        String[] sluts = new String[]{"spectrum LUT", "load custom"};
        this.lutChoice = this.createChoice(classifierOptions, constr, layout, "Index LUT type", sluts, 0);
        this.thresholdField = this.createTextField(classifierOptions, constr, layout, "Classifier threshold:", "" + threshold, 4);
        this.widthField = this.createTextField(classifierOptions, constr, layout, "Classifier deviation:", "" + deviation, 4);
        this.propagateClassifier();
        Panel params1 = new Panel();
        params1.setLayout(new GridLayout(0, 2));
        String[] sxyz = new String[]{"" + xrot, "" + yrot, "" + zrot};
        this.rotField = this.createXYZField(params1, "Rotation(\u00ba):", sxyz, 1);
        this.scaleField = this.createTextField(params1, "Scaling:", "" + scale, 1);
        if (this.iList.length > 0) {
            ImagePlus imp = WindowManager.getImage((int)this.iList[this.sourceChoice.getSelectedIndex()]);
            Calibration c = imp.getCalibration();
            aspectz = (float)(c.pixelDepth / c.pixelWidth);
        }
        String[] saspect = new String[]{"" + aspectx, "" + aspecty, "" + aspectz};
        this.aspectField = this.createXYZField(params1, "Aspect ratios:", saspect, 1);
        String[] sinterpolation = new String[]{"nearest neighbor", "trilinear"};
        this.interpolationChoice = this.createChoice(params1, "Interpolation", sinterpolation, 1);
        this.cineNField = this.createTextField(params1, "Cine total rotation(\u00ba):", "360", 1);
        this.cineField = this.createTextField(params1, "Cine frame increment(\u00ba):", "10", 1);
        String[] sAxis = new String[]{"x", "y", "z"};
        this.axisChoice = this.createChoice(params1, "Cine rotation axis", sAxis, 1);
        String[] slight = new String[]{"" + lightx, "" + lighty, "" + lightz};
        this.lightField = this.createXYZField(params1, "Light:", slight, 1);
        this.cutoutCheckbox = new Checkbox("Add cutout centered at:");
        this.cutoutCheckbox.setState(false);
        params1.add(this.cutoutCheckbox);
        String[] scutout = new String[]{"10", "10", "10"};
        this.cutoutField = this.createXYZField(params1, scutout, 0);
        this.traceCheckbox = new Checkbox("Print trace for pixel at (x,y):");
        this.traceCheckbox.setState(false);
        params1.add(this.traceCheckbox);
        String[] strace = new String[]{"50", "50"};
        this.traceField = this.createXYZField(params1, strace, 0);
        allParams.add(params1);
        this.pack();
        GUI.center((Window)((Object)this));
        this.setVisible(true);
        this.initializing = false;
        this.activateButtons(this.iList.length);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.perform(e);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.perform(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.perform(e);
    }

    protected void activateButtons(int listLength) {
        this.render.setEnabled(listLength > 0);
        this.renderStereo.setEnabled(listLength > 0);
        this.renderCine.setEnabled(listLength > 0);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    protected void perform(AWTEvent e) {
        if (this.initializing) {
            return;
        }
        aspectx = this.getFloatField(this.aspectField[0]);
        aspecty = this.getFloatField(this.aspectField[1]);
        aspectz = this.getFloatField(this.aspectField[2]);
        threshold = this.getFloatField(this.thresholdField);
        deviation = this.getFloatField(this.widthField);
        scale = this.getFloatField(this.scaleField);
        xrot = this.getFloatField(this.rotField[0]);
        yrot = this.getFloatField(this.rotField[1]);
        zrot = this.getFloatField(this.rotField[2]);
        lightx = this.getFloatField(this.lightField[0]);
        lighty = this.getFloatField(this.lightField[1]);
        lightz = this.getFloatField(this.lightField[2]);
        axis = this.axisChoice.getSelectedIndex();
        interpolation = this.interpolationChoice.getSelectedIndex();
        float cineN = this.getFloatField(this.cineNField);
        float cine = this.getFloatField(this.cineField);
        int classification = this.classificationChoice.getSelectedIndex();
        boolean cineToDisk = this.backCheckbox instanceof Checkbox && this.backCheckbox.getState();
        ImagePlus imp = null;
        imp = this.iList.length > 0 ? WindowManager.getImage((int)this.iList[this.sourceChoice.getSelectedIndex()]) : WindowManager.getCurrentImage();
        ImagePlus impindex = null;
        if (imp != null && this.iList.length > 1) {
            impindex = WindowManager.getImage((int)this.iList[this.indexChoice.getSelectedIndex()]);
        }
        if (e.getSource() == this.render || e.getSource() == this.renderCine || e.getSource() == this.renderStereo || e.getSource() == this.renderExtra) {
            ImagePlus impViewer = null;
            if (e.getSource() == this.renderExtra) {
                ColorProcessor cp = new ColorProcessor(500, 500, new int[250000]);
                cp.setColor(new Color(0xFFFFFF));
                cp.fill();
                impViewer = new ImagePlus("VJViewerCanvas", (ImageProcessor)cp);
                new ImageWindow(impViewer, (ImageCanvas)new VJViewerCanvas(impViewer));
                this.mappingChoice.select(1);
            }
            VJInterpolator interpolator = null;
            interpolator = interpolation == 1 ? new VJTrilinear() : new VJNearestNeighbor();
            if (this.shader == null) {
                this.shader = this.resetShader(lightx, lighty, lightz, aspectx, aspecty, aspectz);
            }
            if (this.classifier == null) {
                this.classifier = this.mappingChoice.getSelectedIndex() == 1 ? this.resetClassifier(1, this.lutChoice.getSelectedIndex()) : this.resetClassifier(classification, this.lutChoice.getSelectedIndex());
            }
            this.renderer = this.resetRenderer(interpolator, this.classifier, this.shader, this.mappingChoice.getSelectedIndex(), this.cutoutCheckbox.getState(), (int)this.getFloatField(this.cutoutField[0]), (int)this.getFloatField(this.cutoutField[1]), (int)this.getFloatField(this.cutoutField[2]), this.traceCheckbox instanceof Checkbox && this.traceCheckbox.getState(), (int)this.getFloatField(this.traceField[0]), (int)this.getFloatField(this.traceField[1]));
            if (this.renderer == null) {
                return;
            }
            if (this.v == null) {
                this.v = VJUserInterface.resetVolume(this.renderer, imp, impindex, aspectx, aspecty, aspectz);
            }
            this.renderer.setVolume(this.v);
            if (e.getSource() == this.render) {
                this.rs = new VJRenderViewSingle(this.renderer, scale, xrot, yrot, zrot, "Rendering[" + number + "]");
            } else if (e.getSource() == this.renderStereo) {
                this.rs = new VJRenderViewStereo(this.renderer, scale, xrot, yrot, zrot, "Rendering[" + number + "]");
            } else if (e.getSource() == this.renderExtra) {
                VJUserInterface.write("renderview init");
                this.rs = new VJRenderViewInteractive(impViewer, this.renderer, scale, "Interactive rendering");
            } else if (e.getSource() == this.renderCine) {
                this.rs = new VJRenderViewCine(this.renderer, scale, xrot, yrot, zrot, "Rendering[" + number + "]", (int)(cineN / cine), cineToDisk);
                switch (axis) {
                    case 0: {
                        ((VJRenderViewCine)this.rs).setRotationSteps(cine, 0.0f, 0.0f);
                        break;
                    }
                    case 1: {
                        ((VJRenderViewCine)this.rs).setRotationSteps(0.0f, cine, 0.0f);
                        break;
                    }
                    case 2: {
                        ((VJRenderViewCine)this.rs).setRotationSteps(0.0f, 0.0f, cine);
                    }
                }
            }
            this.renderStop.setEnabled(true);
            if (IJ.debugMode) {
                IJ.showStatus((String)"render up and starting");
            }
            this.rs.start();
            VJUserInterface.write(this.rs.toString());
            ++number;
        } else if (e.getSource() == this.renderStop) {
            this.rs.kill();
            VJUserInterface.write("Rendering interrupted.");
            this.renderStop.setEnabled(false);
        } else if (e.getSource() == this.sourceChoice || e.getSource() == this.indexChoice) {
            this.v = null;
        } else if (e.getSource() == this.classificationChoice || e.getSource() == this.thresholdField || e.getSource() == this.mappingChoice || e.getSource() == this.lutChoice || e.getSource() == this.widthField) {
            this.propagateClassifier();
        } else if (e.getSource() == this.backCheckbox || e.getSource() == this.lightField[0] || e.getSource() == this.lightField[1] || e.getSource() == this.lightField[2] || e.getSource() == this.rotField[0] || e.getSource() == this.rotField[1] || e.getSource() == this.rotField[2]) {
            this.shader = null;
        } else if (e.getSource() == this.aspectField[0] || e.getSource() == this.aspectField[1] || e.getSource() == this.aspectField[2]) {
            this.v = null;
            this.shader = null;
        }
    }

    protected VJRenderer resetRenderer(VJInterpolator interpolator, VJClassifier classifier, VJShader shader, int algorithm, boolean doCutouts, int cutoutX, int cutoutY, int cutoutZ, boolean doTrace, int traceX, int traceY) {
        try {
            this.renderer = algorithm == 0 ? new VJRender(interpolator, shader, classifier) : (algorithm == 1 ? new VJIsosurfaceRender(interpolator, shader, classifier) : new VJViewspaceRender(interpolator, shader, classifier));
            if (doCutouts) {
                VJCutout cutout = new VJCutout(this.v, cutoutX, cutoutY, cutoutZ, this.renderer.getInterpolator(), this.renderer.getShader(), this.renderer.getClassifier());
                this.renderer.setCutout(cutout);
            }
            if (doTrace) {
                this.renderer.trace(traceX, traceY);
            }
        }
        catch (Exception e) {
            VJUserInterface.write("Cannot create renderer!" + e);
            this.renderer = null;
        }
        return this.renderer;
    }

    public static Volume resetVolume(VJRenderer renderer, ImagePlus imp, ImagePlus impindex, double aspectx, double aspecty, double aspectz) {
        if (IJ.debugMode) {
            VJUserInterface.write("resetting volume");
        }
        Volume v = null;
        if (imp == null || imp.getStackSize() <= 1) {
            IJ.error((String)"Improper or no volume stack selected");
            return null;
        }
        if (imp.getStack().getImageArray()[0] instanceof byte[] || imp.getStack().getImageArray()[0] instanceof short[]) {
            try {
                v = new VolumeShort(imp.getStack(), aspectx, aspecty, aspectz);
            }
            catch (Exception exception) {
                // empty catch block
            }
            renderer.setOutputGrayscale();
        } else if (imp.getStack().getImageArray()[0] instanceof int[]) {
            Object[] array = imp.getStack().getImageArray();
            v = new VolumeRGB(array, imp.getStack().getWidth(), imp.getStack().getSize(), aspectx, aspecty, aspectz);
            renderer.setOutputColor();
        } else if (imp.getStack().getImageArray()[0] instanceof float[]) {
            v = new VolumeFloat(imp.getStack(), aspectx, aspecty, aspectz);
            renderer.setOutputGrayscale();
        }
        if (renderer.getClassifier().doesIndex()) {
            if (impindex == null) {
                VJUserInterface.write("" + renderer.getClassifier() + " needs index, but none selected: set to 0.");
            } else if (!(impindex.getStack().getImageArray()[0] instanceof byte[])) {
                IJ.error((String)"Index stack can only be 8-bit");
            } else if (v instanceof VolumeShort) {
                v.setHighBits(impindex.getStack());
            } else if (v instanceof VolumeRGB) {
                ((VolumeRGB)v).setIndex((Object[])((byte[][])impindex.getStack().getImageArray()));
            } else {
                VJUserInterface.write("Indexing implemented for 8 bit grayscale or 32 bit color volumes only.");
            }
        }
        return v;
    }

    protected VJShader resetShader(float lightx, float lighty, float lightz, float aspectx, float aspecty, float aspectz) {
        VJLight light = new VJLight(lightx, lighty, lightz, 0.9f, 0.0f);
        VJPhongShader shader = new VJPhongShader(0.1f, light, this.backCheckbox instanceof Checkbox && this.backCheckbox.getState());
        return shader;
    }

    protected VJClassifier resetClassifier(int index, int lutIndex) {
        VJClassifier classifier = VJClassifiers.getClassifier(index);
        if (classifier instanceof VJClassifierIsosurface) {
            ((VJClassifierIsosurface)classifier).setThreshold(this.getFloatField(this.thresholdField));
        }
        if (classifier instanceof VJClassifierLevoy) {
            ((VJClassifierLevoy)classifier).setThreshold(this.getFloatField(this.thresholdField));
            ((VJClassifierLevoy)classifier).setWidth(this.getFloatField(this.widthField));
        }
        if (classifier.hasLUT() && lutIndex == 1) {
            this.getLUT(classifier, "");
        }
        this.classifierTextArea.setText(classifier.toLongString());
        return classifier;
    }

    protected void propagateClassifier() {
        switch (this.mappingChoice.getSelectedIndex()) {
            case 0: 
            case 2: {
                this.classificationChoice.setEnabled(true);
                if (this.classificationChoice.getSelectedIndex() != 1) break;
                this.classificationChoice.select(0);
                break;
            }
            case 1: {
                this.classificationChoice.setEnabled(false);
                this.classificationChoice.select(1);
            }
        }
        VJClassifier c = VJClassifiers.getClassifier(this.classificationChoice.getSelectedIndex());
        if (c instanceof VJClassifier) {
            if (this.indexChoice instanceof Choice) {
                this.indexChoice.setEnabled(c.doesIndex());
            }
            if (c instanceof VJClassifierIsosurface) {
                this.thresholdField.setEnabled(true);
                this.widthField.setEnabled(false);
                ((VJClassifierIsosurface)c).setThreshold(this.getFloatField(this.thresholdField));
            } else if (c instanceof VJClassifierValue) {
                this.thresholdField.setEnabled(true);
                this.widthField.setEnabled(false);
                ((VJClassifierValue)c).setThreshold(this.getFloatField(this.thresholdField));
            } else if (c instanceof VJClassifierLevoy) {
                this.thresholdField.setEnabled(true);
                this.widthField.setEnabled(true);
                ((VJClassifierLevoy)c).setThreshold(this.getFloatField(this.thresholdField));
                ((VJClassifierLevoy)c).setWidth(this.getFloatField(this.widthField));
            }
            this.lutChoice.setEnabled(c.hasLUT());
            this.classifierTextArea.setText(c.toLongString());
        }
        this.classifier = null;
        this.v = null;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    protected TextField[] createXYZField(Panel p, String s, String[] d, int i) {
        Label ll = new Label(s + "  ", 2);
        p.add(ll);
        Panel xyz = new Panel();
        xyz.setLayout(new GridLayout(0, d.length));
        TextField[] t = new TextField[d.length];
        for (int j = 0; j < d.length; ++j) {
            t[j] = new TextField("" + d[j], i);
            t[j].setEditable(true);
            xyz.add(t[j]);
            t[j].addKeyListener(this);
        }
        p.add(xyz);
        return t;
    }

    protected TextField[] createXYZField(Panel p, String[] d, int i) {
        Panel xyz = new Panel();
        xyz.setLayout(new GridLayout(0, d.length));
        TextField[] t = new TextField[d.length];
        for (int j = 0; j < d.length; ++j) {
            t[j] = new TextField("" + d[j], i);
            t[j].setEditable(true);
            xyz.add(t[j]);
            t[j].addKeyListener(this);
        }
        p.add(xyz);
        return t;
    }

    protected TextField[] createXYZField(Panel[] p, String s, String[] d, int i) {
        Label ll = new Label(s + "  ", 2);
        p[0].add(ll);
        Panel xyz = new Panel();
        xyz.setLayout(new GridLayout(0, d.length));
        TextField[] t = new TextField[d.length];
        for (int j = 0; j < d.length; ++j) {
            t[j] = new TextField("" + d[j], i);
            t[j].setEditable(true);
            xyz.add(t[j]);
            t[j].addKeyListener(this);
        }
        p[1].add(xyz);
        return t;
    }

    protected Choice createChoice(Panel[] p, String s, String[] d, int i) {
        p[0].add(new Label(s + "  ", 2));
        Choice t = new Choice();
        for (int j = 0; j < d.length; ++j) {
            t.addItem(d[j]);
        }
        t.select(i);
        p[1].add(t);
        t.addItemListener(this);
        return t;
    }

    protected Choice createChoice(Panel p, String s, String[] d, int i) {
        p.add(new Label(s + "  ", 2));
        Choice t = new Choice();
        for (int j = 0; j < d.length; ++j) {
            t.addItem(d[j]);
        }
        t.select(i);
        p.add(t);
        t.addItemListener(this);
        return t;
    }

    protected Choice createChoice(Panel p, GridBagConstraints constr, GridBagLayout layout, String s, String[] d, int i) {
        Label l = new Label(s + "  ", 2);
        constr.gridwidth = -1;
        layout.setConstraints(l, constr);
        p.add(l);
        Choice c = new Choice();
        for (int j = 0; j < d.length; ++j) {
            c.addItem(d[j]);
        }
        c.select(i);
        constr.gridwidth = 0;
        layout.setConstraints(c, constr);
        p.add(c);
        c.addItemListener(this);
        return c;
    }

    protected TextField createTextField(Panel p, GridBagConstraints constr, GridBagLayout layout, String s, String d, int i) {
        Label l = new Label(s + "  ", 2);
        constr.gridwidth = -1;
        layout.setConstraints(l, constr);
        p.add(l);
        TextField t = new TextField(d, i);
        t.setEditable(true);
        constr.gridwidth = 0;
        layout.setConstraints(t, constr);
        p.add(t);
        t.addActionListener(this);
        return t;
    }

    protected TextField createTextField(Panel p, String label, String defaultContents, int nrChars) {
        Label l = new Label(label + "  ", 2);
        p.add(l);
        TextField t = new TextField("" + defaultContents, nrChars);
        t.setEditable(true);
        p.add(t);
        t.addKeyListener(this);
        return t;
    }

    protected float getFloatField(TextField t) {
        Float d;
        String s = t.getText();
        try {
            d = new Float(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d.floatValue();
        }
        return 0.0f;
    }

    protected int getIntField(TextField t) {
        Integer d;
        String s = t.getText();
        try {
            d = new Integer(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0;
    }

    protected long getLongField(TextField t) {
        Long d;
        String s = t.getText();
        try {
            d = new Long(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0L;
    }

    protected int[] getImageWindows() {
        int[] idList = WindowManager.getIDList();
        int[] iLongList = idList != null ? new int[idList.length] : new int[]{};
        int inx = 0;
        for (int i = 0; i < iLongList.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)idList[i]);
            if (imp instanceof ImagePlus && imp.getStackSize() > 1) {
                iLongList[i] = idList[i];
                ++inx;
                continue;
            }
            iLongList[i] = 0;
        }
        int[] iList = new int[inx];
        inx = 0;
        for (int i = 0; i < iLongList.length; ++i) {
            if (iLongList[i] == 0) continue;
            iList[inx++] = iLongList[i];
        }
        return iList;
    }

    protected String[] getWindowNames(int[] windows) {
        String[] s = new String[windows.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = WindowManager.getImage((int)windows[i]).getTitle();
            if (s[i] != null) continue;
            s[i] = "";
        }
        return s;
    }

    static void progress(float d) {
        IJ.showProgress((double)d);
    }

    static void error(String s) {
        IJ.error((String)s);
    }

    static void write(String s) {
        if (IJ.getApplet() == null) {
            IJ.log((String)s);
        } else {
            IJ.showStatus((String)s);
        }
    }

    static void status(String s) {
        IJ.showStatus((String)s);
    }

    static void write(StringBuffer s) {
        VJUserInterface.write(s.toString());
    }

    public boolean getLUT(VJClassifier classifier, String path) {
        if (path.equals("")) {
            OpenDialog od = new OpenDialog("Open LUT...", path);
            if (od.getFileName() == null) {
                return false;
            }
            path = od.getDirectory() + od.getFileName();
        }
        IJ.showStatus((String)("Opening: " + path));
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        try {
            int size = this.readLUT(reds, greens, blues, path, false);
            if (size == 0) {
                this.readLUT(reds, greens, blues, path, true);
            }
        }
        catch (IOException e) {
            VJUserInterface.error(e.getMessage());
            return false;
        }
        if (classifier.setLUT(reds, greens, blues)) {
            VJUserInterface.write("Classifier LUT set to: " + path);
            return true;
        }
        IJ.error((String)"Cannot change LUT");
        return false;
    }

    private int readLUT(byte[] reds, byte[] greens, byte[] blues, String path, boolean raw) throws IOException {
        FileInputStream is = new FileInputStream(path);
        DataInputStream f = new DataInputStream(is);
        int nColors = 256;
        if (!raw) {
            int id = f.readInt();
            if (id != 1229147980) {
                return 0;
            }
            short version = f.readShort();
            nColors = f.readShort();
            short start = f.readShort();
            short end = f.readShort();
            long fill1 = f.readLong();
            long fill2 = f.readLong();
            int n = f.readInt();
        }
        f.read(reds, 0, nColors);
        f.read(greens, 0, nColors);
        f.read(blues, 0, nColors);
        if (nColors < 256 || nColors > 256) {
            throw new IOException("LUT not right number of colors: " + nColors);
        }
        f.close();
        return 256;
    }

    static {
        aspectx = 1.0f;
        aspecty = 1.0f;
        aspectz = 1.0f;
        scale = 1.0f;
        xrot = 0.0f;
        yrot = 0.0f;
        zrot = 0.0f;
        lightx = 0.0f;
        lighty = 0.0f;
        lightz = -1000.0f;
        threshold = 128.0f;
        deviation = 2.0f;
        instance = null;
    }
}

