/*
 * Decompiled with CFR 0.152.
 */
package numericalMethods.calculus.minimizing;

import java.io.Serializable;
import numericalMethods.function.nmDoubleParametrized;
import numericalMethods.function.nmDoubleValued;

public final class nmBracket
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double GOLD = 1.618034;
    private static final double GLIMIT = 100.0;
    private static final double TINY = 1.0E-20;

    private static final double copySign(double a, double b) {
        return b <= 0.0 ? -Math.abs(a) : Math.abs(a);
    }

    public static void search(double[] t, double[] fOfT, nmDoubleValued f) {
        double fb;
        nmDoubleParametrized F = (nmDoubleParametrized)((Object)f);
        double dum = 0.0;
        double ax = t[0];
        double bx = t[1];
        F.setDoubleParameter(ax);
        double fa = f.getDoubleValue();
        F.setDoubleParameter(bx);
        double inValue = fb = f.getDoubleValue();
        if (fb > fa) {
            dum = ax;
            ax = bx;
            bx = dum;
            dum = fa;
            fa = fb;
            fb = dum;
        }
        double cx = bx + 1.618034 * (bx - ax);
        F.setDoubleParameter(cx);
        double fc = f.getDoubleValue();
        while (fb > fc) {
            double fu;
            double r = (bx - ax) * (fb - fc);
            double q = (bx - cx) * (fb - fa);
            double u = bx - ((bx - cx) * q - (bx - ax) * r) / (2.0 * nmBracket.copySign(Math.max(Math.abs(q - r), 1.0E-20), q - r));
            double ulim = bx + 100.0 * (cx - bx);
            if ((bx - u) * (u - cx) > 0.0) {
                F.setDoubleParameter(u);
                fu = f.getDoubleValue();
                if (fu < fc) {
                    ax = bx;
                    bx = u;
                    fa = fb;
                    fb = fu;
                    break;
                }
                if (fu > fb) {
                    cx = u;
                    fc = fu;
                    break;
                }
                u = cx + 1.618034 * (cx - bx);
                F.setDoubleParameter(u);
                fu = f.getDoubleValue();
            } else if ((cx - u) * (u - ulim) > 0.0) {
                F.setDoubleParameter(u);
                fu = f.getDoubleValue();
                if (fu < fc) {
                    bx = cx;
                    cx = u;
                    u = cx + 1.618034 * (cx - bx);
                    F.setDoubleParameter(u);
                    fb = fc;
                    fc = fu;
                    fu = f.getDoubleValue();
                }
            } else if ((u - ulim) * (ulim - cx) >= 0.0) {
                u = ulim;
                F.setDoubleParameter(u);
                fu = f.getDoubleValue();
            } else {
                u = cx + 1.618034 * (cx - bx);
                F.setDoubleParameter(u);
                fu = f.getDoubleValue();
            }
            ax = bx;
            bx = cx;
            cx = u;
            fa = fb;
            fb = fc;
            fc = fu;
        }
        t[0] = ax;
        fOfT[0] = fa;
        t[1] = bx;
        fOfT[1] = fb;
        t[2] = cx;
        fOfT[2] = fc;
        if (fb > inValue) {
            System.out.println(" proc nmBracket failed to decrease center value! ");
        }
    }
}

