/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.CustomMesh;
import customnode.CustomMeshNode;
import customnode.WavefrontExporter;
import customnode.WavefrontLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.View;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Tuple3f;

public class CustomMultiMesh
extends CustomMeshNode {
    private List<CustomMesh> customMeshes;

    public CustomMultiMesh() {
        CustomMultiMesh.setCapabilities(this);
        this.customMeshes = new ArrayList<CustomMesh>();
        this.calculateMinMaxCenterPoint();
    }

    public CustomMultiMesh(CustomMesh customMesh) {
        CustomMultiMesh.setCapabilities(this);
        this.customMeshes = new ArrayList<CustomMesh>();
        this.customMeshes.add(customMesh);
        this.calculateMinMaxCenterPoint();
        BranchGroup bg = new BranchGroup();
        CustomMultiMesh.setCapabilities(bg);
        bg.addChild((Node)customMesh);
        this.addChild((Node)bg);
    }

    public CustomMultiMesh(List<CustomMesh> meshes) {
        this.customMeshes = meshes;
        this.calculateMinMaxCenterPoint();
        for (CustomMesh m : this.customMeshes) {
            BranchGroup bg = new BranchGroup();
            CustomMultiMesh.setCapabilities(bg);
            bg.addChild((Node)m);
            this.addChild((Node)bg);
        }
    }

    private static void setCapabilities(BranchGroup bg) {
        bg.setCapability(17);
        bg.setCapability(13);
        bg.setCapability(14);
    }

    public void remove(int i) {
        this.customMeshes.remove(i);
        this.calculateMinMaxCenterPoint();
        BranchGroup bg = (BranchGroup)this.getChild(i);
        this.removeChild(i);
        bg.removeAllChildren();
    }

    public void remove(CustomMesh mesh) {
        this.customMeshes.remove((Object)mesh);
        this.calculateMinMaxCenterPoint();
        BranchGroup bg = (BranchGroup)mesh.getParent();
        this.removeChild((Node)bg);
        bg.removeAllChildren();
    }

    public void add(CustomMesh mesh) {
        this.customMeshes.add(mesh);
        this.calculateMinMaxCenterPoint();
        BranchGroup bg = new BranchGroup();
        CustomMultiMesh.setCapabilities(bg);
        bg.addChild((Node)mesh);
        this.addChild((Node)bg);
    }

    public int size() {
        return this.customMeshes.size();
    }

    public CustomMesh getMesh(int i) {
        return this.customMeshes.get(i);
    }

    @Override
    public void getMin(Tuple3d min) {
        min.set((Tuple3f)this.min);
    }

    @Override
    public void getMax(Tuple3d max) {
        max.set((Tuple3f)this.max);
    }

    @Override
    public void getCenter(Tuple3d center) {
        center.set((Tuple3f)this.center);
    }

    @Override
    public void channelsUpdated(boolean[] channels) {
    }

    @Override
    public void colorUpdated(Color3f color) {
        for (CustomMesh mesh : this.customMeshes) {
            mesh.setColor(color);
        }
    }

    @Override
    public void eyePtChanged(View view) {
    }

    @Override
    public float getVolume() {
        float vol = 0.0f;
        for (CustomMesh mesh : this.customMeshes) {
            vol += mesh.getVolume();
        }
        return vol;
    }

    @Override
    public void shadeUpdated(boolean shaded) {
        for (CustomMesh mesh : this.customMeshes) {
            mesh.setShaded(shaded);
        }
    }

    @Override
    public void thresholdUpdated(int threshold) {
    }

    @Override
    public void transparencyUpdated(float transparency) {
        for (CustomMesh mesh : this.customMeshes) {
            mesh.setTransparency(transparency);
        }
    }

    private static void adjustMinMax(Point3f p, Point3f min, Point3f max) {
        if (p.x < min.x) {
            min.x = p.x;
        }
        if (p.y < min.y) {
            min.y = p.y;
        }
        if (p.z < min.z) {
            min.z = p.z;
        }
        if (p.x > max.x) {
            max.x = p.x;
        }
        if (p.y > max.y) {
            max.y = p.y;
        }
        if (p.z > max.z) {
            max.z = p.z;
        }
    }

    private void calculateMinMaxCenterPoint() {
        this.min = new Point3f();
        this.max = new Point3f();
        this.center = new Point3f();
        if (this.customMeshes.isEmpty()) {
            return;
        }
        this.customMeshes.get(0).calculateMinMaxCenterPoint(this.min, this.max, this.center);
        Point3f mint = new Point3f();
        Point3f maxt = new Point3f();
        int n = this.customMeshes.size();
        if (n == 1) {
            return;
        }
        for (int i = 1; i < n; ++i) {
            CustomMesh mesh = this.customMeshes.get(i);
            mesh.calculateMinMaxCenterPoint(mint, maxt, this.center);
            CustomMultiMesh.adjustMinMax(mint, this.min, this.max);
            CustomMultiMesh.adjustMinMax(maxt, this.min, this.max);
        }
        this.center.sub((Tuple3f)this.max, (Tuple3f)this.min);
        this.center.scale(0.5f);
    }

    @Override
    public void restoreDisplayedData(String path, String name) {
        HashMap<String, CustomMesh> contents = null;
        this.customMeshes = null;
        try {
            contents = WavefrontLoader.load(path);
            for (int i = 0; i < contents.size(); ++i) {
                CustomMesh cm = contents.get(name + "###" + i);
                this.customMeshes.add(cm);
                cm.update();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void swapDisplayedData(String path, String name) {
        HashMap<String, CustomMesh> contents = new HashMap<String, CustomMesh>();
        for (int i = 0; i < this.customMeshes.size(); ++i) {
            contents.put(name + "###" + i, this.customMeshes.get(i));
        }
        try {
            WavefrontExporter.save(contents, path + ".obj");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

