/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.DefaultUniverse;
import ij3d.UniverseListener;
import java.util.Iterator;
import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.RotationInterpolator;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.View;
import org.jogamp.vecmath.AxisAngle4d;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector3f;

public abstract class DefaultAnimatableUniverse
extends DefaultUniverse {
    private final Vector3d rotationAxis = new Vector3d(0.0, 1.0, 0.0);
    private final Transform3D centerXform = new Transform3D();
    private final Transform3D animationXform = new Transform3D();
    private final Transform3D rotationXform = new Transform3D();
    private final Transform3D rotate = new Transform3D();
    private final Transform3D centerXformInv = new Transform3D();
    private float rotationInterval = 2.0f;
    private final RotationInterpolator rotpol;
    private final Alpha animation;
    private final TransformGroup animationTG;
    private final TransformGroup rotationTG;
    private ImageStack freehandStack;
    private final Vector3d v1 = new Vector3d();
    private final Vector3d v2 = new Vector3d();
    private final AxisAngle4d aa = new AxisAngle4d();

    public DefaultAnimatableUniverse(int width, int height) {
        super(width, height);
        this.animationTG = this.getAnimationTG();
        this.rotationTG = this.getRotationTG();
        this.updateRotationAxisAndCenter();
        this.animation = new Alpha(-1, 4000L);
        this.animation.pause();
        this.animation.setStartTime(System.currentTimeMillis());
        BranchGroup bg = new BranchGroup();
        this.rotpol = new RotationInterpolator(this.animation, this.animationTG){

            public void processStimulus(Iterator e) {
                super.processStimulus(e);
                if (!DefaultAnimatableUniverse.this.animation.isPaused()) {
                    DefaultAnimatableUniverse.this.fireTransformationUpdated();
                } else {
                    DefaultAnimatableUniverse.this.animationPaused();
                }
            }
        };
        this.rotpol.setTransformAxis(this.centerXform);
        this.rotpol.setSchedulingBounds((Bounds)this.bounds);
        this.rotpol.setEnable(false);
        bg.addChild((Node)this.rotpol);
        this.animationTG.addChild((Node)bg);
        this.addUniverseListener(new UniverseListener(){

            @Override
            public void transformationStarted(View view) {
            }

            @Override
            public void transformationFinished(View view) {
            }

            @Override
            public void contentAdded(Content c) {
            }

            @Override
            public void contentRemoved(Content c) {
            }

            @Override
            public void canvasResized() {
            }

            @Override
            public void universeClosed() {
            }

            @Override
            public void contentSelected(Content c) {
            }

            @Override
            public void transformationUpdated(View view) {
                DefaultAnimatableUniverse.this.addFreehandRecordingFrame();
            }

            @Override
            public void contentChanged(Content c) {
                DefaultAnimatableUniverse.this.addFreehandRecordingFrame();
            }
        });
    }

    public void setRotationInterval(float f) {
        this.rotationInterval = f;
    }

    public float getRotationInterval() {
        return this.rotationInterval;
    }

    private void addFreehandRecordingFrame() {
        if (this.freehandStack == null) {
            return;
        }
        this.win.updateImagePlus();
        ImageProcessor ip = this.win.getImagePlus().getProcessor();
        this.freehandStack.addSlice("", ip);
    }

    public void startFreehandRecording() {
        if (this.freehandStack != null) {
            return;
        }
        this.win.updateImagePlus();
        ImageProcessor ip = this.win.getImagePlus().getProcessor();
        this.freehandStack = new ImageStack(ip.getWidth(), ip.getHeight());
        this.freehandStack.addSlice("", ip);
    }

    public ImagePlus stopFreehandRecording() {
        if (this.freehandStack == null || this.freehandStack.getSize() == 1) {
            return null;
        }
        ImagePlus imp = new ImagePlus("Movie", this.freehandStack);
        this.freehandStack = null;
        return imp;
    }

    public ImagePlus record360() {
        if (this.freehandStack != null) {
            IJ.error((String)"Freehand recording is active. Stop first.");
            return null;
        }
        if (!this.animation.isPaused()) {
            this.pauseAnimation();
        }
        ImageProcessor ip = this.win.getImagePlus().getProcessor();
        ImageStack stack = new ImageStack(ip.getWidth(), ip.getHeight());
        this.updateRotationAxisAndCenter();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.centerXformInv.invert(this.centerXform);
        double deg2 = (double)this.rotationInterval * Math.PI / 180.0;
        int steps = (int)Math.round(Math.PI * 2 / deg2);
        this.getCanvas().getView().stopView();
        double alpha = 0.0;
        for (int i = 0; i < steps; ++i) {
            alpha = (double)i * deg2;
            this.rotationXform.rotY(alpha);
            this.rotate.mul(this.centerXform, this.rotationXform);
            this.rotate.mul(this.rotate, this.centerXformInv);
            this.animationTG.setTransform(this.rotate);
            this.fireTransformationUpdated();
            this.getCanvas().getView().renderOnce();
            this.win.updateImagePlusAndWait();
            ip = this.win.getImagePlus().getProcessor();
            int w = ip.getWidth();
            int h = ip.getHeight();
            if (stack == null) {
                stack = new ImageStack(w, h);
            }
            stack.addSlice("", ip);
        }
        this.getCanvas().getView().startView();
        this.incorporateAnimationInRotation();
        if (stack.getSize() == 0) {
            return null;
        }
        ImagePlus imp = new ImagePlus("Movie", stack);
        return imp;
    }

    public void getRotationAxis(Vector3f ret) {
        ret.set((Tuple3d)this.rotationAxis);
    }

    public void setRotationAxis(Vector3f a) {
        this.rotationAxis.set((Tuple3f)a);
    }

    public void rotateX(double rad) {
        this.viewTransformer.rotateX(rad);
    }

    public void rotateY(double rad) {
        this.viewTransformer.rotateY(rad);
        this.fireTransformationUpdated();
    }

    public void rotateZ(double rad) {
        this.viewTransformer.rotateZ(rad);
    }

    public void startAnimation() {
        this.animationTG.getTransform(this.animationXform);
        this.updateRotationAxisAndCenter();
        this.rotpol.setTransformAxis(this.centerXform);
        this.rotpol.setEnable(true);
        this.animation.resume();
        this.fireTransformationStarted();
    }

    public void pauseAnimation() {
        this.animation.pause();
    }

    private void animationPaused() {
        this.rotpol.setEnable(false);
        this.incorporateAnimationInRotation();
        this.animation.setStartTime(System.currentTimeMillis());
        this.fireTransformationUpdated();
        this.fireTransformationFinished();
    }

    private void incorporateAnimationInRotation() {
        this.rotationTG.getTransform(this.rotationXform);
        this.animationTG.getTransform(this.animationXform);
        this.rotationXform.mul(this.rotationXform, this.animationXform);
        this.animationXform.setIdentity();
        this.animationTG.setTransform(this.animationXform);
        this.rotationTG.setTransform(this.rotationXform);
    }

    private void updateRotationAxisAndCenter() {
        this.v1.set(0.0, 1.0, 0.0);
        this.v2.cross(this.v1, this.rotationAxis);
        double angle = Math.acos(this.v1.dot(this.rotationAxis));
        this.aa.set(this.v2, angle);
        this.centerXform.set(this.aa);
    }
}

