/*
 * Decompiled with CFR 0.152.
 */
package isosurface;

import customnode.CustomMesh;
import customnode.CustomMeshNode;
import customnode.CustomMultiMesh;
import customnode.CustomQuadMesh;
import customnode.CustomTriangleMesh;
import customnode.WavefrontExporter;
import ij.IJ;
import ij3d.Content;
import ij3d.ContentNode;
import ij3d.Executer;
import isosurface.MeshGroup;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3f;
import orthoslice.OrthoGroup;
import surfaceplot.SurfacePlotGroup;
import voltex.VoltexGroup;

public class MeshExporter {
    public static final int ASCII = 0;
    public static final int BINARY = 1;
    private static int mat_index = 1;

    private MeshExporter() {
    }

    private static Collection<Content> filterMeshes(Collection contents) {
        ArrayList<Content> meshes = new ArrayList<Content>();
        for (Content c : contents) {
            ContentNode node = c.getContent();
            if (node instanceof VoltexGroup || node instanceof OrthoGroup || node instanceof SurfacePlotGroup) continue;
            meshes.add(c);
        }
        return meshes;
    }

    @Deprecated
    public static void saveAsWaveFront(Collection contents_) {
        File obj_file = Executer.promptForFile("Save WaveFront", "untitled", ".obj");
        if (obj_file == null) {
            return;
        }
        MeshExporter.saveAsWaveFront(contents_, obj_file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsWaveFront(Collection contents_, File obj_file) {
        if (null == contents_ || 0 == contents_.size()) {
            return;
        }
        Collection<Content> contents = MeshExporter.filterMeshes(contents_);
        if (0 == contents.size()) {
            IJ.log((String)"No meshes to export!");
            return;
        }
        String obj_filename = obj_file.getName();
        String mtl_filename = obj_filename.substring(0, obj_filename.lastIndexOf(46)) + ".mtl";
        File mtl_file = new File(obj_file.getParentFile(), mtl_filename);
        OutputStreamWriter dos_obj = null;
        OutputStreamWriter dos_mtl = null;
        try {
            dos_obj = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(obj_file)), "8859_1");
            dos_mtl = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(mtl_file)), "8859_1");
            MeshExporter.writeAsWaveFront(contents, mtl_filename, dos_obj, dos_mtl);
            dos_obj.flush();
            dos_obj.flush();
        }
        catch (IOException e) {
            IJ.log((String)("Some error ocurred while saving to wavefront:\n" + e));
            e.printStackTrace();
        }
        finally {
            try {
                if (null != dos_obj) {
                    dos_obj.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != dos_mtl) {
                    dos_mtl.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Deprecated
    public static void saveAsDXF(Collection contents_) {
        File dxf_file = Executer.promptForFile("Save as DXF", "untitled", ".dxf");
        if (dxf_file == null) {
            return;
        }
        MeshExporter.saveAsDXF(contents_, dxf_file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsDXF(Collection meshgroups, File dxf_file) {
        if (null == meshgroups || 0 == meshgroups.size()) {
            return;
        }
        if (0 == (meshgroups = MeshExporter.filterMeshes(meshgroups)).size()) {
            IJ.log((String)"No meshes to export!");
            return;
        }
        OutputStreamWriter dos = null;
        try {
            dos = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(dxf_file)), "8859_1");
            MeshExporter.writeDXF(meshgroups, dos);
            dos.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (null != dos) {
                    dos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void writeDXF(Collection contents, Writer w) throws IOException {
        w.write("0\nSECTION\n2\nENTITIES\n");
        for (Content ob : contents) {
            CustomMesh cmesh = null;
            if (ob.getContent() instanceof CustomMeshNode) {
                CustomMeshNode cmeshnode = (CustomMeshNode)ob.getContent();
                cmesh = cmeshnode.getMesh();
            } else {
                if (!(ob.getContent() instanceof MeshGroup)) continue;
                MeshGroup mg = (MeshGroup)ob.getContent();
                cmesh = mg.getMesh();
            }
            List triangles = cmesh.getMesh();
            String title = ob.getName().replaceAll(" ", "_").replaceAll("#", "--");
            Mtl mat = new Mtl(1.0f - ob.getTransparency(), cmesh.getColor());
            MeshExporter.writeTrianglesDXF(w, triangles, title, "" + mat.getAsSingle());
        }
        w.append("0\nENDSEC\n0\nEOF\n");
    }

    @Deprecated
    public static void saveAsSTL(Collection contents_, int filetype) {
        String title = "Save as STL (" + (filetype == 0 ? "ASCII" : "binary") + ")";
        File stl_file = Executer.promptForFile(title, "untitled", ".stl");
        if (stl_file == null) {
            return;
        }
        MeshExporter.saveAsSTL(contents_, stl_file, filetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsSTL(Collection meshgroups, File stl_file, int filetype) {
        if (null == meshgroups || 0 == meshgroups.size()) {
            return;
        }
        if (0 == (meshgroups = MeshExporter.filterMeshes(meshgroups)).size()) {
            IJ.log((String)"No meshes to export!");
            return;
        }
        OutputStreamWriter dos = null;
        FilterOutputStream out = null;
        try {
            if (filetype == 0) {
                dos = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(stl_file)), "8859_1");
                MeshExporter.writeAsciiSTL(meshgroups, dos, stl_file.getName());
                dos.flush();
            } else {
                out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(stl_file)));
                MeshExporter.writeBinarySTL(meshgroups, (DataOutputStream)out);
                ((DataOutputStream)out).flush();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (null != dos) {
                    dos.close();
                }
                if (null != out) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void writeBinarySTL(Collection meshgroups, DataOutputStream out) {
        HashMap<String, CustomMesh> meshes = new HashMap<String, CustomMesh>();
        for (Content mob : meshgroups) {
            Object node = mob.getContent();
            if (node instanceof CustomMultiMesh) {
                CustomMultiMesh multi = (CustomMultiMesh)((Object)node);
                for (int i = 0; i < multi.size(); ++i) {
                    meshes.put(mob.getName() + " [" + (i + 1) + "]", multi.getMesh(i));
                }
                continue;
            }
            if (node instanceof CustomMeshNode) {
                meshes.put(mob.getName(), ((CustomMeshNode)((Object)node)).getMesh());
                continue;
            }
            if (node instanceof MeshGroup) {
                meshes.put(mob.getName(), ((MeshGroup)((Object)node)).getMesh());
                continue;
            }
            IJ.log((String)("Ignoring " + mob.getName() + " with node of class " + ((Object)node).getClass()));
        }
        int triangles = 0;
        ArrayList<List> surfaces = new ArrayList<List>();
        for (String name : meshes.keySet()) {
            CustomMesh cmesh = (CustomMesh)((Object)meshes.get(name));
            if (((Object)((Object)cmesh)).getClass() == CustomQuadMesh.class) {
                IJ.log((String)("Quad meshes are unsupported, can't save " + name + " as STL"));
                continue;
            }
            if (((Object)((Object)cmesh)).getClass() != CustomTriangleMesh.class) {
                IJ.log((String)("Unsupported content type, can't save " + name + " as STL"));
                continue;
            }
            List vertices = cmesh.getMesh();
            triangles += vertices.size() / 3;
            surfaces.add(vertices);
        }
        String header = "Binary STL created by ImageJ 3D Viewer.";
        for (int i = header.length(); i < 80; ++i) {
            header = header + ".";
        }
        try {
            out.writeBytes(header);
            out.writeByte(triangles & 0xFF);
            out.writeByte(triangles >> 8 & 0xFF);
            out.writeByte(triangles >> 16 & 0xFF);
            out.writeByte(triangles >> 24 & 0xFF);
            for (List vertices : surfaces) {
                for (int i = 0; i < vertices.size(); i += 3) {
                    Point3f p0 = (Point3f)vertices.get(i);
                    Point3f p1 = (Point3f)vertices.get(i + 1);
                    Point3f p2 = (Point3f)vertices.get(i + 2);
                    Point3f n = MeshExporter.unitNormal(p0, p1, p2);
                    ByteBuffer bb = ByteBuffer.allocate(50);
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                    bb.putFloat(n.x);
                    bb.putFloat(n.y);
                    bb.putFloat(n.z);
                    bb.putFloat(p0.x);
                    bb.putFloat(p0.y);
                    bb.putFloat(p0.z);
                    bb.putFloat(p1.x);
                    bb.putFloat(p1.y);
                    bb.putFloat(p1.z);
                    bb.putFloat(p2.x);
                    bb.putFloat(p2.y);
                    bb.putFloat(p2.z);
                    bb.putShort((short)0);
                    out.write(bb.array());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Point3f unitNormal(Point3f p0, Point3f p1, Point3f p2) {
        float nx = (p1.y - p0.y) * (p2.z - p0.z) - (p1.z - p0.z) * (p2.y - p0.y);
        float ny = (p1.z - p0.z) * (p2.x - p0.x) - (p1.x - p0.x) * (p2.z - p0.z);
        float nz = (p1.x - p0.x) * (p2.y - p0.y) - (p1.y - p0.y) * (p2.x - p0.x);
        float length = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        return new Point3f(nx /= length, ny /= length, nz /= length);
    }

    private static void writeAsciiSTL(Collection<Content> meshgroups, OutputStreamWriter dos, String stl_filename) {
        try {
            dos.write(" solid ");
            dos.write(stl_filename);
            HashMap<String, CustomMesh> meshes = new HashMap<String, CustomMesh>();
            for (Content mob : meshgroups) {
                ContentNode node = mob.getContent();
                if (node instanceof CustomMultiMesh) {
                    CustomMultiMesh multi = (CustomMultiMesh)node;
                    for (int i = 0; i < multi.size(); ++i) {
                        meshes.put(mob.getName() + " [" + (i + 1) + "]", multi.getMesh(i));
                    }
                    continue;
                }
                if (node instanceof CustomMeshNode) {
                    meshes.put(mob.getName(), ((CustomMeshNode)node).getMesh());
                    continue;
                }
                if (node instanceof MeshGroup) {
                    meshes.put(mob.getName(), ((MeshGroup)node).getMesh());
                    continue;
                }
                IJ.log((String)("Ignoring " + mob.getName() + " with node of class " + ((Object)((Object)node)).getClass()));
            }
            for (String name : meshes.keySet()) {
                CustomMesh cmesh = (CustomMesh)((Object)meshes.get(name));
                if (((Object)((Object)cmesh)).getClass() == CustomQuadMesh.class) {
                    IJ.log((String)("Quad meshes are unsupported, can't save " + name + " as STL"));
                    continue;
                }
                if (((Object)((Object)cmesh)).getClass() != CustomTriangleMesh.class) {
                    IJ.log((String)("Unsupported content type, can't save " + name + " as STL"));
                    continue;
                }
                List vertices = cmesh.getMesh();
                int nPoints = vertices.size();
                for (int p = 0; p < nPoints; p += 3) {
                    Point3f p0 = (Point3f)vertices.get(p);
                    Point3f p1 = (Point3f)vertices.get(p + 1);
                    Point3f p2 = (Point3f)vertices.get(p + 2);
                    Point3f n = MeshExporter.unitNormal(p0, p1, p2);
                    String e = "%E";
                    dos.write("\nfacet normal ");
                    dos.write(String.format("%E", Float.valueOf(n.x)) + " ");
                    dos.write(String.format("%E", Float.valueOf(n.y)) + " ");
                    dos.write(String.format("%E", Float.valueOf(n.z)) + "\n");
                    dos.write(" outer loop\n");
                    dos.write("  vertex ");
                    dos.write(String.format("%E", Float.valueOf(p0.x)) + " ");
                    dos.write(String.format("%E", Float.valueOf(p0.y)) + " ");
                    dos.write(String.format("%E", Float.valueOf(p0.z)) + "\n");
                    dos.write("  vertex ");
                    dos.write(String.format("%E", Float.valueOf(p1.x)) + " ");
                    dos.write(String.format("%E", Float.valueOf(p1.y)) + " ");
                    dos.write(String.format("%E", Float.valueOf(p1.z)) + "\n");
                    dos.write("  vertex ");
                    dos.write(String.format("%E", Float.valueOf(p2.x)) + " ");
                    dos.write(String.format("%E", Float.valueOf(p2.y)) + " ");
                    dos.write(String.format("%E", Float.valueOf(p2.z)) + "\n");
                    dos.write(" endloop\n");
                    dos.write("endfacet");
                }
            }
            dos.write("\n endsolid ");
            dos.write(stl_filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static String createDXF(Collection contents) {
        StringWriter sw = new StringWriter();
        try {
            MeshExporter.writeDXF(contents, sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Deprecated
    public static void writeTrianglesDXF(StringBuffer sb, List triangles, String the_group, String the_color) {
        try {
            StringWriter sw = new StringWriter();
            MeshExporter.writeTrianglesDXF(sw, triangles, the_group, the_color);
            sb.append(sw.getBuffer());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void writeTrianglesDXF(Writer w, List triangles, String the_group, String the_color) throws IOException {
        int L = 10;
        String s10 = "10\n";
        String s11 = "11\n";
        String s12 = "12\n";
        String s13 = "13\n";
        String s20 = "20\n";
        String s21 = "21\n";
        String s22 = "22\n";
        String s23 = "23\n";
        String s30 = "30\n";
        String s31 = "31\n";
        String s32 = "32\n";
        String s33 = "33\n";
        String triangle_header = "0\n3DFACE\n8\n" + the_group + "\n6\nCONTINUOUS\n62\n" + the_color + '\n';
        int len = triangles.size();
        Point3f[] vert = new Point3f[len];
        triangles.toArray(vert);
        StringBuffer sb = new StringBuffer(150);
        for (int i = 0; i < len; i += 3) {
            w.write(triangle_header);
            sb.append("10\n").append(vert[i].x).append('\n').append("20\n").append(vert[i].y).append('\n').append("30\n").append(vert[i].z).append('\n').append("11\n").append(vert[i + 1].x).append('\n').append("21\n").append(vert[i + 1].y).append('\n').append("31\n").append(vert[i + 1].z).append('\n').append("12\n").append(vert[i + 2].x).append('\n').append("22\n").append(vert[i + 2].y).append('\n').append("32\n").append(vert[i + 2].z).append('\n').append("13\n").append(vert[i + 2].x).append('\n').append("23\n").append(vert[i + 2].y).append('\n').append("33\n").append(vert[i + 2].z).append('\n');
            w.write(sb.toString());
            sb.setLength(0);
        }
    }

    @Deprecated
    public static String[] createWaveFront(Collection contents, String mtl_filename) {
        StringWriter sw_obj = new StringWriter();
        StringWriter sw_mtl = new StringWriter();
        try {
            MeshExporter.writeAsWaveFront(contents, mtl_filename, sw_obj, sw_mtl);
            return new String[]{sw_obj.toString(), sw_mtl.toString()};
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static void writeAsWaveFront(Collection contents, String mtl_filename, Writer w_obj, Writer w_mtl) throws IOException {
        HashMap<String, CustomMesh> meshes = new HashMap<String, CustomMesh>();
        for (Content mob : contents) {
            ContentNode node = mob.getContent();
            if (node instanceof CustomMultiMesh) {
                CustomMultiMesh multi = (CustomMultiMesh)node;
                for (int i = 0; i < multi.size(); ++i) {
                    meshes.put(mob.getName() + " [" + (i + 1) + "]", multi.getMesh(i));
                }
                continue;
            }
            if (node instanceof CustomMeshNode) {
                meshes.put(mob.getName(), ((CustomMeshNode)node).getMesh());
                continue;
            }
            if (node instanceof MeshGroup) {
                meshes.put(mob.getName(), ((MeshGroup)node).getMesh());
                continue;
            }
            IJ.log((String)("Ignoring " + mob.getName() + " with node of class " + ((Object)((Object)node)).getClass()));
        }
        WavefrontExporter.save(meshes, mtl_filename, w_obj, w_mtl);
    }

    public static boolean saveToFile(File f, String data) {
        if (null == f) {
            return false;
        }
        try {
            OutputStreamWriter dos = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(f), data.length()), "8859_1");
            dos.write(data, 0, data.length());
            dos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            IJ.showMessage((String)"ERROR: Most likely did NOT save your file.");
            return false;
        }
        return true;
    }

    private static class Mtl {
        float alpha = 1.0f;
        float R = 1.0f;
        float G = 1.0f;
        float B = 1.0f;
        String name;

        Mtl(float alpha, Color3f c) {
            this.alpha = alpha;
            float[] f = new float[3];
            c.get(f);
            this.R = f[0];
            this.G = f[1];
            this.B = f[2];
            this.name = "mat_" + mat_index;
            mat_index++;
        }

        Mtl(float alpha, float R, float G, float B) {
            this.alpha = alpha;
            this.R = R;
            this.G = G;
            this.B = B;
            this.name = "mat_" + mat_index;
            mat_index++;
        }

        public boolean equals(Object ob) {
            if (ob instanceof Mtl) {
                Mtl mat = (Mtl)ob;
                if (mat.alpha == this.alpha && mat.R == this.R && mat.G == this.G && mat.B == this.B) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            long bits = 1L;
            bits = 31L * bits + (long)Float.floatToIntBits(this.alpha);
            bits = 31L * bits + (long)Float.floatToIntBits(this.R);
            bits = 31L * bits + (long)Float.floatToIntBits(this.G);
            bits = 31L * bits + (long)Float.floatToIntBits(this.B);
            return (int)(bits ^ bits >> 32);
        }

        void fill(StringBuffer sb) {
            sb.append("\nnewmtl ").append(this.name).append('\n').append("Ns 96.078431\n").append("Ka 0.0 0.0 0.0\n").append("Kd ").append(this.R).append(' ').append(this.G).append(' ').append(this.B).append('\n').append("Ks 0.5 0.5 0.5\n").append("Ni 1.0\n").append("d ").append(this.alpha).append('\n').append("illum 2\n\n");
        }

        int getAsSingle() {
            return (int)((this.R + this.G + this.B / 3.0f) * 255.0f);
        }
    }
}

