/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.measure.Calibration;
import ij.plugin.frame.Recorder;
import ij.process.FloatPolygon;
import java.awt.Graphics;
import java.awt.Rectangle;

public class EllipseRoi
extends PolygonRoi {
    private static final int vertices = 72;
    private static double defaultRatio = 0.6;
    private double xstart;
    private double ystart;
    private double aspectRatio = defaultRatio;
    private int[] handle = new int[]{0, 18, 36, 54};

    public EllipseRoi(double x1, double y1, double x2, double y2, double aspectRatio) {
        super(new float[72], new float[72], 72, 3);
        if (aspectRatio < 0.0) {
            aspectRatio = 0.0;
        }
        if (aspectRatio > 1.0) {
            aspectRatio = 1.0;
        }
        this.aspectRatio = aspectRatio;
        this.makeEllipse(x1, y1, x2, y2);
        this.state = 3;
        this.bounds = null;
    }

    public EllipseRoi(int sx, int sy, ImagePlus imp) {
        super(sx, sy, imp);
        this.type = 3;
        this.xstart = this.offScreenXD(sx);
        this.ystart = this.offScreenYD(sy);
        this.setDrawOffset(false);
        this.bounds = null;
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        if (!this.overlay) {
            for (int i = 0; i < this.handle.length; ++i) {
                this.drawHandle(g, this.xp2[this.handle[i]], this.yp2[this.handle[i]]);
            }
        }
    }

    @Override
    protected void grow(int sx, int sy) {
        double x1 = this.xstart;
        double y1 = this.ystart;
        double x2 = this.offScreenXD(sx);
        double y2 = this.offScreenYD(sy);
        this.makeEllipse(x1, y1, x2, y2);
        this.showStatus();
        this.imp.draw();
    }

    void makeEllipse(double x1, double y1, double x2, double y2) {
        double centerX = (x1 + x2) / 2.0;
        double centerY = (y1 + y2) / 2.0;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double major = Math.sqrt(dx * dx + dy * dy);
        double minor = major * this.aspectRatio;
        double phiB = Math.atan2(dy, dx);
        double alpha = phiB * 180.0 / Math.PI;
        this.nPoints = 0;
        for (int i = 0; i < 72; ++i) {
            double degrees = (double)i * 360.0 / 72.0;
            double beta1 = degrees / 180.0 * Math.PI;
            dx = Math.cos(beta1) * major / 2.0;
            dy = Math.sin(beta1) * minor / 2.0;
            double beta2 = Math.atan2(dy, dx);
            double rad = Math.sqrt(dx * dx + dy * dy);
            double beta3 = beta2 + alpha / 180.0 * Math.PI;
            double dx2 = Math.cos(beta3) * rad;
            double dy2 = Math.sin(beta3) * rad;
            this.xpf[this.nPoints] = (float)(centerX + dx2);
            this.ypf[this.nPoints] = (float)(centerY + dy2);
            ++this.nPoints;
        }
        this.makePolygonRelative();
        this.cachedMask = null;
    }

    @Override
    public void showStatus() {
        Calibration cal;
        double[] p = this.getParams();
        double dx = p[2] - p[0];
        double dy = p[3] - p[1];
        double major = Math.sqrt(dx * dx + dy * dy);
        double minor = major * p[4];
        double angle = this.getFloatAngle(p[0], p[1], p[2], p[3]);
        if (this.imp != null && !IJ.altKeyDown() && (cal = this.imp.getCalibration()).scaled()) {
            major = Math.sqrt((dx *= cal.pixelWidth) * dx + (dy *= cal.pixelHeight) * dy);
            minor = major * p[4];
        }
        IJ.showStatus("major=" + IJ.d2s(major) + ", minor=" + IJ.d2s(minor) + ", angle=" + IJ.d2s(angle));
    }

    @Override
    public void nudgeCorner(int key) {
        if (this.ic == null) {
            return;
        }
        double x1 = this.xpf[this.handle[2]] + (float)this.x;
        double y1 = this.ypf[this.handle[2]] + (float)this.y;
        double x2 = this.xpf[this.handle[0]] + (float)this.x;
        double y2 = this.ypf[this.handle[0]] + (float)this.y;
        double inc = 1.0 / this.ic.getMagnification();
        switch (key) {
            case 38: {
                y2 -= inc;
                break;
            }
            case 40: {
                y2 += inc;
                break;
            }
            case 37: {
                x2 -= inc;
                break;
            }
            case 39: {
                x2 += inc;
            }
        }
        this.makeEllipse(x1, y1, x2, y2);
        this.imp.draw();
        this.notifyListeners(2);
        this.showStatus();
    }

    void makePolygonRelative() {
        FloatPolygon poly = new FloatPolygon(this.xpf, this.ypf, this.nPoints);
        Rectangle r = poly.getBounds();
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
        for (int i = 0; i < this.nPoints; ++i) {
            this.xpf[i] = this.xpf[i] - (float)this.x;
            this.ypf[i] = this.ypf[i] - (float)this.y;
        }
    }

    @Override
    protected void handleMouseUp(int screenX, int screenY) {
        if (this.state == 0 && IJ.recording()) {
            double x1 = this.xpf[this.handle[2]] + (float)this.x;
            double y1 = this.ypf[this.handle[2]] + (float)this.y;
            double x2 = this.xpf[this.handle[0]] + (float)this.x;
            double y2 = this.ypf[this.handle[0]] + (float)this.y;
            if (Recorder.scriptMode()) {
                Recorder.recordCall("imp.setRoi(new EllipseRoi(" + x1 + "," + y1 + "," + x2 + "," + y2 + "," + IJ.d2s(this.aspectRatio, 2) + "));");
            } else {
                Recorder.record("makeEllipse", (int)x1, (int)y1, (int)x2, (int)y2, this.aspectRatio);
            }
        }
        this.state = 3;
        this.modifyRoi();
    }

    @Override
    protected void moveHandle(int sx, int sy) {
        double ox = this.offScreenXD(sx);
        double oy = this.offScreenYD(sy);
        double x1 = this.xpf[this.handle[2]] + (float)this.x;
        double y1 = this.ypf[this.handle[2]] + (float)this.y;
        double x2 = this.xpf[this.handle[0]] + (float)this.x;
        double y2 = this.ypf[this.handle[0]] + (float)this.y;
        switch (this.activeHandle) {
            case 0: {
                x2 = ox;
                y2 = oy;
                break;
            }
            case 1: {
                double dx = (double)(this.xpf[this.handle[3]] + (float)this.x) - ox;
                double dy = (double)(this.ypf[this.handle[3]] + (float)this.y) - oy;
                this.updateRatio(Math.sqrt(dx * dx + dy * dy), x1, y1, x2, y2);
                break;
            }
            case 2: {
                x1 = ox;
                y1 = oy;
                break;
            }
            case 3: {
                double dx = (double)(this.xpf[this.handle[1]] + (float)this.x) - ox;
                double dy = (double)(this.ypf[this.handle[1]] + (float)this.y) - oy;
                this.updateRatio(Math.sqrt(dx * dx + dy * dy), x1, y1, x2, y2);
            }
        }
        this.makeEllipse(x1, y1, x2, y2);
        this.showStatus();
        this.imp.draw();
    }

    void updateRatio(double minor, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double major = Math.sqrt(dx * dx + dy * dy);
        this.aspectRatio = minor / major;
        if (this.aspectRatio > 1.0) {
            this.aspectRatio = 1.0;
        }
        defaultRatio = this.aspectRatio;
    }

    @Override
    public int isHandle(int sx, int sy) {
        int size = this.getHandleSize() + 5;
        int halfSize = size / 2;
        int index = -1;
        for (int i = 0; i < this.handle.length; ++i) {
            int sx2 = this.xp2[this.handle[i]] - halfSize;
            int sy2 = this.yp2[this.handle[i]] - halfSize;
            if (sx < sx2 || sx > sx2 + size || sy < sy2 || sy > sy2 + size) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public double getLength() {
        double dy;
        double dx;
        double length = 0.0;
        double w2 = 1.0;
        double h2 = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        for (int i = 0; i < this.nPoints - 1; ++i) {
            dx = this.xpf[i + 1] - this.xpf[i];
            dy = this.ypf[i + 1] - this.ypf[i];
            length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
        }
        dx = this.xpf[0] - this.xpf[this.nPoints - 1];
        dy = this.ypf[0] - this.ypf[this.nPoints - 1];
        return length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
    }

    public double[] getParams() {
        double[] params = new double[]{this.xpf[this.handle[2]] + (float)this.x, this.ypf[this.handle[2]] + (float)this.y, this.xpf[this.handle[0]] + (float)this.x, this.ypf[this.handle[0]] + (float)this.y, this.aspectRatio};
        return params;
    }

    @Override
    public double[] getFeretValues() {
        double[] a = super.getFeretValues();
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        if (pw != ph) {
            return a;
        }
        double[] p = this.getParams();
        double dx = p[2] - p[0];
        double dy = p[3] - p[1];
        double major = Math.sqrt(dx * dx + dy * dy);
        double minor = major * p[4];
        a[0] = major * pw;
        a[2] = minor * pw;
        System.arraycopy(p, 0, a, 8, 4);
        double xCenter = 0.5 * (p[2] + p[0]);
        double yCenter = 0.5 * (p[3] + p[1]);
        double semiMinorX = dy * 0.5 * p[4];
        double semiMinorY = dx * -0.5 * p[4];
        a[12] = xCenter + semiMinorX;
        a[14] = xCenter - semiMinorX;
        a[13] = yCenter + semiMinorY;
        a[15] = yCenter - semiMinorY;
        return a;
    }

    @Override
    public boolean subPixelResolution() {
        return true;
    }
}

