/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jcodings.Encoding;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.SideEffectFree;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.util.ByteList;
import org.jruby.util.io.EncodingUtils;

public class SymbolNode
extends Node
implements ILiteralNode,
INameNode,
SideEffectFree {
    private final ByteList bytes;

    public SymbolNode(ISourcePosition position, String name2, Encoding encoding2, int cr) {
        super(position, false);
        this.bytes = new ByteList(name2.getBytes(EncodingUtils.charsetForEncoding(encoding2)), encoding2);
    }

    public SymbolNode(ISourcePosition position, ByteList value2) {
        super(position, false);
        this.bytes = value2;
    }

    public boolean equals(Object other) {
        return other instanceof SymbolNode && this.bytes.equals((Object)((SymbolNode)other).bytes) && this.bytes.getEncoding() == ((SymbolNode)other).getEncoding();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SYMBOLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitSymbolNode(this);
    }

    @Override
    public String getName() {
        return new String(this.bytes.unsafeBytes(), this.bytes.begin(), this.bytes.realSize(), EncodingUtils.charsetForEncoding(this.bytes.getEncoding()));
    }

    public Encoding getEncoding() {
        return this.bytes.getEncoding();
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public ByteList getBytes() {
        return this.bytes;
    }
}

