/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import com.headius.modulator.Modulator;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.jruby.RubyInstanceConfig;
import org.jruby.util.io.SeekableByteChannelImpl;

public abstract class ChannelHelper {
    private static final Field filterInField;
    private static final Field filterOutField;

    private ChannelHelper() {
    }

    public static ReadableByteChannel readableChannel(InputStream inputStream) {
        if (inputStream instanceof ByteArrayInputStream && SeekableByteChannelImpl.USABLE) {
            return new SeekableByteChannelImpl((ByteArrayInputStream)inputStream);
        }
        return Channels.newChannel(inputStream);
    }

    public static WritableByteChannel writableChannel(OutputStream ouputStream) {
        return Channels.newChannel(ouputStream);
    }

    public static OutputStream unwrapBufferedStream(OutputStream filteredStream) {
        if (RubyInstanceConfig.NO_UNWRAP_PROCESS_STREAMS) {
            return filteredStream;
        }
        return ChannelHelper.unwrapFilterOutputStream(filteredStream);
    }

    public static InputStream unwrapBufferedStream(InputStream filteredStream) {
        if (RubyInstanceConfig.NO_UNWRAP_PROCESS_STREAMS) {
            return filteredStream;
        }
        if (filteredStream.getClass().getName().indexOf("ProcessPipeInputStream") != 1) {
            return filteredStream;
        }
        return ChannelHelper.unwrapFilterInputStream((FilterInputStream)filteredStream);
    }

    public static OutputStream unwrapFilterOutputStream(OutputStream filteredStream) {
        if (filterOutField != null) {
            while (filteredStream instanceof FilterOutputStream) {
                try {
                    OutputStream dripStream;
                    OutputStream tmpStream;
                    OutputStream outputStream = tmpStream = Modulator.trySetAccessible((AccessibleObject)filterOutField) ? (OutputStream)filterOutField.get(filteredStream) : null;
                    if (!(tmpStream instanceof FilterOutputStream) && (dripStream = ChannelHelper.unwrapDripStream(tmpStream)) != null) {
                        tmpStream = dripStream;
                    }
                    filteredStream = tmpStream;
                }
                catch (Exception e) {
                    break;
                }
            }
        }
        return filteredStream;
    }

    public static InputStream unwrapFilterInputStream(InputStream filteredStream) {
        if (filterInField != null) {
            while (filteredStream instanceof FilterInputStream) {
                try {
                    InputStream dripStream;
                    InputStream tmpStream;
                    InputStream inputStream = tmpStream = Modulator.trySetAccessible((AccessibleObject)filterInField) ? (InputStream)filterInField.get(filteredStream) : null;
                    if (tmpStream == null) break;
                    if (!(tmpStream instanceof FilterInputStream) && (dripStream = ChannelHelper.unwrapDripStream(tmpStream)) != null) {
                        tmpStream = dripStream;
                    }
                    filteredStream = tmpStream;
                }
                catch (Exception e) {
                    break;
                }
            }
        }
        return filteredStream;
    }

    private static OutputStream unwrapDripStream(OutputStream stream) {
        if (ChannelHelper.isDripSwitchable(stream)) {
            try {
                Field out = stream.getClass().getDeclaredField("out");
                return Modulator.trySetAccessible((AccessibleObject)out) ? (OutputStream)out.get(stream) : null;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return null;
    }

    private static InputStream unwrapDripStream(InputStream stream) {
        if (ChannelHelper.isDripSwitchable(stream)) {
            try {
                Field in = stream.getClass().getDeclaredField("in");
                return Modulator.trySetAccessible((AccessibleObject)in) ? (InputStream)in.get(stream) : null;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isDripSwitchable(Object stream) {
        return stream.getClass().getName().startsWith("org.flatland.drip.Switchable");
    }

    static {
        Field _filterInField = null;
        Field _filterOutField = null;
        try {
            _filterInField = FilterInputStream.class.getDeclaredField("in");
        }
        catch (Exception exception2) {
            // empty catch block
        }
        try {
            _filterOutField = FilterOutputStream.class.getDeclaredField("out");
        }
        catch (Exception exception3) {
            // empty catch block
        }
        filterInField = _filterInField;
        filterOutField = _filterOutField;
    }
}

