/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.brush;

import bdv.util.BdvHandle;
import bdv.viewer.ViewerPanel;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import net.imglib2.Point;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.view.Views;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.util.RunnableAction;
import sc.fiji.labkit.ui.ActionsAndBehaviours;
import sc.fiji.labkit.ui.brush.BdvMouseBehaviourUtils;
import sc.fiji.labkit.ui.brush.FloodFill;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.models.LabelingModel;

public class FloodFillController {
    private final ViewerPanel viewer;
    private final LabelingModel model;
    private final BdvHandle bdv;
    private boolean overlapping = false;
    private boolean planarMode = false;
    private final FloodFillClick floodFillBehaviour = new FloodFillClick(() -> {
        Label selected = this.selectedLabel();
        if (this.overlapping) {
            return l -> l.add(selected);
        }
        Collection<Label> visible = this.visibleLabels();
        return l -> {
            l.removeAll(visible);
            l.add(selected);
        };
    });
    private final FloodFillClick floodEraseBehaviour = new FloodFillClick(() -> {
        if (this.overlapping) {
            Label selected = this.selectedLabel();
            return l -> l.remove(selected);
        }
        Collection<Label> visible = this.visibleLabels();
        return l -> l.removeAll(visible);
    });

    private Collection<Label> visibleLabels() {
        return this.model.labeling().get().getLabels().stream().filter(Label::isVisible).collect(Collectors.toList());
    }

    public FloodFillController(BdvHandle bdv, LabelingModel model, ActionsAndBehaviours behaviors) {
        this.bdv = bdv;
        this.viewer = bdv.getViewerPanel();
        this.model = model;
        RunnableAction nop = new RunnableAction("nop", () -> {});
        nop.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F"));
        behaviors.addAction(nop);
        behaviors.addBehaviour(this.floodFillBehaviour, "floodfill", "F button1");
        behaviors.addBehaviour(this.floodEraseBehaviour, "floodclear", "R button1", "F button2", "F button3");
    }

    private Label selectedLabel() {
        return this.model.selectedLabel().get();
    }

    private RealPoint displayToImageCoordinates(int x, int y) {
        RealPoint labelLocation = new RealPoint(3);
        labelLocation.setPosition(x, 0);
        labelLocation.setPosition(y, 1);
        labelLocation.setPosition(0, 2);
        this.viewer.displayToGlobalCoordinates((RealLocalizable)labelLocation);
        this.model.labelTransformation().applyInverse((RealPositionable)labelLocation, (RealLocalizable)labelLocation);
        return labelLocation;
    }

    public void setOverlapping(boolean override) {
        this.overlapping = override;
    }

    public void setFloodFillActive(boolean active) {
        BdvMouseBehaviourUtils.setMouseBehaviourActive(this.bdv, this.floodFillBehaviour, active);
    }

    public void setRemoveBlobActive(boolean active) {
        BdvMouseBehaviourUtils.setMouseBehaviourActive(this.bdv, this.floodEraseBehaviour, active);
    }

    public void setPlanarMode(boolean planarMode) {
        this.planarMode = planarMode;
    }

    private RandomAccessibleInterval<LabelingType<Label>> labeling() {
        RandomAccessibleInterval label = this.model.labeling().get();
        if (this.model.isTimeSeries()) {
            return Views.hyperSlice((RandomAccessibleInterval)label, (int)(label.numDimensions() - 1), (long)this.viewer.state().getCurrentTimepoint());
        }
        return label;
    }

    private class FloodFillClick
    implements ClickBehaviour {
        private final Supplier<Consumer<Set<Label>>> operationFactory;

        FloodFillClick(Supplier<Consumer<Set<Label>>> operationFactory) {
            this.operationFactory = operationFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void floodFill(RealLocalizable imageCoordinates) {
            ViewerPanel viewerPanel = FloodFillController.this.viewer;
            synchronized (viewerPanel) {
                Consumer<Set<Label>> operation;
                Point seed;
                RandomAccessibleInterval frame = FloodFillController.this.labeling();
                if (frame.numDimensions() == 3 && FloodFillController.this.planarMode) {
                    long z = Math.round(imageCoordinates.getDoublePosition(2));
                    frame = Views.hyperSlice((RandomAccessibleInterval)frame, (int)2, (long)z);
                }
                if (this.askUser((RandomAccessibleInterval<LabelingType<Label>>)frame, seed = this.roundAndReduceDimension(imageCoordinates, frame.numDimensions()), operation = this.operationFactory.get())) {
                    FloodFill.doFloodFillOnActiveLabels((RandomAccessibleInterval<LabelingType<Label>>)frame, seed, operation);
                }
            }
        }

        private boolean askUser(RandomAccessibleInterval<LabelingType<Label>> frame, Point seed, Consumer<Set<Label>> operation) {
            if (seed.numDimensions() == 3 && FloodFill.isBackgroundFloodFill(frame, seed, operation)) {
                String message = "Are you sure to flood fill the background of this 3d image?\n(This may take a while to compute.)";
                int result = JOptionPane.showConfirmDialog((Component)FloodFillController.this.viewer, message, "Flood Fill 3D Image", 2, 3);
                return result == 0;
            }
            return true;
        }

        private Point roundAndReduceDimension(RealLocalizable realLocalizable, int numDimesions) {
            Point point = new Point(numDimesions);
            for (int i = 0; i < point.numDimensions(); ++i) {
                point.setPosition(Math.round(realLocalizable.getDoublePosition(i)), i);
            }
            return point;
        }

        @Override
        public void click(int x, int y) {
            this.floodFill((RealLocalizable)FloodFillController.this.displayToImageCoordinates(x, y));
            FloodFillController.this.model.dataChangedNotifier().notifyListeners(null);
        }
    }
}

