/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.models;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.NumericType;
import sc.fiji.labkit.ui.bdv.BdvShowable;
import sc.fiji.labkit.ui.inputimage.ImgPlusViewsOld;
import sc.fiji.labkit.ui.inputimage.InputImage;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.models.DefaultHolder;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.models.LabelingModel;
import sc.fiji.labkit.ui.models.TransformationModel;
import sc.fiji.labkit.ui.utils.ParametricNotifier;

public class ImageLabelingModel
implements LabelingModel {
    private final AffineTransform3D labelTransformation = new AffineTransform3D();
    private Holder<Labeling> labelingHolder;
    private ParametricNotifier<Interval> dataChangedNotifier = new ParametricNotifier();
    private Holder<Label> selectedLabelHolder;
    private Holder<Boolean> imageVisibility = new DefaultHolder<Boolean>(true);
    private Holder<Boolean> labelingVisibility = new DefaultHolder<Boolean>(true);
    private final boolean isTimeSeries;
    private final TransformationModel transformationModel;
    private final Holder<BdvShowable> showable;
    private String defaultFileName;
    private final Holder<ImgPlus<?>> imageForSegmentation;

    public ImageLabelingModel(InputImage inputImage) {
        ImgPlus<? extends NumericType<?>> image = inputImage.imageForSegmentation();
        ImgPlus<? extends NumericType<?>> firstChannel = ImgPlusViewsOld.hyperSlice(image, Axes.CHANNEL, 0L);
        FinalInterval intervalWithoutChannels = new FinalInterval(firstChannel);
        Labeling labeling = Labeling.createEmpty(Arrays.asList("background", "foreground"), (Interval)intervalWithoutChannels);
        this.showable = new DefaultHolder<BdvShowable>(inputImage.showable());
        this.labelingHolder = new DefaultHolder<Labeling>(labeling);
        this.imageForSegmentation = new DefaultHolder(image);
        this.labelingHolder.notifier().addListener(this::labelingReplacedEvent);
        this.updateLabelTransform();
        Label anyLabel = labeling.getLabels().stream().findAny().orElse(null);
        this.selectedLabelHolder = new DefaultHolder<Label>(anyLabel);
        this.isTimeSeries = ImgPlusViewsOld.hasAxis(image, Axes.TIME);
        this.transformationModel = new TransformationModel(this.isTimeSeries);
        this.defaultFileName = inputImage.getDefaultLabelingFilename();
    }

    private void updateLabelTransform() {
        this.labelTransformation.set(this.multiply(this.showable.get().transformation(), this.getScaling(this.showable.get().interval(), this.labelingHolder.get().interval())));
    }

    private AffineTransform3D multiply(AffineTransform3D transformation, AffineTransform3D scaling) {
        AffineTransform3D result = new AffineTransform3D();
        result.set(transformation);
        result.concatenate(scaling);
        return result;
    }

    private void labelingReplacedEvent() {
        this.updateLabelTransform();
        Label selectedLabel = this.selectedLabelHolder.get();
        List<Label> labels = this.labelingHolder.get().getLabels();
        if (!labels.contains(selectedLabel)) {
            this.selectedLabelHolder.set(labels.isEmpty() ? null : labels.get(0));
        }
    }

    public Holder<BdvShowable> showable() {
        return this.showable;
    }

    @Override
    public AffineTransform3D labelTransformation() {
        return this.labelTransformation;
    }

    @Override
    public String defaultFileName() {
        return this.defaultFileName;
    }

    @Override
    public Holder<Labeling> labeling() {
        return this.labelingHolder;
    }

    @Override
    public Holder<Label> selectedLabel() {
        return this.selectedLabelHolder;
    }

    @Override
    public ParametricNotifier<Interval> dataChangedNotifier() {
        return this.dataChangedNotifier;
    }

    @Override
    public boolean isTimeSeries() {
        return this.isTimeSeries;
    }

    public Holder<Boolean> imageVisibility() {
        return this.imageVisibility;
    }

    @Override
    public Holder<Boolean> labelingVisibility() {
        return this.labelingVisibility;
    }

    @Override
    public TransformationModel transformationModel() {
        return this.transformationModel;
    }

    public Holder<ImgPlus<?>> imageForSegmentation() {
        return this.imageForSegmentation;
    }

    public Dimensions spatialDimensions() {
        Interval interval = this.labelingHolder.get().interval();
        int n = interval.numDimensions() - (this.isTimeSeries() ? 1 : 0);
        return new FinalDimensions(IntStream.range(0, n).mapToLong(arg_0 -> ((Interval)interval).dimension(arg_0)).toArray());
    }

    private AffineTransform3D getScaling(Interval inputImage, Interval initialLabeling) {
        long[] dimensionsA = this.get3dDimensions(inputImage);
        long[] dimensionsB = this.get3dDimensions(initialLabeling);
        double[] values = IntStream.range(0, 3).mapToDouble(i -> (double)dimensionsA[i] / (double)dimensionsB[i]).toArray();
        AffineTransform3D affineTransform3D = new AffineTransform3D();
        affineTransform3D.set(values[0], 0.0, 0.0, 0.0, 0.0, values[1], 0.0, 0.0, 0.0, 0.0, values[2], 0.0);
        return affineTransform3D;
    }

    private long[] get3dDimensions(Interval interval) {
        int i;
        long[] result = new long[3];
        int n = interval.numDimensions();
        for (i = 0; i < n && i < 3; ++i) {
            result[i] = interval.dimension(i);
        }
        for (i = n; i < 3; ++i) {
            result[i] = 1L;
        }
        return result;
    }

    public String toString() {
        return this.imageForSegmentation.get().getName();
    }
}

