/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.segmentation;

import bdv.util.volatiles.SharedQueue;
import bdv.util.volatiles.VolatileViews;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.volatiles.VolatileARGBType;
import net.imglib2.type.volatiles.VolatileUnsignedByteType;
import sc.fiji.labkit.ui.bdv.BdvLayer;
import sc.fiji.labkit.ui.bdv.BdvShowable;
import sc.fiji.labkit.ui.models.DefaultHolder;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.models.ImageLabelingModel;
import sc.fiji.labkit.ui.models.MappedHolder;
import sc.fiji.labkit.ui.models.SegmentationItem;
import sc.fiji.labkit.ui.models.SegmentationModel;
import sc.fiji.labkit.ui.models.SegmentationResultsModel;
import sc.fiji.labkit.ui.utils.ParametricNotifier;

public class PredictionLayer
implements BdvLayer {
    private final Holder<SegmentationResultsModel> model;
    private final AffineTransform3D transformation;
    private final SharedQueue queue = new SharedQueue(Runtime.getRuntime().availableProcessors());
    private final Holder<Boolean> visibility;
    private final Runnable classifierChanged = this::classifierChanged;
    private ParametricNotifier<Interval> listeners = new ParametricNotifier();
    private DefaultHolder<BdvShowable> showable;
    private final Runnable onTrainingCompleted = this::onTrainingCompleted;
    private SegmentationResultsModel segmenter;

    public static PredictionLayer createPredictionLayer(SegmentationModel segmentationModel) {
        ImageLabelingModel imageLabelingModel = segmentationModel.imageLabelingModel();
        return new PredictionLayer(new MappedHolder<SegmentationItem, SegmentationResultsModel>(segmentationModel.segmenterList().selectedSegmenter(), si -> si == null ? null : si.results(imageLabelingModel)), segmentationModel.segmenterList().segmentationVisibility(), imageLabelingModel.labelTransformation());
    }

    private PredictionLayer(Holder<SegmentationResultsModel> model, Holder<Boolean> visibility, AffineTransform3D transformation) {
        this.model = model;
        this.transformation = transformation;
        this.showable = new DefaultHolder<Object>(null);
        this.visibility = visibility;
        model.notifier().addWeakListener(this.classifierChanged);
        this.registerListener(model.get());
        this.classifierChanged();
    }

    private void registerListener(SegmentationResultsModel segmenter) {
        if (segmenter == this.segmenter) {
            return;
        }
        if (this.segmenter != null) {
            this.segmenter.segmentationChangedListeners().removeWeakListener(this.onTrainingCompleted);
        }
        this.segmenter = segmenter;
        if (this.segmenter != null) {
            this.segmenter.segmentationChangedListeners().addWeakListener(this.onTrainingCompleted);
        }
    }

    private void onTrainingCompleted() {
        if (this.model.get() == this.segmenter) {
            this.classifierChanged();
            this.visibility.set(true);
        }
    }

    private void classifierChanged() {
        boolean hasResult;
        SegmentationResultsModel results = this.model.get();
        this.registerListener(results);
        boolean bl = hasResult = results != null && results.hasResults();
        if (hasResult) {
            this.showable.set(BdvShowable.wrap(this.coloredVolatileView(results), this.transformation));
        } else {
            this.showable.set(null);
        }
        this.listeners.notifyListeners(null);
    }

    private RandomAccessibleInterval<VolatileARGBType> coloredVolatileView(SegmentationResultsModel selected) {
        ARGBType[] colors = selected.colors().toArray(new ARGBType[0]);
        return this.mapColors(colors, this.wrapAsVolatile(selected.segmentation()));
    }

    private RandomAccessibleInterval<VolatileUnsignedByteType> wrapAsVolatile(RandomAccessibleInterval<UnsignedByteType> image) {
        try {
            return VolatileViews.wrapAsVolatile(image, (SharedQueue)this.queue);
        }
        catch (IllegalArgumentException e) {
            return Converters.convert(image, (i, o) -> o.set(i.get()), (Type)new VolatileUnsignedByteType());
        }
    }

    private RandomAccessibleInterval<VolatileARGBType> mapColors(ARGBType[] colors, RandomAccessibleInterval<VolatileUnsignedByteType> source) {
        Converter conv = (input, output) -> {
            boolean isValid = input.isValid();
            output.setValid(isValid);
            if (isValid) {
                output.set(colors[((UnsignedByteType)input.get()).get()].get());
            }
        };
        return Converters.convert(source, (Converter)conv, (Type)new VolatileARGBType());
    }

    @Override
    public Holder<BdvShowable> image() {
        return this.showable;
    }

    @Override
    public ParametricNotifier<Interval> listeners() {
        return this.listeners;
    }

    @Override
    public Holder<Boolean> visibility() {
        return this.visibility;
    }

    @Override
    public String title() {
        return "Segmentation";
    }
}

