/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apposed.appose.util.Platforms;

public final class FilePaths {
    private static final Pattern EXTENSION = Pattern.compile(".*?((\\.[a-zA-Z0-9]+)+)$");

    private FilePaths() {
    }

    public static File location(Class<?> c) {
        try {
            ProtectionDomain domain = c.getProtectionDomain();
            if (domain == null) {
                return null;
            }
            CodeSource codeSource = domain.getCodeSource();
            if (codeSource == null) {
                return null;
            }
            URL location = codeSource.getLocation();
            if (location == null) {
                return null;
            }
            return new File(location.toURI());
        }
        catch (URISyntaxException exc) {
            return null;
        }
    }

    public static String fileType(String name) {
        Matcher m = EXTENSION.matcher(name);
        if (!m.matches()) {
            return "";
        }
        return m.group(1);
    }

    public static File findExe(List<String> dirs, List<String> exes) {
        for (String exe : exes) {
            File exeFile = new File(exe);
            if (exeFile.isAbsolute()) {
                if (!Platforms.isExecutable(exeFile)) continue;
                return exeFile;
            }
            for (String dir : dirs) {
                File f = Paths.get(dir, exe).toFile();
                if (!Platforms.isExecutable(f) || f.isDirectory()) continue;
                return f;
            }
        }
        return null;
    }

    public static void moveDirectory(File srcDir, File destDir, boolean overwrite) throws IOException {
        FilePaths.ensureDirectory(srcDir);
        FilePaths.ensureDirectory(destDir);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(srcDir.toPath());){
            for (Path srcPath : stream) {
                FilePaths.moveFile(srcPath.toFile(), destDir, overwrite);
            }
        }
        if (!srcDir.delete()) {
            throw new IOException("Could not remove directory " + destDir);
        }
    }

    public static void moveFile(File srcFile, File destDir, boolean overwrite) throws IOException {
        File destFile = new File(destDir, srcFile.getName());
        if (srcFile.isDirectory()) {
            if (!destFile.exists() && !destFile.mkdirs()) {
                throw new IOException("Failed to create destination directory: " + destDir);
            }
            FilePaths.moveDirectory(srcFile, destFile, overwrite);
            return;
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IllegalArgumentException("Non-directory destination path: " + destDir);
        }
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new IOException("Failed to create destination directory: " + destDir);
        }
        if (destFile.exists() && !overwrite) {
            FilePaths.renameToBackup(srcFile, destDir);
            return;
        }
        FilePaths.renameToBackup(destFile);
        if (!srcFile.renameTo(destFile)) {
            throw new IOException("Failed to move file: " + srcFile + " -> " + destFile);
        }
    }

    public static void renameToBackup(File srcFile) throws IOException {
        FilePaths.renameToBackup(srcFile, srcFile.getParentFile());
    }

    public static void renameToBackup(File srcFile, File destDir) throws IOException {
        if (!srcFile.exists()) {
            return;
        }
        String prefix = srcFile.getName();
        String suffix = "old";
        File backupFile = new File(destDir, prefix + "." + suffix);
        for (int i = 0; i < 1000 && backupFile.exists(); ++i) {
            backupFile = new File(destDir, prefix + "." + i + "." + suffix);
        }
        if (backupFile.exists()) {
            File failedTarget = new File(destDir, prefix + "." + suffix);
            throw new UnsupportedOperationException("Too many backup files already exist for target: " + failedTarget);
        }
        if (!srcFile.renameTo(backupFile)) {
            throw new IOException("Failed to rename file:" + srcFile + " -> " + backupFile);
        }
    }

    public static void deleteRecursively(File dir) throws IOException {
        Path path = dir.toPath();
        if (!Files.exists(path, new LinkOption[0]) && !Files.isSymbolicLink(path)) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                for (Path entry : stream) {
                    FilePaths.deleteRecursively(entry.toFile());
                }
            }
        }
        Files.delete(path);
    }

    public static void ensureDirectory(File envDir) throws IOException {
        if (!envDir.exists()) {
            throw new IOException("Environment directory does not exist: " + envDir);
        }
        if (!envDir.isDirectory()) {
            throw new IOException("Not a directory: " + envDir);
        }
    }
}

