/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search;

import java.net.MalformedURLException;
import java.net.URL;
import org.scijava.log.Logger;
import org.scijava.search.SourceNotFoundException;
import org.scijava.util.Manifest;
import org.scijava.util.POM;

public final class SourceFinder {
    public static URL sourceLocation(Class<?> c, Logger log) throws SourceNotFoundException {
        try {
            String tag;
            POM pom = POM.getPOM(c);
            if (pom == null) {
                log.debug((Object)("No Maven POM found for class: " + c.getName()));
                throw new SourceNotFoundException(c, null);
            }
            String scmURL = pom.getSCMURL();
            if (scmURL == null) {
                if (log.isDebug()) {
                    log.debug((Object)("No <scm><url> for " + SourceFinder.coord(pom)));
                }
                throw new SourceNotFoundException(c, null);
            }
            if (!scmURL.matches("^(git|http|https)://github.com/[^/]+/[^/]+/?$")) {
                log.debug((Object)("Not a standard GitHub project URL: " + scmURL));
                return new URL(scmURL);
            }
            String scmTag = pom.getSCMTag();
            if (scmTag == null || scmTag.equals("HEAD")) {
                Manifest m;
                if (log.isDebug()) {
                    log.debug((Object)(scmTag == null ? "No SCM tag available; using commit hash." : "Weird SCM tag '" + scmTag + "'; using commit hash."));
                }
                String string = tag = (m = Manifest.getManifest(c)) == null ? null : m.getImplementationBuild();
                if (tag == null) {
                    log.debug((Object)"No commit hash found.");
                }
            } else {
                tag = scmTag;
            }
            if (tag == null) {
                return new URL(scmURL);
            }
            StringBuilder url = new StringBuilder();
            url.append(scmURL);
            if (!scmURL.endsWith("/")) {
                url.append("/");
            }
            url.append("blob/");
            url.append(tag);
            String sourceDir = pom.cdata("//build/sourceDirectory");
            url.append(sourceDir == null ? "/src/main/java/" : sourceDir.replace("${project.basedir}", "") + "/");
            url.append(c.getName().replaceAll("\\.", "/"));
            url.append(".java");
            return new URL(url.toString());
        }
        catch (MalformedURLException exc) {
            log.debug((Throwable)exc);
            throw new SourceNotFoundException(c, (Throwable)exc);
        }
    }

    private static String coord(POM pom) {
        String g = pom.getGroupId();
        String a = pom.getArtifactId();
        String v = pom.getVersion();
        return g + ":" + a + ":" + v;
    }
}

