/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.histogram;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealCursor;
import net.imglib2.RealPositionable;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.numeric.integer.LongType;

public class DiscreteFrequencyDistribution
implements Img<LongType> {
    private final Img<LongType> counts;
    private final RandomAccess<LongType> accessor;
    private long totalValues;

    public DiscreteFrequencyDistribution(long[] binCounts) {
        for (int i = 0; i < binCounts.length; ++i) {
            if (binCounts[i] > 0L) continue;
            throw new IllegalArgumentException("invalid bin count (<= 0)");
        }
        this.counts = new ArrayImgFactory<LongType>(new LongType()).create(binCounts);
        this.accessor = this.counts.randomAccess();
        this.totalValues = 0L;
    }

    public DiscreteFrequencyDistribution(Img<LongType> img) {
        this.counts = img;
        this.accessor = this.counts.randomAccess();
        this.resetCounters();
    }

    public void resetCounters() {
        RealCursor cursor = this.counts.cursor();
        while (cursor.hasNext()) {
            ((LongType)cursor.next()).setZero();
        }
        this.totalValues = 0L;
    }

    public long frequency(long[] binPos) {
        for (int i = 0; i < this.accessor.numDimensions(); ++i) {
            if (binPos[i] >= 0L && binPos[i] < this.dimension(i)) continue;
            return 0L;
        }
        this.accessor.setPosition(binPos);
        return ((LongType)this.accessor.get()).get();
    }

    public void setFrequency(long[] binPos, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("frequency count must be >= 0");
        }
        this.accessor.setPosition(binPos);
        long currentValue = ((LongType)this.accessor.get()).get();
        this.totalValues += value - currentValue;
        ((LongType)this.accessor.get()).set(value);
    }

    public double relativeFrequency(long[] binPos) {
        if (this.totalValues == 0L) {
            return 0.0;
        }
        return 1.0 * (double)this.frequency(binPos) / (double)this.totalValues;
    }

    public void increment(long[] binPos) {
        this.accessor.setPosition(binPos);
        ((LongType)this.accessor.get()).inc();
        ++this.totalValues;
    }

    public void decrement(long[] binPos) {
        this.accessor.setPosition(binPos);
        ((LongType)this.accessor.get()).dec();
        --this.totalValues;
    }

    public long totalValues() {
        return this.totalValues;
    }

    public long modeCount() {
        List<long[]> modes = this.modePositions();
        return this.frequency(modes.get(0));
    }

    public List<long[]> modePositions() {
        long commonValue = 0L;
        ArrayList<long[]> modePositions = new ArrayList<long[]>();
        RealCursor cursor = this.localizingCursor();
        while (cursor.hasNext()) {
            long[] pos;
            long val = ((LongType)cursor.next()).get();
            if (val > commonValue) {
                commonValue = val;
                modePositions.clear();
                pos = new long[this.numDimensions()];
                cursor.localize(pos);
                modePositions.add(pos);
                continue;
            }
            if (val != commonValue) continue;
            pos = new long[this.numDimensions()];
            cursor.localize(pos);
            modePositions.add(pos);
        }
        return modePositions;
    }

    @Override
    public RandomAccess<LongType> randomAccess() {
        return this.counts.randomAccess();
    }

    @Override
    public RandomAccess<LongType> randomAccess(Interval interval) {
        return this.counts.randomAccess(interval);
    }

    @Override
    public int numDimensions() {
        return this.counts.numDimensions();
    }

    @Override
    public long min(int d) {
        return this.counts.min(d);
    }

    @Override
    public void min(long[] min) {
        this.counts.min(min);
    }

    @Override
    public void min(Positionable min) {
        this.counts.min(min);
    }

    @Override
    public long max(int d) {
        return this.counts.max(d);
    }

    @Override
    public void max(long[] max) {
        this.counts.max(max);
    }

    @Override
    public void max(Positionable max) {
        this.counts.max(max);
    }

    @Override
    public double realMin(int d) {
        return this.counts.realMin(d);
    }

    @Override
    public void realMin(double[] min) {
        this.counts.realMin(min);
    }

    @Override
    public void realMin(RealPositionable min) {
        this.counts.realMin(min);
    }

    @Override
    public double realMax(int d) {
        return this.counts.realMax(d);
    }

    @Override
    public void realMax(double[] max) {
        this.counts.realMax(max);
    }

    @Override
    public void realMax(RealPositionable max) {
        this.counts.realMax(max);
    }

    @Override
    public void dimensions(long[] dimensions) {
        this.counts.dimensions(dimensions);
    }

    @Override
    public long dimension(int d) {
        return this.counts.dimension(d);
    }

    @Override
    public Cursor<LongType> cursor() {
        return this.counts.cursor();
    }

    @Override
    public Cursor<LongType> localizingCursor() {
        return this.counts.localizingCursor();
    }

    @Override
    public long size() {
        return this.counts.size();
    }

    @Override
    public LongType firstElement() {
        return (LongType)this.counts.firstElement();
    }

    @Override
    public Object iterationOrder() {
        return this.counts.iterationOrder();
    }

    @Override
    public Iterator<LongType> iterator() {
        return this.counts.iterator();
    }

    @Override
    public ImgFactory<LongType> factory() {
        return this.counts.factory();
    }

    public DiscreteFrequencyDistribution copy() {
        return new DiscreteFrequencyDistribution(this.counts.copy());
    }

    @Override
    public LongType getType() {
        return new LongType();
    }
}

