/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.histogram;

import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealCursor;
import net.imglib2.RealPositionable;
import net.imglib2.histogram.BinMapper1d;
import net.imglib2.histogram.DiscreteFrequencyDistribution;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.numeric.integer.LongType;

public class Histogram1d<T>
implements Img<LongType> {
    private T firstValue;
    private BinMapper1d<T> mapper;
    private DiscreteFrequencyDistribution distrib;
    private long[] pos;
    private long ignoredCount;

    public Histogram1d(BinMapper1d<T> mapper) {
        this.mapper = mapper;
        this.distrib = new DiscreteFrequencyDistribution(new long[]{mapper.getBinCount()});
        this.pos = new long[1];
        this.ignoredCount = 0L;
    }

    public Histogram1d(Histogram1d<T> other) {
        this.mapper = other.mapper.copy();
        this.distrib = other.distrib.copy();
        this.pos = (long[])other.pos.clone();
        this.reset();
    }

    public Histogram1d(Iterable<T> data, BinMapper1d<T> mapper) {
        this(mapper);
        super.init(data);
    }

    public T firstDataValue() {
        return this.firstValue;
    }

    public boolean hasTails() {
        return this.mapper.hasTails();
    }

    public long lowerTailCount() {
        if (!this.hasTails()) {
            return 0L;
        }
        this.pos[0] = 0L;
        return this.distrib.frequency(this.pos);
    }

    public long upperTailCount() {
        if (!this.hasTails()) {
            return 0L;
        }
        this.pos[0] = this.mapper.getBinCount() - 1L;
        return this.distrib.frequency(this.pos);
    }

    public long valueCount() {
        return this.distributionCount() - this.lowerTailCount() - this.upperTailCount();
    }

    public long distributionCount() {
        return this.distrib.totalValues();
    }

    public long ignoredCount() {
        return this.ignoredCount;
    }

    public long totalCount() {
        return this.distributionCount() + this.ignoredCount();
    }

    public long frequency(T value) {
        long bin = this.mapper.map(value);
        return this.frequency(bin);
    }

    public long frequency(long binPos) {
        if (binPos < 0L || binPos >= this.mapper.getBinCount()) {
            return 0L;
        }
        this.pos[0] = binPos;
        return this.distrib.frequency(this.pos);
    }

    public double relativeFrequency(T value, boolean includeTails) {
        long bin = this.mapper.map(value);
        return this.relativeFrequency(bin, includeTails);
    }

    public double relativeFrequency(long binPos, boolean includeTails) {
        double numer = this.frequency(binPos);
        long denom = includeTails ? this.distributionCount() : this.valueCount();
        return numer / (double)denom;
    }

    public long getBinCount() {
        return this.mapper.getBinCount();
    }

    public long map(T value) {
        return this.mapper.map(value);
    }

    public void getCenterValue(long binPos, T value) {
        this.mapper.getCenterValue(binPos, value);
    }

    public void getLowerBound(long binPos, T value) {
        this.mapper.getLowerBound(binPos, value);
    }

    public void getUpperBound(long binPos, T value) {
        this.mapper.getUpperBound(binPos, value);
    }

    public boolean includesUpperBound(long binPos) {
        return this.mapper.includesUpperBound(binPos);
    }

    public boolean includesLowerBound(long binPos) {
        return this.mapper.includesLowerBound(binPos);
    }

    public boolean isInLowerTail(T value) {
        if (!this.hasTails()) {
            return false;
        }
        long bin = this.mapper.map(value);
        return bin == 0L;
    }

    public boolean isInUpperTail(T value) {
        if (!this.hasTails()) {
            return false;
        }
        long bin = this.mapper.map(value);
        return bin == this.getBinCount() - 1L;
    }

    public boolean isInMiddle(T value) {
        if (!this.hasTails()) {
            return true;
        }
        long bin = this.mapper.map(value);
        return bin > 0L && bin < this.getBinCount() - 1L;
    }

    public boolean isOutside(T value) {
        long bin = this.mapper.map(value);
        return bin == Long.MIN_VALUE || bin == Long.MAX_VALUE;
    }

    public DiscreteFrequencyDistribution dfd() {
        return this.distrib;
    }

    public void countData(Iterable<T> data) {
        this.init(data);
    }

    public void addData(Iterable<T> data) {
        this.add(data);
    }

    public void subtractData(Iterable<T> data) {
        this.subtract(data);
    }

    public void increment(long binPos) {
        this.pos[0] = binPos;
        this.distrib.increment(this.pos);
    }

    public void decrement(long binPos) {
        this.pos[0] = binPos;
        this.distrib.decrement(this.pos);
    }

    public void increment(T value) {
        long bin = this.mapper.map(value);
        if (bin == Long.MIN_VALUE || bin == Long.MAX_VALUE) {
            ++this.ignoredCount;
        } else {
            this.pos[0] = bin;
            this.distrib.increment(this.pos);
        }
    }

    public void decrement(T value) {
        long bin = this.mapper.map(value);
        if (bin == Long.MIN_VALUE || bin == Long.MAX_VALUE) {
            --this.ignoredCount;
        } else {
            this.pos[0] = bin;
            this.distrib.decrement(this.pos);
        }
    }

    public void resetCounters() {
        this.reset();
    }

    public long[] toLongArray() {
        long[] result = new long[(int)this.getBinCount()];
        RealCursor cursor = this.cursor();
        int i = 0;
        while (cursor.hasNext()) {
            result[i++] = ((LongType)cursor.next()).get();
        }
        return result;
    }

    @Override
    public int numDimensions() {
        return this.distrib.numDimensions();
    }

    @Override
    public long dimension(int d) {
        return this.distrib.dimension(d);
    }

    @Override
    public void dimensions(long[] dims) {
        this.distrib.dimensions(dims);
    }

    @Override
    public RandomAccess<LongType> randomAccess() {
        return this.distrib.randomAccess();
    }

    @Override
    public RandomAccess<LongType> randomAccess(Interval interval) {
        return this.distrib.randomAccess(interval);
    }

    public long min() {
        return this.min(0);
    }

    @Override
    public long min(int d) {
        return this.distrib.min(d);
    }

    @Override
    public void min(long[] min) {
        this.distrib.min(min);
    }

    @Override
    public void min(Positionable min) {
        this.distrib.min(min);
    }

    public long max() {
        return this.max(0);
    }

    @Override
    public long max(int d) {
        return this.distrib.max(d);
    }

    @Override
    public void max(long[] max) {
        this.distrib.max(max);
    }

    @Override
    public void max(Positionable max) {
        this.distrib.max(max);
    }

    public double realMin() {
        return this.realMin(0);
    }

    @Override
    public double realMin(int d) {
        return this.distrib.realMin(d);
    }

    @Override
    public void realMin(double[] min) {
        this.distrib.realMin(min);
    }

    @Override
    public void realMin(RealPositionable min) {
        this.distrib.realMin(min);
    }

    public double realMax() {
        return this.realMax(0);
    }

    @Override
    public double realMax(int d) {
        return this.distrib.realMax(d);
    }

    @Override
    public void realMax(double[] max) {
        this.distrib.realMax(max);
    }

    @Override
    public void realMax(RealPositionable max) {
        this.distrib.realMax(max);
    }

    @Override
    public Cursor<LongType> cursor() {
        return this.distrib.cursor();
    }

    @Override
    public Cursor<LongType> localizingCursor() {
        return this.distrib.localizingCursor();
    }

    @Override
    public long size() {
        return this.distrib.size();
    }

    @Override
    public LongType firstElement() {
        return this.distrib.firstElement();
    }

    @Override
    public Object iterationOrder() {
        return this.distrib.iterationOrder();
    }

    @Override
    public Iterator<LongType> iterator() {
        return this.distrib.iterator();
    }

    @Override
    public ImgFactory<LongType> factory() {
        return this.distrib.factory();
    }

    @Override
    public Histogram1d<T> copy() {
        return new Histogram1d<T>(this);
    }

    @Override
    public LongType getType() {
        return new LongType();
    }

    private void reset() {
        this.distrib.resetCounters();
        this.ignoredCount = 0L;
        this.firstValue = null;
    }

    private void init(Iterable<T> data) {
        this.reset();
        Iterator<T> iter = data.iterator();
        if (iter.hasNext()) {
            this.firstValue = iter.next();
            this.increment(this.firstValue);
        }
        while (iter.hasNext()) {
            this.increment(iter.next());
        }
    }

    private void add(Iterable<T> data) {
        for (T value : data) {
            this.increment(value);
        }
    }

    private void subtract(Iterable<T> data) {
        for (T value : data) {
            this.decrement(value);
        }
    }
}

