/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.djep;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.djep.DVariable;
import org.lsmp.djep.djep.DiffRulesI;
import org.lsmp.djep.djep.PartialDerivative;
import org.lsmp.djep.xjep.DeepCopyVisitor;
import org.lsmp.djep.xjep.NodeFactory;
import org.lsmp.djep.xjep.TreeUtils;
import org.lsmp.djep.xjep.XVariable;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommandI;

public class DifferentiationVisitor
extends DeepCopyVisitor {
    private static final boolean DEBUG = false;
    private DJep localDJep;
    private DJep globalDJep;
    private NodeFactory nf;
    private TreeUtils tu;
    Hashtable diffRules = new Hashtable();

    public DifferentiationVisitor(DJep jep) {
        this.globalDJep = jep;
    }

    void addDiffRule(DiffRulesI rule) {
        this.diffRules.put(rule.getName(), rule);
    }

    DiffRulesI getDiffRule(String name) {
        return (DiffRulesI)this.diffRules.get(name);
    }

    public void printDiffRules() {
        this.printDiffRules(System.out);
    }

    public void printDiffRules(PrintStream out) {
        String key;
        out.println("Standard Functions and their derivatives");
        Enumeration en = this.globalDJep.getFunctionTable().keys();
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            PostfixMathCommandI value = this.globalDJep.getFunctionTable().get(key);
            DiffRulesI rule = (DiffRulesI)this.diffRules.get(key);
            if (rule == null) {
                out.print(key + " No diff rules specified (" + value.getNumberOfParameters() + " arguments).");
            } else {
                out.print(((Object)rule).toString());
            }
            out.println();
        }
        en = this.diffRules.keys();
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            DiffRulesI rule = (DiffRulesI)this.diffRules.get(key);
            if (this.globalDJep.getFunctionTable().containsKey(key)) continue;
            out.print(((Object)rule).toString());
            out.println("\tnot in JEP function list");
        }
    }

    public Node differentiate(Node node, String var, DJep djep) throws ParseException, IllegalArgumentException {
        this.localDJep = djep;
        this.nf = djep.getNodeFactory();
        this.tu = djep.getTreeUtils();
        if (node == null) {
            throw new IllegalArgumentException("node parameter is null");
        }
        if (var == null) {
            throw new IllegalArgumentException("var parameter is null");
        }
        Node res = (Node)node.jjtAccept(this, var);
        return res;
    }

    @Override
    public Object visit(ASTFunNode node, Object data) throws ParseException {
        String name = node.getName();
        Node[] children = TreeUtils.getChildrenAsArray(node);
        Node[] dchildren = this.acceptChildrenAsArray(node, data);
        if (node.getPFMC() instanceof DiffRulesI) {
            return ((DiffRulesI)((Object)node.getPFMC())).differentiate(node, (String)data, children, dchildren, this.localDJep);
        }
        DiffRulesI rules = (DiffRulesI)this.diffRules.get(name);
        if (rules != null) {
            return rules.differentiate(node, (String)data, children, dchildren, this.localDJep);
        }
        throw new ParseException("Sorry I don't know how to differentiate " + node + "\n");
    }

    public boolean isConstantVar(XVariable var) {
        if (!var.hasEquation()) {
            return true;
        }
        Node eqn = var.getEquation();
        return eqn instanceof ASTConstant;
    }

    @Override
    public Object visit(ASTVarNode node, Object data) throws ParseException {
        String varName = (String)data;
        XVariable var = (XVariable)node.getVar();
        PartialDerivative deriv = null;
        if (var instanceof DVariable) {
            DVariable difvar = (DVariable)var;
            if (varName.equals(var.getName())) {
                return this.nf.buildConstantNode(this.tu.getONE());
            }
            if (this.isConstantVar(var)) {
                return this.nf.buildConstantNode(this.tu.getZERO());
            }
            deriv = difvar.findDerivative(varName, this.localDJep);
        } else if (var instanceof PartialDerivative) {
            if (this.isConstantVar(var)) {
                return this.nf.buildConstantNode(this.tu.getZERO());
            }
            PartialDerivative pvar = (PartialDerivative)var;
            DVariable dvar = pvar.getRoot();
            deriv = dvar.findDerivative(pvar, varName, this.localDJep);
        } else {
            throw new ParseException("Encountered non differentiable variable");
        }
        Node eqn = deriv.getEquation();
        if (eqn instanceof ASTVarNode) {
            return this.nf.buildVariableNode(((ASTVarNode)eqn).getVar());
        }
        if (eqn instanceof ASTConstant) {
            return this.nf.buildConstantNode(((ASTConstant)eqn).getValue());
        }
        return this.nf.buildVariableNode(deriv);
    }

    @Override
    public Object visit(ASTConstant node, Object data) throws ParseException {
        return this.nf.buildConstantNode(this.tu.getZERO());
    }
}

