/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.values;

import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Scaler;

public class Tensor
implements MatrixValueI {
    private Object[] values = null;
    private Dimensions dims;
    private int curEle = 0;

    private Tensor() {
    }

    public Tensor(Dimensions dims) {
        this.values = new Object[dims.numEles()];
        this.dims = dims;
    }

    public Tensor(Tensor t) {
        this.values = new Object[t.getDim().numEles()];
        this.dims = t.getDim();
    }

    @Override
    public MatrixValueI copy() {
        Tensor tmp = new Tensor(this);
        tmp.setEles(tmp);
        return tmp;
    }

    public Tensor(int len, Dimensions dims) {
        this.values = new Object[len * dims.numEles()];
        this.dims = Dimensions.valueOf(len, dims);
    }

    @Override
    public Dimensions getDim() {
        return this.dims;
    }

    @Override
    public int getNumEles() {
        return this.values.length;
    }

    @Override
    public void setEle(int i, Object value) {
        this.values[i] = value;
    }

    @Override
    public Object getEle(int i) {
        return this.values[i];
    }

    @Override
    public void setEles(MatrixValueI val) {
        if (!this.dims.equals(val.getDim())) {
            return;
        }
        System.arraycopy(((Tensor)val).values, 0, this.values, 0, this.getNumEles());
    }

    public static MatrixValueI getInstance(Dimensions dims) {
        switch (dims.rank()) {
            case 0: {
                return new Scaler();
            }
            case 1: {
                return new MVector(dims.getFirstDim());
            }
            case 2: {
                return new Matrix(dims.getFirstDim(), dims.getLastDim());
            }
        }
        return new Tensor(dims);
    }

    private static MatrixValueI getInstance(int rows, Dimensions dims) {
        switch (dims.rank()) {
            case 0: {
                return new MVector(rows);
            }
            case 1: {
                return new Matrix(rows, dims.getFirstDim());
            }
        }
        return new Tensor(Dimensions.valueOf(rows, dims));
    }

    protected void bufferAppend(StringBuffer sb, int currank) {
        sb.append("[");
        if (currank + 1 >= this.dims.rank()) {
            for (int i = 0; i < this.dims.getIthDim(currank); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.getEle(this.curEle++));
            }
        } else {
            for (int i = 0; i < this.dims.getIthDim(currank); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                this.bufferAppend(sb, currank + 1);
            }
        }
        sb.append("]");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.curEle = 0;
        this.bufferAppend(sb, 0);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tensor)) {
            return false;
        }
        Tensor tens = (Tensor)obj;
        if (!tens.getDim().equals(this.getDim())) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equals(tens.values[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        for (int i = 0; i < this.values.length; ++i) {
            result = 37 * result + this.values[i].hashCode();
        }
        return result;
    }
}

