/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.kdtree.node;

import mpicbg.imglib.algorithm.kdtree.node.Leaf;
import mpicbg.imglib.algorithm.kdtree.node.Node;

public class NonLeaf<T extends Leaf<T>>
implements Node<T> {
    public final float coordinate;
    public final Node<T> left;
    public final Node<T> right;
    final int dimension;

    public NonLeaf(float coordinate, int dimension, Node<T> left, Node<T> right) {
        this.coordinate = coordinate;
        this.left = left;
        this.right = right;
        this.dimension = dimension;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public String toString(Node<T> node) {
        if (node == null) {
            return "null";
        }
        if (Leaf.class.isInstance(node)) {
            String result = "(" + ((Leaf)node).get(0);
            for (int i = 1; i < this.dimension; ++i) {
                result = result + ", " + ((Leaf)node).get(i);
            }
            return result + ")";
        }
        if (NonLeaf.class.isInstance(node)) {
            NonLeaf nonLeaf = (NonLeaf)node;
            return "[" + this.toString(nonLeaf.left) + " |{" + nonLeaf.coordinate + "} " + this.toString(nonLeaf.right) + "]";
        }
        return node.toString();
    }

    public String toString() {
        return this.toString(this);
    }
}

