/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.label;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.BitAccess;
import mpicbg.imglib.container.basictypecontainer.array.BitArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.BasePairTypeDisplay;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.BasePairType;
import mpicbg.imglib.type.TypeImpl;

public class BasePairBitType
extends TypeImpl<BasePairBitType>
implements BasePairType<BasePairBitType> {
    final DirectAccessContainer<BasePairBitType, ? extends BitAccess> storage;
    BitAccess b;
    int j1;
    int j2;
    int j3;

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    public BasePairBitType(DirectAccessContainer<BasePairBitType, ? extends BitAccess> bitStorage) {
        this.storage = bitStorage;
        this.updateIndex(0);
    }

    public BasePairBitType(Base value) {
        this.storage = null;
        this.updateIndex(0);
        this.b = new BitArray(3);
        this.set(value);
    }

    public BasePairBitType() {
        this(Base.N);
    }

    @Override
    public DirectAccessContainer<BasePairBitType, ? extends BitAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory storageFactory, int[] dim) {
        DirectAccessContainer<BasePairBitType, BitAccess> container = storageFactory.createBitInstance(dim, 3);
        BasePairBitType linkedType = new BasePairBitType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Cursor<?> c) {
        this.b = this.storage.update(c);
    }

    @Override
    public BasePairBitType duplicateTypeOnSameDirectAccessContainer() {
        return new BasePairBitType(this.storage);
    }

    @Override
    public void updateIndex(int i) {
        this.i = i;
        this.j1 = i * 3;
        this.j2 = this.j1 + 1;
        this.j3 = this.j1 + 2;
    }

    @Override
    public void incIndex() {
        ++this.i;
        this.j1 += 3;
        this.j2 += 3;
        this.j3 += 3;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
        int inc3 = 3 * increment;
        this.j1 += inc3;
        this.j2 += inc3;
        this.j3 += inc3;
    }

    @Override
    public void decIndex() {
        --this.i;
        this.j1 -= 3;
        this.j2 -= 3;
        this.j3 -= 3;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
        int dec3 = 3 * decrement;
        this.j1 -= dec3;
        this.j2 -= dec3;
        this.j3 -= dec3;
    }

    @Override
    public Display<BasePairBitType> getDefaultDisplay(Image<BasePairBitType> image) {
        return new BasePairTypeDisplay<BasePairBitType>(image);
    }

    @Override
    public void set(Base base) {
        boolean b1;
        boolean b2;
        boolean b3;
        switch (base) {
            case A: {
                b3 = false;
                b2 = false;
                b1 = false;
                break;
            }
            case T: {
                b2 = false;
                b1 = false;
                b3 = true;
                break;
            }
            case G: {
                b2 = true;
                b1 = true;
                b3 = false;
                break;
            }
            case C: {
                b1 = false;
                b3 = true;
                b2 = true;
                break;
            }
            case gap: {
                b1 = true;
                b3 = false;
                b2 = false;
                break;
            }
            default: {
                b1 = true;
                b2 = false;
                b3 = true;
            }
        }
        this.b.setValue(this.j1, b1);
        this.b.setValue(this.j2, b2);
        this.b.setValue(this.j3, b3);
    }

    @Override
    public Base get() {
        boolean b1 = this.b.getValue(this.j1);
        boolean b2 = this.b.getValue(this.j2);
        boolean b3 = this.b.getValue(this.j3);
        Base base = !b1 ? (!b2 ? (!b3 ? Base.A : Base.T) : (!b3 ? Base.G : Base.C)) : (!b3 ? Base.gap : Base.N);
        return base;
    }

    @Override
    public int compareTo(BasePairBitType c) {
        Base compare;
        Base input = this.get();
        if (input == (compare = c.get())) {
            return 0;
        }
        switch (input) {
            case gap: {
                return -1;
            }
            case N: {
                if (compare == Base.gap) {
                    return 1;
                }
                return -1;
            }
            case A: {
                if (compare == Base.gap || compare == Base.N) {
                    return 1;
                }
                return -1;
            }
            case T: {
                if (compare == Base.G || compare == Base.C) {
                    return -1;
                }
                return 1;
            }
            case G: {
                if (compare == Base.C) {
                    return -1;
                }
                return 1;
            }
        }
        return 1;
    }

    @Override
    public void complement() {
        Base base = this.get();
        switch (base) {
            case A: {
                this.set(Base.T);
                break;
            }
            case T: {
                this.set(Base.A);
                break;
            }
            case G: {
                this.set(Base.C);
                break;
            }
            case C: {
                this.set(Base.G);
            }
        }
    }

    @Override
    public byte baseToValue() {
        Base base = this.get();
        switch (base) {
            case N: {
                return 1;
            }
            case A: {
                return 2;
            }
            case T: {
                return 3;
            }
            case G: {
                return 4;
            }
            case C: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public void set(BasePairBitType c) {
        this.set(c.get());
    }

    public BasePairBitType[] createArray1D(int size1) {
        return new BasePairBitType[size1];
    }

    public BasePairBitType[][] createArray2D(int size1, int size2) {
        return new BasePairBitType[size1][size2];
    }

    public BasePairBitType[][][] createArray3D(int size1, int size2, int size3) {
        return new BasePairBitType[size1][size2][size3];
    }

    @Override
    public BasePairBitType createVariable() {
        return new BasePairBitType();
    }

    @Override
    public BasePairBitType copy() {
        return new BasePairBitType(this.get());
    }

    @Override
    public String toString() {
        return this.get().toString();
    }

    public static enum Base {
        gap,
        N,
        A,
        T,
        G,
        C;

    }
}

