/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collections;
import mpicbg.util.RingBuffer;

public class ErrorStatistic {
    static final IndexOutOfBoundsException tooWide = new IndexOutOfBoundsException("Cannot estimate a wide slope for width larger than than the number of sample.");
    public final RingBuffer<Double> values;
    public final RingBuffer<Double> slope;
    public final RingBuffer<Double> sortedValues;
    public double var0 = 0.0;
    public double var = 0.0;
    public double std0 = 0.0;
    public double std = 0.0;
    public double mean = 0.0;
    private double median = 0.0;
    private double squareDifferences = 0.0;
    private double squares = 0.0;
    public double min = Double.MAX_VALUE;
    public double max = 0.0;

    public ErrorStatistic(int capacity) {
        this.values = new RingBuffer(capacity);
        this.slope = new RingBuffer(capacity);
        this.sortedValues = new RingBuffer(capacity);
    }

    public double getMedian() {
        Collections.sort(this.sortedValues);
        if (this.sortedValues.size() % 2 == 0) {
            int m = this.sortedValues.size() / 2;
            this.median = (this.sortedValues.get(m - 1) + this.sortedValues.get(m)) / 2.0;
        } else {
            this.median = this.sortedValues.get(this.sortedValues.size() / 2);
        }
        return this.median;
    }

    public final void add(double new_value) {
        this.values.add(new_value);
        this.sortedValues.add(new_value);
        if (this.values.lastIndex() == 0) {
            this.slope.add(0.0);
            this.mean = new_value;
            this.var = 0.0;
            this.var0 = 0.0;
        } else {
            this.slope.add(new_value - this.values.get(this.values.lastIndex()));
            double delta = new_value - this.mean;
            this.mean += delta / (double)this.values.nextIndex();
            this.squareDifferences += delta * (new_value - this.mean);
            this.var = this.squareDifferences / (double)this.values.lastIndex();
            this.squares += new_value * new_value;
            this.var0 = this.squares / (double)this.values.lastIndex();
        }
        this.std0 = Math.sqrt(this.var0);
        this.std = Math.sqrt(this.var);
        if (new_value < this.min) {
            this.min = new_value;
        }
        if (new_value > this.max) {
            this.max = new_value;
        }
    }

    public final double getWideSlope(int width) throws IndexOutOfBoundsException {
        return (this.values.get(this.values.lastIndex()) - this.values.get(this.values.lastIndex() - width)) / (double)width;
    }

    public int n() {
        return this.values.nextIndex();
    }

    public void clear() {
        this.values.clear();
        this.slope.clear();
        this.sortedValues.clear();
        this.var0 = 0.0;
        this.var = 0.0;
        this.std0 = 0.0;
        this.std = 0.0;
        this.mean = 0.0;
        this.median = 0.0;
    }
}

