/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.util.HashSet;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.event.TransformEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class MoveAction
extends AbstractSelectedAction {
    private int dx;
    private int dy;

    public MoveAction(DrawingEditor editor, int dx, int dy) {
        super(editor);
        this.dx = dx;
        this.dy = dy;
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AffineTransform tx = new AffineTransform();
        tx.translate(this.dx, this.dy);
        HashSet<Figure> transformedFigures = new HashSet<Figure>();
        for (Figure f : this.getView().getSelectedFigures()) {
            if (!f.isTransformable()) continue;
            transformedFigures.add(f);
            f.willChange();
            f.transform(tx);
            f.changed();
        }
        this.fireUndoableEditHappened(new TransformEdit(transformedFigures, tx));
    }

    public static class South
    extends MoveAction {
        public static final String ID = "edit.moveSouth";

        public South(DrawingEditor editor) {
            super(editor, 0, 1);
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            labels.configureAction(this, ID);
        }
    }

    public static class North
    extends MoveAction {
        public static final String ID = "edit.moveNorth";

        public North(DrawingEditor editor) {
            super(editor, 0, -1);
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            labels.configureAction(this, ID);
        }
    }

    public static class West
    extends MoveAction {
        public static final String ID = "edit.moveWest";

        public West(DrawingEditor editor) {
            super(editor, -1, 0);
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            labels.configureAction(this, ID);
        }
    }

    public static class East
    extends MoveAction {
        public static final String ID = "edit.moveEast";

        public East(DrawingEditor editor) {
            super(editor, 1, 0);
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            labels.configureAction(this, ID);
        }
    }
}

