/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.event;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.ResourceBundleUtil;

public class TransformRestoreEdit
extends AbstractUndoableEdit {
    private Figure owner;
    private Object oldTransformRestoreData;
    private Object newTransformRestoreData;

    public TransformRestoreEdit(Figure owner, Object oldTransformRestoreData, Object newTransformRestoreData) {
        this.owner = owner;
        this.oldTransformRestoreData = oldTransformRestoreData;
        this.newTransformRestoreData = newTransformRestoreData;
    }

    @Override
    public String getPresentationName() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        return labels.getString("edit.transform.text");
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.owner.willChange();
        this.owner.restoreTransformTo(this.oldTransformRestoreData);
        this.owner.changed();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.owner.willChange();
        this.owner.restoreTransformTo(this.newTransformRestoreData);
        this.owner.changed();
    }
}

