/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette.colorchooser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.plaf.PanelUI;
import javax.swing.plaf.UIResource;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.gui.plaf.palette.PalettePanelUI;
import org.jhotdraw.gui.plaf.palette.colorchooser.PaletteCMYKChooser;
import org.jhotdraw.gui.plaf.palette.colorchooser.PaletteHSBChooser;
import org.jhotdraw.gui.plaf.palette.colorchooser.PaletteRGBChooser;

public class PaletteColorSlidersChooser
extends AbstractColorChooserPanel
implements UIResource {
    private static int lastSelectedPanelIndex = 0;
    private JComboBox slidersComboBox;
    private JPanel slidersHolder;

    private void initComponents() {
        this.slidersComboBox = new JComboBox();
        this.slidersHolder = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(4, 6, 6, 6));
        this.setLayout(new BorderLayout());
        this.add((Component)this.slidersComboBox, "North");
        this.slidersHolder.setLayout(new CardLayout());
        this.add((Component)this.slidersHolder, "Center");
    }

    @Override
    protected void buildChooser() {
        this.initComponents();
        PaletteLookAndFeel laf = PaletteLookAndFeel.getInstance();
        this.setUI(PalettePanelUI.createUI(this));
        this.slidersHolder.setUI((PanelUI)PalettePanelUI.createUI(this.slidersHolder));
        this.slidersComboBox.setFont(laf.getFont("ColorChooser.font"));
        this.slidersHolder.add((Component)new PaletteRGBChooser(), "" + laf.getString("ColorChooser.rgbSliders"));
        this.slidersHolder.add((Component)new PaletteCMYKChooser(), "" + laf.getString("ColorChooser.cmykSliders"));
        this.slidersHolder.add((Component)new PaletteHSBChooser(), "" + laf.getString("ColorChooser.hsbSliders"));
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>();
        cbm.addElement(laf.getString("ColorChooser.rgbSliders"));
        cbm.addElement(laf.getString("ColorChooser.cmykSliders"));
        cbm.addElement(laf.getString("ColorChooser.hsbSliders"));
        this.slidersComboBox.setModel(cbm);
        this.slidersComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    ((CardLayout)PaletteColorSlidersChooser.this.slidersHolder.getLayout()).show(PaletteColorSlidersChooser.this.slidersHolder, (String)evt.getItem());
                    lastSelectedPanelIndex = PaletteColorSlidersChooser.this.slidersComboBox.getSelectedIndex();
                }
            }
        });
        this.slidersComboBox.setSelectedIndex(lastSelectedPanelIndex);
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
        Component[] components = this.slidersHolder.getComponents();
        for (int i = 0; i < components.length; ++i) {
            AbstractColorChooserPanel ccp = (AbstractColorChooserPanel)components[i];
            ccp.installChooserPanel(enclosingChooser);
        }
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        Component[] components = this.slidersHolder.getComponents();
        for (int i = 0; i < components.length; ++i) {
            AbstractColorChooserPanel ccp = (AbstractColorChooserPanel)components[i];
            ccp.uninstallChooserPanel(enclosingChooser);
        }
        super.uninstallChooserPanel(enclosingChooser);
    }

    @Override
    public String getDisplayName() {
        PaletteLookAndFeel laf = PaletteLookAndFeel.getInstance();
        return laf.getString("ColorChooser.colorSliders");
    }

    @Override
    public Icon getLargeDisplayIcon() {
        PaletteLookAndFeel laf = PaletteLookAndFeel.getInstance();
        return laf.getIcon("ColorChooser.colorSlidersIcon");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return this.getLargeDisplayIcon();
    }

    @Override
    public void updateChooser() {
    }
}

