/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.SliderUI;
import javax.swing.text.DefaultFormatterFactory;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.event.FigureAttributeEditorHandler;
import org.jhotdraw.draw.event.SelectionComponentDisplayer;
import org.jhotdraw.draw.event.SelectionComponentRepainter;
import org.jhotdraw.draw.gui.JAttributeSlider;
import org.jhotdraw.draw.gui.JAttributeTextField;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.gui.plaf.palette.PaletteColorChooserUI;
import org.jhotdraw.gui.plaf.palette.PaletteFormattedTextFieldUI;
import org.jhotdraw.gui.plaf.palette.PaletteSliderUI;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.samples.svg.gui.SelectionOpacityIcon;
import org.jhotdraw.text.ColorFormatter;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.Images;
import org.jhotdraw.util.ResourceBundleUtil;

public class FillToolBar
extends AbstractToolBar {
    @Nullable
    private SelectionComponentDisplayer displayer;

    public FillToolBar() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(labels.getString(this.getID() + ".toolbar"));
        this.setDisclosureStateCount(3);
    }

    @Override
    public void setEditor(DrawingEditor newValue) {
        if (this.displayer != null) {
            this.displayer.dispose();
            this.displayer = null;
        }
        super.setEditor(newValue);
        if (newValue != null) {
            this.displayer = new SelectionComponentDisplayer(this.editor, this);
        }
    }

    @Override
    protected JComponent createDisclosedComponent(int state) {
        JPanel p = null;
        switch (state) {
            case 1: {
                p = new JPanel();
                p.setOpaque(false);
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout layout = new GridBagLayout();
                p.setLayout(layout);
                HashMap<AttributeKey, Object> defaultAttributes = new HashMap<AttributeKey, Object>();
                SVGAttributeKeys.FILL_GRADIENT.put(defaultAttributes, null);
                JPopupButton btn = ButtonFactory.createSelectionColorChooserButton(this.editor, SVGAttributeKeys.FILL_COLOR, "attribute.fillColor", labels, defaultAttributes, new Rectangle(3, 3, 10, 10), PaletteColorChooserUI.class, this.disposables);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridwidth = 2;
                gbc.anchor = 23;
                p.add((Component)btn, gbc);
                JPopupButton opacityPopupButton = new JPopupButton();
                JAttributeSlider opacitySlider = new JAttributeSlider(1, 0, 100, 100);
                opacityPopupButton.add(opacitySlider);
                labels.configureToolBarButton(opacityPopupButton, "attribute.fillOpacity");
                opacityPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(opacityPopupButton));
                opacityPopupButton.setIcon(new SelectionOpacityIcon(this.editor, SVGAttributeKeys.FILL_OPACITY, (AttributeKey<Color>)SVGAttributeKeys.FILL_COLOR, null, Images.createImage(this.getClass(), labels.getString("attribute.fillOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                opacityPopupButton.setPopupAnchor(4);
                this.disposables.add(new SelectionComponentRepainter(this.editor, opacityPopupButton));
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.anchor = 23;
                gbc.weighty = 1.0;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)opacityPopupButton, gbc);
                opacitySlider.setUI((SliderUI)PaletteSliderUI.createUI(opacitySlider));
                opacitySlider.setScaleFactor(100.0);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.FILL_OPACITY, opacitySlider, this.editor));
                break;
            }
            case 2: {
                p = new JPanel();
                p.setOpaque(false);
                if (this.editor == null) break;
                JPanel p1 = new JPanel(new GridBagLayout());
                JPanel p2 = new JPanel(new GridBagLayout());
                JPanel p3 = new JPanel(new GridBagLayout());
                p1.setOpaque(false);
                p2.setOpaque(false);
                p3.setOpaque(false);
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                p.removeAll();
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout layout = new GridBagLayout();
                p.setLayout(layout);
                HashMap<AttributeKey, Object> defaultAttributes = new HashMap<AttributeKey, Object>();
                SVGAttributeKeys.FILL_GRADIENT.put(defaultAttributes, null);
                JAttributeTextField colorField = new JAttributeTextField();
                colorField.setColumns(7);
                colorField.setToolTipText(labels.getString("attribute.fillColor.toolTipText"));
                colorField.putClientProperty("Palette.Component.segmentPosition", "first");
                colorField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(colorField));
                colorField.setFormatterFactory(ColorFormatter.createFormatterFactory(ColorFormatter.Format.RGB_INTEGER_SHORT, false, false));
                colorField.setHorizontalAlignment(2);
                this.disposables.add(new FigureAttributeEditorHandler(SVGAttributeKeys.FILL_COLOR, defaultAttributes, colorField, this.editor, true));
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.fill = 2;
                gbc.anchor = 23;
                p1.add(colorField, gbc);
                JPopupButton btn = ButtonFactory.createSelectionColorChooserButton(this.editor, SVGAttributeKeys.FILL_COLOR, "attribute.fillColor", labels, defaultAttributes, new Rectangle(3, 3, 10, 10), PaletteColorChooserUI.class, this.disposables);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridwidth = 2;
                gbc.anchor = 23;
                p1.add((Component)btn, gbc);
                JAttributeTextField opacityField = new JAttributeTextField();
                opacityField.setColumns(4);
                opacityField.setToolTipText(labels.getString("attribute.fillOpacity.toolTipText"));
                opacityField.putClientProperty("Palette.Component.segmentPosition", "first");
                opacityField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(opacityField));
                JavaNumberFormatter formatter = new JavaNumberFormatter(0.0, 100.0, 100.0, false, "%");
                formatter.setUsesScientificNotation(false);
                formatter.setMaximumFractionDigits(1);
                opacityField.setFormatterFactory(new DefaultFormatterFactory(formatter));
                opacityField.setHorizontalAlignment(2);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.FILL_OPACITY, opacityField, this.editor));
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.fill = 2;
                gbc.anchor = 23;
                p2.add(opacityField, gbc);
                JPopupButton opacityPopupButton = new JPopupButton();
                JAttributeSlider opacitySlider = new JAttributeSlider(1, 0, 100, 100);
                opacityPopupButton.add(opacitySlider);
                labels.configureToolBarButton(opacityPopupButton, "attribute.fillOpacity");
                opacityPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(opacityPopupButton));
                opacityPopupButton.setPopupAnchor(4);
                opacityPopupButton.setIcon(new SelectionOpacityIcon(this.editor, SVGAttributeKeys.FILL_OPACITY, (AttributeKey<Color>)SVGAttributeKeys.FILL_COLOR, null, Images.createImage(this.getClass(), labels.getString("attribute.fillOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                opacityPopupButton.setPopupAnchor(4);
                this.disposables.add(new SelectionComponentRepainter(this.editor, opacityPopupButton));
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.anchor = 23;
                gbc.weighty = 1.0;
                gbc.insets = new Insets(3, 0, 0, 0);
                p2.add((Component)opacityPopupButton, gbc);
                opacitySlider.setUI((SliderUI)PaletteSliderUI.createUI(opacitySlider));
                opacitySlider.setScaleFactor(100.0);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.FILL_OPACITY, opacitySlider, this.editor));
                gbc = new GridBagConstraints();
                gbc.gridy = 0;
                gbc.anchor = 23;
                p.add((Component)p1, gbc);
                gbc = new GridBagConstraints();
                gbc.gridy = 1;
                gbc.anchor = 23;
                p.add((Component)p2, gbc);
                gbc = new GridBagConstraints();
                gbc.gridy = 2;
                gbc.weighty = 1.0;
                gbc.anchor = 23;
                p.add((Component)p3, gbc);
            }
        }
        return p;
    }

    @Override
    protected String getID() {
        return "fill";
    }

    @Override
    protected int getDefaultDisclosureState() {
        return 1;
    }

    private void initComponents() {
        this.setOpaque(false);
    }
}

