/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.commands;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.log.LogService;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleService;
import org.scijava.util.FileUtils;
import org.scijava.util.Types;

public class CommandFinderPanel
extends JPanel
implements ActionListener,
DocumentListener {
    protected final JTextField searchField;
    protected final JTable commandsList;
    protected final CommandTableModel tableModel;
    private final LogService log;
    private final List<ModuleInfo> commands;

    public CommandFinderPanel(ModuleService moduleService, String baseDir) {
        this.log = (LogService)moduleService.context().getService(LogService.class);
        this.commands = this.buildCommands(moduleService);
        this.setPreferredSize(new Dimension(800, 600));
        this.searchField = new JTextField(12);
        this.commandsList = new JTable(20, 8);
        this.commandsList.setSelectionMode(0);
        this.commandsList.setRowSelectionAllowed(true);
        this.commandsList.setColumnSelectionAllowed(false);
        this.commandsList.setAutoCreateRowSorter(true);
        this.commandsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                int row = CommandFinderPanel.this.commandsList.rowAtPoint(e.getPoint());
                if (row >= 0) {
                    CommandFinderPanel.this.closeDialog(true);
                }
            }
        });
        this.commandsList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    CommandFinderPanel.this.closeDialog(true);
                }
            }
        });
        this.searchField.getDocument().addDocumentListener(this);
        this.tableModel = new CommandTableModel(this.commands, baseDir);
        this.commandsList.setModel(this.tableModel);
        this.tableModel.setColumnWidths(this.commandsList.getColumnModel());
        String layout = "fillx,wrap 2";
        String cols = "[pref|fill,grow]";
        String rows = "[pref|fill,grow|pref]";
        this.setLayout((LayoutManager)new MigLayout("fillx,wrap 2", "[pref|fill,grow]", "[pref|fill,grow|pref]"));
        this.add(new JLabel("Type part of a command:"));
        this.add(this.searchField);
        this.add((Component)new JScrollPane(this.commandsList), "grow,span 2");
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 40: {
                        CommandFinderPanel.this.commandsList.scrollRectToVisible(CommandFinderPanel.this.commandsList.getCellRect(0, 0, true));
                        CommandFinderPanel.this.commandsList.setRowSelectionInterval(0, 0);
                        CommandFinderPanel.this.commandsList.grabFocus();
                        break;
                    }
                    case 38: {
                        int index = CommandFinderPanel.this.commandsList.getModel().getRowCount() - 1;
                        CommandFinderPanel.this.commandsList.scrollRectToVisible(CommandFinderPanel.this.commandsList.getCellRect(index, 0, true));
                        CommandFinderPanel.this.commandsList.setRowSelectionInterval(index, index);
                        CommandFinderPanel.this.commandsList.grabFocus();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                e.consume();
            }
        });
        this.commandsList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 40: {
                        int selected = CommandFinderPanel.this.commandsList.getSelectedRow();
                        if (selected != CommandFinderPanel.this.commandsList.getModel().getRowCount() - 1) {
                            return;
                        }
                        CommandFinderPanel.this.searchField.grabFocus();
                        break;
                    }
                    case 38: {
                        int selected = CommandFinderPanel.this.commandsList.getSelectedRow();
                        if (selected != 0) {
                            return;
                        }
                        CommandFinderPanel.this.searchField.grabFocus();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                e.consume();
            }
        });
    }

    public ModuleInfo getCommand() {
        if (this.tableModel.getRowCount() < 1) {
            return null;
        }
        int selectedRow = this.commandsList.getSelectedRow();
        if (selectedRow < 0) {
            selectedRow = 0;
        }
        return this.tableModel.get(this.commandsList.convertRowIndexToModel(selectedRow));
    }

    public JTextField getSearchField() {
        return this.searchField;
    }

    public String getRegex() {
        return ".*" + this.searchField.getText().toLowerCase() + ".*";
    }

    private void closeDialog(boolean okay) {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof JOptionPane) {
                ((JOptionPane)parent).setValue(okay ? 0 : 2);
                continue;
            }
            if (!(parent instanceof JDialog)) continue;
            ((JDialog)parent).setVisible(false);
            break;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateCommands();
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.filterUpdated();
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.filterUpdated();
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.filterUpdated();
    }

    private List<ModuleInfo> buildCommands(ModuleService moduleService) {
        ArrayList<ModuleInfo> list = new ArrayList<ModuleInfo>();
        list.addAll(moduleService.getModules());
        Collections.sort(list);
        return list;
    }

    private void updateCommands() {
        ModuleInfo selected = this.commandsList.getSelectedRow() < 0 ? null : this.getCommand();
        int counter = 0;
        int selectedRow = -1;
        String regex = this.getRegex();
        ArrayList<ModuleInfo> matches = new ArrayList<ModuleInfo>();
        for (ModuleInfo command : this.commands) {
            if (!command.getMenuPath().toString().toLowerCase().matches(regex)) continue;
            matches.add(command);
            if (command == selected) {
                selectedRow = counter;
            }
            ++counter;
        }
        this.tableModel.setData(matches);
        if (selectedRow >= 0) {
            this.commandsList.setRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    private void filterUpdated() {
        this.updateCommands();
    }

    protected class CommandTableModel
    extends AbstractTableModel {
        public static final int COLUMN_COUNT = 8;
        private final String baseDir;
        private List<ModuleInfo> list;

        public CommandTableModel(List<ModuleInfo> list, String baseDir) {
            this.list = list;
            this.baseDir = baseDir;
        }

        public void setData(List<ModuleInfo> list) {
            this.list = list;
            this.fireTableDataChanged();
        }

        public void setColumnWidths(TableColumnModel columnModel) {
            int[] widths = new int[]{32, 250, 150, 150, 250, 200, 50, 20};
            for (int i = 0; i < widths.length; ++i) {
                columnModel.getColumn(i).setPreferredWidth(widths[i]);
            }
            TableColumn iconColumn = columnModel.getColumn(0);
            iconColumn.setMaxWidth(32);
            iconColumn.setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return (Component)value;
                }
            });
        }

        public ModuleInfo get(int index) {
            return this.list.get(index);
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Icon";
            }
            if (column == 1) {
                return "Command";
            }
            if (column == 2) {
                return "Menu Path";
            }
            if (column == 3) {
                return "Shortcut";
            }
            if (column == 4) {
                return "Class";
            }
            if (column == 5) {
                return "File";
            }
            if (column == 6) {
                return "Description";
            }
            if (column == 7) {
                return "Priority";
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ModuleInfo info = this.list.get(row);
            if (column == 0) {
                String iconPath = info.getIconPath();
                if (iconPath == null) {
                    return null;
                }
                URL iconURL = this.getClass().getResource(iconPath);
                return iconURL == null ? null : new JLabel(new ImageIcon(iconURL));
            }
            if (column == 1) {
                return info.getTitle();
            }
            if (column == 2) {
                MenuPath menuPath = info.getMenuPath();
                return menuPath == null ? "" : menuPath.getMenuString(false);
            }
            if (column == 3) {
                MenuPath menuPath = info.getMenuPath();
                MenuEntry menuLeaf = menuPath == null ? null : menuPath.getLeaf();
                return menuLeaf == null ? "" : menuLeaf.getAccelerator();
            }
            if (column == 4) {
                return info.getDelegateClassName();
            }
            if (column == 5) {
                String path;
                Class c = null;
                try {
                    c = info.loadDelegateClass();
                }
                catch (ClassNotFoundException exc) {
                    CommandFinderPanel.this.log.warn((Throwable)exc);
                }
                URL location = Types.location((Class)c);
                File file = FileUtils.urlToFile((URL)location);
                String string = path = file == null ? null : file.getAbsolutePath();
                if (path != null && path.startsWith(this.baseDir)) {
                    return path.substring(this.baseDir.length() + 1);
                }
                return file;
            }
            if (column == 6) {
                return info.getDescription();
            }
            if (column == 7) {
                return info.getPriority();
            }
            return null;
        }
    }
}

