/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.task;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.scijava.Context;
import org.scijava.event.EventHandler;
import org.scijava.task.Task;
import org.scijava.task.event.TaskEvent;

public class SwingTaskMonitorComponent {
    private final JProgressBar globalProgressBar;
    private final int sizeGlobalProgressBar;
    private final JFrame taskFrame;
    private final JTable taskTable;
    private final TaskTableModel taskTableModel;
    private final Boolean estimateTimeLeft;
    private Boolean confirmBeforeCancel;
    private double globalProgression = 0.0;
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    public SwingTaskMonitorComponent(Context context, boolean estimateTimeLeft, boolean confirmBeforeCancel, int size, final boolean undecorated) {
        context.inject((Object)this);
        this.sizeGlobalProgressBar = size;
        this.confirmBeforeCancel = confirmBeforeCancel;
        this.estimateTimeLeft = estimateTimeLeft;
        this.globalProgressBar = new JProgressBar();
        this.globalProgressBar.setPreferredSize(new Dimension(this.sizeGlobalProgressBar, this.sizeGlobalProgressBar));
        this.globalProgressBar.setUI(new ProgressCircleUI());
        this.globalProgressBar.setPreferredSize(new Dimension(this.sizeGlobalProgressBar, this.sizeGlobalProgressBar));
        this.globalProgressBar.setMaximum(100);
        this.globalProgressBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                SwingTaskMonitorComponent.this.taskFrame.setVisible(!SwingTaskMonitorComponent.this.taskFrame.isVisible());
                if (undecorated) {
                    SwingTaskMonitorComponent.this.taskFrame.setLocation(((SwingTaskMonitorComponent)SwingTaskMonitorComponent.this).globalProgressBar.getLocationOnScreen().x + SwingTaskMonitorComponent.this.globalProgressBar.getWidth(), ((SwingTaskMonitorComponent)SwingTaskMonitorComponent.this).globalProgressBar.getLocationOnScreen().y);
                }
            }
        });
        this.taskFrame = new JFrame("Tasks");
        if (undecorated) {
            this.taskFrame.setUndecorated(true);
            this.taskFrame.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        }
        this.taskTableModel = new TaskTableModel();
        this.taskTable = new JTable(this.taskTableModel);
        this.taskTable.setShowGrid(false);
        this.taskTable.setIntercellSpacing(new Dimension(0, 0));
        this.taskTable.setTableHeader(null);
        this.taskTable.setRowHeight(65);
        this.taskTable.setRowMargin(2);
        this.taskTable.setDefaultRenderer(Task.class, new TaskRenderer(false));
        this.taskTable.getColumnModel().getColumn(1).setMaxWidth(30);
        JScrollPane scrollPane = new JScrollPane(this.taskTable);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        this.taskFrame.add((Component)scrollPane, "Center");
        scrollPane.setPreferredSize(new Dimension(200, 265));
        scrollPane.setColumnHeaderView(null);
        this.taskFrame.pack();
        this.taskTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Task selectedTask;
                int row = SwingTaskMonitorComponent.this.taskTable.rowAtPoint(evt.getPoint());
                int col = SwingTaskMonitorComponent.this.taskTable.columnAtPoint(evt.getPoint());
                if (row >= 0 && col == 1 && (selectedTask = SwingTaskMonitorComponent.this.taskTableModel.getTask(row)) != null) {
                    if (SwingTaskMonitorComponent.this.confirmBeforeCancel.booleanValue()) {
                        int userconfirmation = JOptionPane.showConfirmDialog(null, "Do you really want to cancel this task ?", "Canceling " + selectedTask.getName(), 0);
                        if (userconfirmation == 0) {
                            selectedTask.cancel("User cancellation (table task)");
                        }
                    } else {
                        selectedTask.cancel("User cancellation (table task)");
                    }
                }
            }
        });
    }

    public JComponent getComponent() {
        return this.globalProgressBar;
    }

    @EventHandler
    private void onEvent(TaskEvent evt) {
        Task task = evt.getTask();
        if (task.isDone()) {
            this.taskTableModel.removeTask(task);
        } else {
            this.taskTableModel.addOrUpdate(task);
        }
        this.globalProgressBar.setValue((int)(this.globalProgression * 100.0));
    }

    public void enableCancelConfirmation() {
        this.confirmBeforeCancel = true;
    }

    public void disableCancelConfirmation() {
        this.confirmBeforeCancel = false;
    }

    static String format(long value) {
        if (value == Long.MIN_VALUE) {
            return SwingTaskMonitorComponent.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + SwingTaskMonitorComponent.format(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    static String humanReadableFormat(Duration duration) {
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }

    class TaskRenderer
    implements TableCellRenderer {
        boolean isBordered;
        JPanel cell = new JPanel();
        JLabel labelTop = new JLabel();
        JProgressBar progressBar = new JProgressBar();
        JLabel labelBottom = new JLabel();
        Icon errorIcon = UIManager.getIcon("OptionPane.errorIcon");
        JLabel cancelTask;

        public TaskRenderer(boolean isBordered) {
            this.labelTop.setVerticalTextPosition(1);
            this.labelTop.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
            this.labelBottom.setVerticalTextPosition(1);
            this.labelBottom.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
            this.isBordered = isBordered;
            this.cell.setOpaque(true);
            this.cell.setLayout((LayoutManager)new MigLayout());
            this.cell.add((Component)this.labelTop, "height ::14, span");
            this.cell.add((Component)this.progressBar, "height ::3, span");
            this.cell.add((Component)this.labelBottom, "height ::14");
            this.cancelTask = new JLabel(this.errorIcon, 0);
            this.cancelTask.setOpaque(true);
            this.cancelTask.setBackground(this.cell.getBackground());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object tk, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 1) {
                return this.cancelTask;
            }
            Task task = (Task)tk;
            String status = task.getStatusMessage();
            this.labelTop.setText(task.getName() + " " + (status != null ? status : ""));
            if (SwingTaskMonitorComponent.this.estimateTimeLeft.booleanValue()) {
                this.labelBottom.setText(SwingTaskMonitorComponent.format(task.getProgressValue()) + "/" + SwingTaskMonitorComponent.format(task.getProgressMaximum()) + " - " + SwingTaskMonitorComponent.this.taskTableModel.getEstimateTimeMessage(task));
            } else {
                this.labelBottom.setText(SwingTaskMonitorComponent.format(task.getProgressValue()) + "/" + SwingTaskMonitorComponent.format(task.getProgressMaximum()));
            }
            if (task.getProgressMaximum() == 0L) {
                this.progressBar.setMaximum(100);
                this.progressBar.setValue(50);
            } else {
                int progress = (int)(100L * task.getProgressValue() / task.getProgressMaximum());
                this.progressBar.setMaximum(100);
                this.progressBar.setValue(progress);
            }
            this.cell.setToolTipText(task.getStatusMessage());
            return this.cell;
        }
    }

    static class ProgressCircleUI
    extends BasicProgressBarUI {
        ProgressCircleUI() {
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            Dimension d = super.getPreferredSize(c);
            int v = Math.max(d.width, d.height);
            d.setSize(v, v);
            return d;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Insets b = this.progressBar.getInsets();
            int barRectWidth = this.progressBar.getWidth() - b.right - b.left;
            int barRectHeight = this.progressBar.getHeight() - b.top - b.bottom;
            if (barRectWidth <= 0 || barRectHeight <= 0) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setPaint(this.progressBar.getForeground());
            double degree = 360.0 * this.progressBar.getPercentComplete();
            double sz = Math.min(barRectWidth, barRectHeight);
            double cx = (double)b.left + (double)barRectWidth * 0.5;
            double cy = (double)b.top + (double)barRectHeight * 0.5;
            double or = sz * 0.5;
            double ir = or * 0.5;
            Ellipse2D.Double inner = new Ellipse2D.Double(cx - ir, cy - ir, ir * 2.0, ir * 2.0);
            Arc2D.Double outer = new Arc2D.Double(cx - or, cy - or, sz, sz, 90.0 - degree, degree, 2);
            Area area = new Area(outer);
            area.subtract(new Area(inner));
            g2.fill(area);
            g2.dispose();
            if (this.progressBar.isStringPainted()) {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, 0, b);
            }
        }
    }

    class TaskTableModel
    extends AbstractTableModel {
        private List<Task> monitoredTasks = new ArrayList<Task>();
        private Set<Task> tasksSet = new HashSet<Task>();
        private Map<Task, Double> previousCompletion = new HashMap<Task, Double>();
        private Map<Task, Instant> startTime = new HashMap<Task, Instant>();
        int totalTasks = 0;
        double totalProgression = 0.0;

        TaskTableModel() {
        }

        void addOrUpdate(Task task) {
            int idx;
            if (!this.tasksSet.contains(task)) {
                this.monitoredTasks.add(task);
                this.tasksSet.add(task);
                idx = this.monitoredTasks.size() - 1;
                SwingTaskMonitorComponent.this.taskTableModel.fireTableRowsInserted(idx, idx + 1);
                if (SwingTaskMonitorComponent.this.estimateTimeLeft.booleanValue()) {
                    this.startTime.put(task, Instant.now());
                }
                ++this.totalTasks;
            } else {
                idx = this.monitoredTasks.indexOf(task);
                SwingTaskMonitorComponent.this.taskTableModel.fireTableRowsUpdated(idx, idx + 1);
                double previousProgression = this.previousCompletion.get(task);
                this.totalProgression -= previousProgression;
            }
            if (task.getProgressMaximum() == 0L) {
                this.previousCompletion.put(task, 0.5);
                this.totalProgression += 0.5;
            } else {
                double currentProgression = (double)task.getProgressValue() / (double)task.getProgressMaximum();
                this.previousCompletion.put(task, currentProgression);
                this.totalProgression += currentProgression;
            }
            SwingTaskMonitorComponent.this.globalProgression = this.totalProgression / (double)this.totalTasks;
        }

        void removeTask(Task task) {
            if (this.tasksSet.contains(task)) {
                int indexRemoved = this.monitoredTasks.indexOf(task);
                this.monitoredTasks.remove(indexRemoved);
                this.tasksSet.remove(task);
                SwingTaskMonitorComponent.this.taskTableModel.fireTableRowsDeleted(indexRemoved, indexRemoved + 1);
                double previousProgression = this.previousCompletion.get(task);
                this.totalProgression -= previousProgression;
                --this.totalTasks;
                this.previousCompletion.remove(task);
                if (this.totalTasks == 0) {
                    SwingTaskMonitorComponent.this.globalProgression = 0.0;
                } else {
                    SwingTaskMonitorComponent.this.globalProgression = this.totalProgression / (double)this.totalTasks;
                }
                if (SwingTaskMonitorComponent.this.estimateTimeLeft.booleanValue()) {
                    this.startTime.remove(task);
                }
            }
        }

        String getEstimateTimeMessage(Task task) {
            if (this.tasksSet.contains(task)) {
                if (task.getProgressMaximum() == 0L) {
                    return "? remaining";
                }
                Instant now = Instant.now();
                Duration elapsedTime = Duration.between(this.startTime.get(task), now);
                double completion = this.previousCompletion.get(task);
                if (completion == 0.0) {
                    return "? remaining";
                }
                double elapsedTimeInS = elapsedTime.getSeconds();
                double totalTimeInS = (double)elapsedTime.getSeconds() * 1.0 / completion;
                double remainingTimeInS = totalTimeInS - elapsedTimeInS;
                Duration duration = Duration.ofSeconds((long)remainingTimeInS);
                return SwingTaskMonitorComponent.humanReadableFormat(duration) + " remaining";
            }
            return "";
        }

        @Override
        public synchronized int getRowCount() {
            return this.totalTasks;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Task";
                }
                case 1: {
                    return "Stop";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Task.class;
                }
                case 1: {
                    return Task.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < this.monitoredTasks.size()) {
                Task task = this.monitoredTasks.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return task;
                    }
                    case 1: {
                        return task;
                    }
                }
            }
            return null;
        }

        public Task getTask(int rowIndex) {
            if (rowIndex < this.monitoredTasks.size()) {
                return this.monitoredTasks.get(rowIndex);
            }
            return null;
        }
    }
}

