/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.postprocessing.deconvolution;

import mpicbg.imglib.algorithm.fft.FourierConvolution;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.real.FloatType;

public class LucyRichardsonFFT {
    final Image<FloatType> image;
    final Image<FloatType> kernel;
    final Image<FloatType> weight;
    final FourierConvolution<FloatType, FloatType> fftConvolution;
    Image<FloatType> viewContribution = null;

    public LucyRichardsonFFT(Image<FloatType> image, Image<FloatType> weight, Image<FloatType> kernel, int cpusPerView) {
        this.image = image;
        this.kernel = kernel;
        this.weight = weight;
        this.fftConvolution = new FourierConvolution(image, kernel);
        this.fftConvolution.setNumThreads(Math.max(1, cpusPerView));
    }

    public Image<FloatType> getImage() {
        return this.image;
    }

    public Image<FloatType> getWeight() {
        return this.weight;
    }

    public Image<FloatType> getKernel() {
        return this.kernel;
    }

    public Image<FloatType> getViewContribution() {
        return this.viewContribution;
    }

    public FourierConvolution<FloatType, FloatType> getFFTConvolution() {
        return this.fftConvolution;
    }

    public void setViewContribution(Image<FloatType> viewContribution) {
        if (this.viewContribution != null) {
            this.viewContribution.close();
        }
        this.viewContribution = viewContribution;
    }
}

