/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.export;

import bdv.img.hdf5.Hdf5ImageLoader;
import ij.gui.GenericDialog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewTransformAffine;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.imgloaders.StackImgLoaderIJ;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.export.AppendSpimData2HDF5;
import spim.process.fusion.export.ExportSpimData2TIFF;
import spim.process.fusion.export.ImgExport;
import spim.process.fusion.export.Save3dTIFF;
import spim.process.fusion.export.XMLTIFFImgTitler;

public class AppendSpimData2
implements ImgExport {
    public static String defaultPath = null;
    List<TimePoint> newTimepoints;
    List<ViewSetup> newViewSetups;
    Save3dTIFF saver;
    SpimData2 spimData;
    AppendSpimData2HDF5 appendToHdf5 = null;

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean exportImage(RandomAccessibleInterval<T> img, BoundingBoxGUI bb, TimePoint tp, ViewSetup vs) {
        if (this.appendToHdf5 != null) {
            return this.appendToHdf5.exportImage(img, bb, tp, vs);
        }
        return this.exportImage(img, bb, tp, vs, Double.NaN, Double.NaN);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean exportImage(RandomAccessibleInterval<T> img, BoundingBoxGUI bb, TimePoint tp, ViewSetup vs, double min, double max) {
        if (this.appendToHdf5 != null) {
            return this.appendToHdf5.exportImage(img, bb, tp, vs, min, max);
        }
        if (!this.saver.exportImage(img, bb, tp, vs, min, max)) {
            return false;
        }
        ViewRegistration vr = this.spimData.getViewRegistrations().getViewRegistration(new ViewId(tp.getId(), vs.getId()));
        double scale = bb.getDownSampling();
        AffineTransform3D m = new AffineTransform3D();
        m.set(scale, 0.0, 0.0, (double)bb.min(0), 0.0, scale, 0.0, (double)bb.min(1), 0.0, 0.0, scale, (double)bb.min(2));
        ViewTransformAffine vt = new ViewTransformAffine("fusion bounding box", m);
        vr.getTransformList().clear();
        vr.getTransformList().add(vt);
        return true;
    }

    @Override
    public boolean finish() {
        if (this.appendToHdf5 != null) {
            return this.appendToHdf5.finish();
        }
        return true;
    }

    @Override
    public void setXMLData(List<TimePoint> newTimepoints, List<ViewSetup> newViewSetups) {
        if (this.appendToHdf5 != null) {
            this.appendToHdf5.setXMLData(newTimepoints, newViewSetups);
        }
        this.newTimepoints = newTimepoints;
        this.newViewSetups = newViewSetups;
    }

    @Override
    public boolean queryParameters(SpimData2 spimData, boolean is16bit) {
        if (((SequenceDescription)spimData.getSequenceDescription()).getImgLoader() instanceof Hdf5ImageLoader) {
            this.appendToHdf5 = new AppendSpimData2HDF5();
            this.appendToHdf5.setXMLData(this.newTimepoints, this.newViewSetups);
            return this.appendToHdf5.queryParameters(spimData, is16bit);
        }
        this.spimData = spimData;
        if (!(((SequenceDescription)spimData.getSequenceDescription()).getImgLoader() instanceof StackImgLoaderIJ)) {
            IOFunctions.println("Appending is currently only supported for ImageJ TIFF based SpimData XML projects.");
            return false;
        }
        StackImgLoaderIJ loader = (StackImgLoaderIJ)((SequenceDescription)spimData.getSequenceDescription()).getImgLoader();
        if (this.newTimepoints == null || this.newViewSetups == null) {
            IOFunctions.println("New timepoints and new viewsetup list not set yet ... cannot continue");
            return false;
        }
        AppendSpimData2.appendSpimData2(spimData, this.newTimepoints, this.newViewSetups);
        boolean compress = loader.getFileNamePattern().endsWith(".zip");
        if (compress) {
            IOFunctions.println("Compression is ON");
        } else {
            IOFunctions.println("Compression is OFF");
        }
        this.saver = new Save3dTIFF(this.spimData.getBasePath().toString(), compress);
        this.saver.setImgTitler(new XMLTIFFImgTitler(((SequenceDescription)this.spimData.getSequenceDescription()).getTimePoints().getTimePointsOrdered(), ((SequenceDescription)this.spimData.getSequenceDescription()).getViewSetupsOrdered()));
        ExportSpimData2TIFF.FileNamePattern fnp = ExportSpimData2TIFF.getFileNamePattern(((SequenceDescription)this.spimData.getSequenceDescription()).getTimePoints().getTimePointsOrdered(), ((SequenceDescription)this.spimData.getSequenceDescription()).getViewSetupsOrdered(), compress);
        String newFileNamePattern = loader.getFileNamePattern().equals(fnp.fileNamePattern) ? fnp.fileNamePattern : loader.getFileNamePattern() + ";" + fnp.fileNamePattern;
        StackImgLoaderIJ newLoader = new StackImgLoaderIJ(loader.getPath(), newFileNamePattern, loader.getImgFactory(), Math.max(loader.getLayoutTimePoints(), fnp.layoutTP), Math.max(loader.getLayoutChannels(), fnp.layoutChannels), Math.max(loader.getLayoutIlluminations(), fnp.layoutIllum), Math.max(loader.getLayoutAngles(), fnp.layoutAngles), this.spimData.getSequenceDescription());
        ((SequenceDescription)this.spimData.getSequenceDescription()).setImgLoader((BasicImgLoader)newLoader);
        return true;
    }

    @Override
    public void queryAdditionalParameters(GenericDialog gd, SpimData2 spimData) {
        if (this.appendToHdf5 != null) {
            this.appendToHdf5.queryAdditionalParameters(gd, spimData);
        }
    }

    @Override
    public boolean parseAdditionalParameters(GenericDialog gd, SpimData2 spimData) {
        if (this.appendToHdf5 != null) {
            return this.appendToHdf5.parseAdditionalParameters(gd, spimData);
        }
        return true;
    }

    @Override
    public ImgExport newInstance() {
        return new AppendSpimData2();
    }

    @Override
    public String getDescription() {
        return "Append to current XML Project";
    }

    public static void appendSpimData2(SpimData2 spimData, List<TimePoint> timepointsToProcess, List<ViewSetup> newViewSetups) {
        SequenceDescription sequenceDescription = (SequenceDescription)spimData.getSequenceDescription();
        Map viewSetups = sequenceDescription.getViewSetups();
        for (ViewSetup vs : newViewSetups) {
            viewSetups.put(vs.getId(), vs);
        }
        AppendSpimData2.resetViewSetupsAndDescriptions(sequenceDescription);
        HashSet<ViewId> newMissingViews = new HashSet<ViewId>();
        Map<ViewId, ViewInterestPointLists> ips = spimData.getViewInterestPoints().getViewInterestPoints();
        for (TimePoint t : ((SequenceDescription)spimData.getSequenceDescription()).getTimePoints().getTimePointsOrdered()) {
            if (!timepointsToProcess.contains(t)) {
                for (ViewSetup newSetup : newViewSetups) {
                    newMissingViews.add(new ViewId(t.getId(), newSetup.getId()));
                }
                continue;
            }
            for (ViewSetup newSetup : newViewSetups) {
                ips.put(new ViewId(t.getId(), newSetup.getId()), new ViewInterestPointLists(t.getId(), newSetup.getId()));
            }
        }
        if (newMissingViews.size() > 0) {
            MissingViews m = ((SequenceDescription)spimData.getSequenceDescription()).getMissingViews();
            if (m != null) {
                newMissingViews.addAll(m.getMissingViews());
            }
            m = new MissingViews(newMissingViews);
            AppendSpimData2.setMissingViews((SequenceDescription)spimData.getSequenceDescription(), m);
            BasicViewDescription.markMissingViews((Map)((SequenceDescription)spimData.getSequenceDescription()).getViewDescriptions(), (MissingViews)m);
        }
        Map regMap = spimData.getViewRegistrations().getViewRegistrations();
        for (TimePoint tp : timepointsToProcess) {
            for (ViewSetup vs : newViewSetups) {
                ViewDescription vd = sequenceDescription.getViewDescription(tp.getId(), vs.getId());
                ViewRegistration viewRegistration = new ViewRegistration(vd.getTimePointId(), vd.getViewSetupId());
                viewRegistration.identity();
                regMap.put(vd, viewRegistration);
            }
        }
    }

    private static final void resetViewSetupsAndDescriptions(SequenceDescription s) {
        try {
            Class<Object> clazz = null;
            Field viewSetupsOrderedDirty = null;
            Field viewDescriptionsDirty = null;
            do {
                if ((clazz = clazz == null ? s.getClass() : clazz.getSuperclass()) == null) continue;
                for (Field field : clazz.getDeclaredFields()) {
                    if (field.getName().equals("viewSetupsOrderedDirty")) {
                        viewSetupsOrderedDirty = field;
                    }
                    if (!field.getName().equals("viewDescriptionsDirty")) continue;
                    viewDescriptionsDirty = field;
                }
            } while ((viewSetupsOrderedDirty == null || viewDescriptionsDirty == null) && clazz != null);
            if (viewDescriptionsDirty == null || viewDescriptionsDirty == null) {
                System.out.println("Failed to find SequenceDescription.viewSetupsOrderedDirty or SequenceDescription.viewDescriptionsDirty field. Quiting.");
                return;
            }
            viewSetupsOrderedDirty.setAccessible(true);
            viewSetupsOrderedDirty.set(s, true);
            viewDescriptionsDirty.setAccessible(true);
            viewDescriptionsDirty.set(s, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final void setMissingViews(SequenceDescription s, MissingViews m) {
        try {
            Class<Object> clazz = null;
            boolean found = false;
            do {
                if ((clazz = clazz == null ? s.getClass() : clazz.getSuperclass()) == null) continue;
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.getName().equals("setMissingViews")) continue;
                    found = true;
                }
            } while (!found && clazz != null);
            if (!found) {
                System.out.println("Failed to find SequenceDescription.setMissingViews method. Quiting.");
                return;
            }
            Method setMissingViews = clazz.getDeclaredMethod("setMissingViews", MissingViews.class);
            setMissingViews.setAccessible(true);
            setMissingViews.invoke((Object)s, m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

