/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.registrationstatistics;

import ij.gui.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import mpicbg.spim.data.sequence.TimePoints;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import spim.process.interestpointregistration.registrationstatistics.MouseListenerTimelapse;
import spim.process.interestpointregistration.registrationstatistics.RegistrationStatistics;
import spim.process.interestpointregistration.registrationstatistics.SelectTimepointEntry;

public class GraphFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JFreeChart chart = null;
    ChartPanel chartPanel = null;
    MouseListenerTimelapse mouseListener;
    JPanel mainPanel = new JPanel();

    public GraphFrame(TimePoints timepoints, JFreeChart chart, int referenceTimePoint, boolean enableReferenceTimePoint, List<SelectTimepointEntry> extraMenuItems, ArrayList<RegistrationStatistics> data) {
        this.mainPanel.setLayout(new BorderLayout());
        this.updateWithNewChart(timepoints, chart, true, extraMenuItems, data, referenceTimePoint, enableReferenceTimePoint);
        JPanel buttonsPanel = new JPanel();
        this.mainPanel.add((Component)buttonsPanel, "South");
        this.setContentPane(this.mainPanel);
        this.validate();
        GUI.center((Window)this);
    }

    public int getReferenceTimePoint() {
        return this.mouseListener.getReferenceTimePoint();
    }

    public synchronized void updateWithNewChart(TimePoints timepoints, JFreeChart c, boolean setSize, List<SelectTimepointEntry> extraMenuItems, ArrayList<RegistrationStatistics> data, int referenceTimePoint, boolean enableReferenceTimePoint) {
        if (this.chartPanel != null) {
            this.remove((Component)this.chartPanel);
        }
        this.chartPanel = null;
        this.chart = c;
        this.chartPanel = new ChartPanel(c);
        this.mouseListener = new MouseListenerTimelapse(timepoints, this.chartPanel, referenceTimePoint, enableReferenceTimePoint);
        this.chartPanel.addChartMouseListener((ChartMouseListener)this.mouseListener);
        this.chartPanel.setMouseWheelEnabled(true);
        this.chartPanel.setHorizontalAxisTrace(true);
        this.mainPanel.add((Component)this.chartPanel, "Center");
        JPopupMenu menu = this.chartPanel.getPopupMenu();
        if (extraMenuItems != null) {
            for (SelectTimepointEntry m : extraMenuItems) {
                m.setChartPanel(this.chartPanel);
                menu.add(new JMenuItem(m));
            }
        }
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

