/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.text.TextWindow;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import sc.fiji.coloc.gadgets.Autoscaler;

public class Colocalisation_Threshold
implements PlugIn {
    boolean headingsSetCTC;
    private static int index1 = 0;
    private static int index2 = 1;
    private static int indexMask;
    private static boolean displayCounts;
    private static boolean useMask;
    private static boolean useRoi;
    private ImagePlus imp1;
    private ImagePlus imp2;
    private static boolean threshold;
    private int ch1;
    private int ch2;
    private int ch3;
    private int nslices;
    private int width;
    private int height;
    private int indexRoi = (int)Prefs.get((String)"CTC_indexRoi.int", (double)0.0);
    private DecimalFormat df4 = new DecimalFormat("##0.0000");
    private DecimalFormat df3 = new DecimalFormat("##0.000");
    private DecimalFormat df2 = new DecimalFormat("##0.00");
    private DecimalFormat df1 = new DecimalFormat("##0.0");
    private DecimalFormat df0 = new DecimalFormat("##0");
    private static boolean colocValConst;
    private int dualChannelIndex = (int)Prefs.get((String)"CTC_channels.int", (double)0.0);
    private static boolean bScatter;
    private static boolean bShowLocalisation;
    boolean opt0 = Prefs.get((String)"CTC_opt0.boolean", (boolean)true);
    boolean opt1 = Prefs.get((String)"CTC_opt1.boolean", (boolean)true);
    boolean opt1a = Prefs.get((String)"CTC_opt1a.boolean", (boolean)true);
    boolean opt2 = Prefs.get((String)"CTC_opt2.boolean", (boolean)true);
    boolean opt3a = Prefs.get((String)"CTC_opt3a.boolean", (boolean)true);
    boolean opt3b = Prefs.get((String)"CTC_opt3b.boolean", (boolean)true);
    boolean opt4 = Prefs.get((String)"CTC_opt4.boolean", (boolean)true);
    boolean opt5 = Prefs.get((String)"CTC_opt5.boolean", (boolean)true);
    boolean opt6 = Prefs.get((String)"CTC_opt6.boolean", (boolean)true);
    boolean opt7 = Prefs.get((String)"CTC_opt7.boolean", (boolean)true);
    boolean opt8 = Prefs.get((String)"CTC_opt8.boolean", (boolean)true);
    boolean opt9 = Prefs.get((String)"CTC_opt9.boolean", (boolean)true);
    boolean opt10 = Prefs.get((String)"CTC_opt10.boolean", (boolean)true);
    String[] dualChannels = new String[]{"Red : Green", "Red : Blue", "Green : Blue"};
    private int colIndex1 = 0;
    private int colIndex2 = 1;
    private int colIndex3 = 2;
    ImageProcessor ip1;
    ImageProcessor ip2;
    ImageProcessor ipmask;
    ColorProcessor ipColoc;
    ImagePlus colocPix;
    private int rwidth;
    private int rheight;
    private int xOffset;
    private int yOffset;
    String[] chooseROI = new String[]{"None", "Channel 1", "Channel 2"};
    protected static TextWindow textWindow;

    public void run(String arg) {
        if (this.showDialog()) {
            this.correlate(this.imp1, this.imp2);
        }
    }

    public boolean showDialog() {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.noImage();
            return false;
        }
        String[] titles = new String[wList.length];
        String[] chooseMask = new String[wList.length + 1];
        chooseMask[0] = "<None>";
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)wList[i]);
            if (imp == null) continue;
            if (imp != null) {
                titles[i] = imp.getTitle();
                chooseMask[i + 1] = imp.getTitle();
                continue;
            }
            titles[i] = "";
        }
        if (index1 >= titles.length) {
            index1 = 0;
        }
        if (index2 >= titles.length) {
            index2 = 0;
        }
        if (indexMask >= titles.length) {
            indexMask = 0;
        }
        displayCounts = false;
        threshold = false;
        GenericDialog gd = new GenericDialog("Colocalisation Thresholds");
        gd.addChoice("Channel_1", titles, titles[index1]);
        gd.addChoice("Channel_2", titles, titles[index2]);
        gd.addChoice("Use ROI", this.chooseROI, this.chooseROI[this.indexRoi]);
        gd.addChoice("Channel Combination", this.dualChannels, this.dualChannels[this.dualChannelIndex]);
        gd.addCheckbox("Show Colocalized Pixel Map", bShowLocalisation);
        gd.addCheckbox("Use constant intensity for colocalized pixels", colocValConst);
        gd.addCheckbox("Show Scatter plot", bScatter);
        gd.addCheckbox("Include zero-zero pixels in threshold calculation", this.opt0);
        gd.addCheckbox("Set options", false);
        gd.addMessage("See: http://uhnresearch.ca/wcif/imagej");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        index1 = gd.getNextChoiceIndex();
        index2 = gd.getNextChoiceIndex();
        this.indexRoi = gd.getNextChoiceIndex();
        this.dualChannelIndex = gd.getNextChoiceIndex();
        bShowLocalisation = gd.getNextBoolean();
        colocValConst = gd.getNextBoolean();
        bScatter = gd.getNextBoolean();
        this.opt0 = gd.getNextBoolean();
        boolean options = gd.getNextBoolean();
        this.imp1 = WindowManager.getImage((int)wList[index1]);
        this.imp2 = WindowManager.getImage((int)wList[index2]);
        useMask = false;
        this.imp1 = WindowManager.getImage((int)wList[index1]);
        this.imp2 = WindowManager.getImage((int)wList[index2]);
        if (this.imp1.getType() != 0 && this.imp1.getType() != 1 && this.imp2.getType() != 1 && this.imp2.getType() != 0) {
            IJ.showMessage((String)"Image Correlator", (String)"Both images must be 8-bit or 16-bit grayscale.");
            return false;
        }
        this.ip1 = this.imp1.getProcessor();
        this.ip2 = this.imp2.getProcessor();
        Roi roi1 = this.imp1.getRoi();
        Roi roi2 = this.imp2.getRoi();
        this.width = this.imp1.getWidth();
        this.height = this.imp1.getHeight();
        useRoi = true;
        if (this.indexRoi == 0) {
            useRoi = false;
        }
        Rectangle rect = this.ip1.getRoi();
        if (this.indexRoi == 1) {
            if (roi1 == null) {
                useRoi = false;
            } else {
                if (roi1.getType() == 0) {
                    IJ.showMessage((String)"Does not work with rectangular ROIs");
                    return false;
                }
                this.ipmask = this.imp1.getMask();
                rect = this.ip1.getRoi();
            }
        }
        if (this.indexRoi == 2) {
            if (roi2 == null) {
                useRoi = false;
            } else {
                if (roi2.getType() == 0) {
                    IJ.showMessage((String)"Does not work with rectangular ROIs");
                    return false;
                }
                this.ipmask = this.imp2.getMask();
                rect = this.ip2.getRoi();
            }
        }
        if (this.indexRoi == 0) {
            this.xOffset = 0;
            this.yOffset = 0;
            this.rwidth = this.width;
            this.rheight = this.height;
        } else {
            this.xOffset = rect.x;
            this.yOffset = rect.y;
            this.rwidth = rect.width;
            this.rheight = rect.height;
        }
        if (this.dualChannelIndex == 1) {
            this.colIndex2 = 2;
            this.colIndex3 = 1;
        }
        if (this.dualChannelIndex == 2) {
            this.colIndex1 = 1;
            this.colIndex2 = 2;
            this.colIndex3 = 0;
        }
        if (options) {
            GenericDialog gd2 = new GenericDialog("Set Results Options");
            gd2.addMessage("See online manual for detailed description of these values");
            gd2.addCheckbox("Show linear regression solution", this.opt1a);
            gd2.addCheckbox("Show thresholds", this.opt1);
            gd2.addCheckbox("Pearson's for whole image", this.opt2);
            gd2.addCheckbox("Pearson's for image above thresholds", this.opt3a);
            gd2.addCheckbox("Pearson's for image below thresholds (should be ~0)", this.opt3b);
            gd2.addCheckbox("Mander's original coefficients (threshold = 0)", this.opt4);
            gd2.addCheckbox("Mander's using thresholds", this.opt5);
            gd2.addCheckbox("Number of colocalized voxels", this.opt6);
            gd2.addCheckbox("% Image volume colocalized", this.opt7);
            gd2.addCheckbox("% Voxels colocalized", this.opt8);
            gd2.addCheckbox("% Intensity colocalized", this.opt9);
            gd2.addCheckbox("% Intensity above threshold colocalized", this.opt10);
            gd2.showDialog();
            if (gd2.wasCanceled()) {
                return false;
            }
            this.opt1 = gd2.getNextBoolean();
            this.opt1a = gd2.getNextBoolean();
            this.opt2 = gd2.getNextBoolean();
            this.opt3a = gd2.getNextBoolean();
            this.opt3b = gd2.getNextBoolean();
            this.opt4 = gd2.getNextBoolean();
            this.opt5 = gd2.getNextBoolean();
            this.opt6 = gd2.getNextBoolean();
            this.opt7 = gd2.getNextBoolean();
            this.opt8 = gd2.getNextBoolean();
            this.opt9 = gd2.getNextBoolean();
            this.opt10 = gd2.getNextBoolean();
            this.headingsSetCTC = false;
        }
        return true;
    }

    public void correlate(ImagePlus imp1, ImagePlus imp2) {
        String ch1fileName = imp1.getTitle();
        String ch2fileName = imp2.getTitle();
        String fileName = ch1fileName + " & " + ch2fileName;
        ImageProcessor ip1 = imp1.getProcessor();
        ImageProcessor ip2 = imp2.getProcessor();
        Calibration spatialCalibration = imp1.getCalibration();
        ImageProcessor ipMask = imp1.getMask();
        if (this.indexRoi > 1) {
            ipMask = imp2.getMask();
        }
        ImageStack img1 = imp1.getStack();
        ImageStack img2 = imp2.getStack();
        if (this.indexRoi == 0) {
            useRoi = false;
        }
        Rectangle rect1 = ip1.getRoi();
        Rectangle rect2 = ip2.getRoi();
        Roi roi1 = imp1.getRoi();
        Roi roi2 = imp2.getRoi();
        this.nslices = imp1.getStackSize();
        this.width = imp1.getWidth();
        this.height = imp1.getHeight();
        this.ipColoc = new ColorProcessor(this.rwidth, this.rheight);
        ImageStack stackColoc = new ImageStack(this.rwidth, this.rheight);
        MinMaxContainer minMax1 = this.getMinMax(ip1);
        MinMaxContainer minMax2 = this.getMinMax(ip2);
        double ch1threshmin = 0.0;
        double ch1threshmax = minMax1.max;
        double ch2threshmin = 0.0;
        double ch2threshmax = minMax2.max;
        double pearsons1 = 0.0;
        double pearsons2 = 0.0;
        double pearsons3 = 0.0;
        double r = 1.0;
        pearsons1 = 0.0;
        pearsons2 = 0.0;
        pearsons3 = 0.0;
        double r2 = 1.0;
        boolean thresholdFound = false;
        boolean unsigned = true;
        int count = 0;
        double sumX = 0.0;
        double sumXY = 0.0;
        double sumXX = 0.0;
        double sumYY = 0.0;
        double sumY = 0.0;
        double colocX = 0.0;
        double colocY = 0.0;
        double countX = 0.0;
        double countY = 0.0;
        double sumXYm = 0.0;
        int Nch1 = 0;
        int Nch2 = 0;
        double oldMax = 0.0;
        int sumCh2gtT = 0;
        int sumCh1gtT = 0;
        int N = 0;
        boolean N2 = false;
        int Nzero = 0;
        int Nch1gtT = 0;
        int Nch2gtT = 0;
        double oldMax2 = 0.0;
        int ch1Max = (int)minMax1.max;
        int ch2Max = (int)minMax2.max;
        int ch1Min = (int)minMax1.min;
        int ch2Min = (int)minMax2.min;
        int ch1ROIMax = 0;
        int ch2ROIMax = 0;
        String Headings = "\t \t \t \t \t \t \t \n";
        FloatProcessor plot32 = new FloatProcessor(256, 256);
        ShortProcessor plot16 = new ShortProcessor(256, 256);
        int scaledXvalue = 0;
        int scaledYvalue = 0;
        if (ch1Max < 255) {
            ch1Max = 255;
        }
        if (ch2Max < 255) {
            ch2Max = 255;
        }
        double ch1Scaling = 255.0 / (double)ch1Max;
        double ch2Scaling = 255.0 / (double)ch2Max;
        double chScaling = 1.0;
        chScaling = ch1Scaling > ch2Scaling ? ch1Scaling : ch2Scaling;
        boolean divByZero = false;
        StringBuffer sb = new StringBuffer();
        String str = "";
        int i = imp1.getCurrentSlice();
        double bBest = 0.0;
        double mBest = 0.0;
        double bestr2 = 1.0;
        double ch1BestThresh = 0.0;
        double ch2BestThresh = 0.0;
        IJ.showStatus((String)"1/4: Performing regression. Press 'Esc' to abort");
        int ch1Sum = 0;
        int ch2Sum = 0;
        int ch3Sum = 0;
        double ch1mch1MeanSqSum = 0.0;
        double ch2mch2MeanSqSum = 0.0;
        double ch3mch3MeanSqSum = 0.0;
        ShortProcessor ipPlot = new ShortProcessor(256, 256);
        int mask = 0;
        if (this.indexRoi == 0) {
            useRoi = false;
        }
        Rectangle rect = ip1.getRoi();
        if (this.indexRoi == 1) {
            if (roi1 == null) {
                useRoi = false;
            } else {
                if (roi1.getType() == 0) {
                    IJ.showMessage((String)"Does not work with rectangular ROIs");
                    return;
                }
                ipMask = imp1.getMask();
                rect = ip1.getRoi();
            }
        }
        if (this.indexRoi == 2) {
            if (roi2 == null) {
                useRoi = false;
            } else {
                if (roi2.getType() == 0) {
                    IJ.showMessage((String)"Does not work with rectangular ROIs");
                    return;
                }
                ipMask = imp2.getMask();
                rect = ip2.getRoi();
            }
        }
        if (!useRoi) {
            this.xOffset = 0;
            this.yOffset = 0;
            this.rwidth = this.width;
            this.rheight = this.height;
        } else {
            this.xOffset = rect.x;
            this.yOffset = rect.y;
            this.rwidth = rect.width;
            this.rheight = rect.height;
        }
        for (int s = 1; s <= this.nslices; ++s) {
            if (IJ.escapePressed()) {
                IJ.beep();
                return;
            }
            ip1 = img1.getProcessor(s);
            ip2 = img2.getProcessor(s);
            for (int y = 0; y < this.rheight; ++y) {
                for (int x = 0; x < this.rwidth; ++x) {
                    mask = 1;
                    if (useRoi) {
                        mask = (int)ipMask.getPixelValue(x, y);
                    }
                    if (mask == 0) continue;
                    this.ch1 = ip1.getPixel(x + this.xOffset, y + this.yOffset);
                    this.ch2 = ip2.getPixel(x + this.xOffset, y + this.yOffset);
                    if (this.ch1 > ch1ROIMax) {
                        ch1ROIMax = this.ch1;
                    }
                    if (this.ch2 > ch2ROIMax) {
                        ch2ROIMax = this.ch2;
                    }
                    this.ch3 = this.ch1 + this.ch2;
                    ch1Sum += this.ch1;
                    ch2Sum += this.ch2;
                    ch3Sum += this.ch3;
                    if (this.ch1 + this.ch2 == 0) continue;
                    ++N;
                }
            }
        }
        double ch1Mean = ch1Sum / N;
        double ch2Mean = ch2Sum / N;
        double ch3Mean = ch3Sum / N;
        N = 0;
        long startTime = System.currentTimeMillis();
        for (int s = 1; s <= this.nslices; ++s) {
            if (IJ.escapePressed()) {
                IJ.beep();
                return;
            }
            ip1 = img1.getProcessor(s);
            ip2 = img2.getProcessor(s);
            for (int y = 0; y < this.rheight; ++y) {
                for (int x = 0; x < this.rwidth; ++x) {
                    mask = 1;
                    if (useRoi) {
                        mask = (int)ipMask.getPixelValue(x, y);
                    }
                    if (mask == 0) continue;
                    this.ch1 = ip1.getPixel(x + this.xOffset, y + this.yOffset);
                    this.ch2 = ip2.getPixel(x + this.xOffset, y + this.yOffset);
                    this.ch3 = this.ch1 + this.ch2;
                    ch1mch1MeanSqSum += ((double)this.ch1 - ch1Mean) * ((double)this.ch1 - ch1Mean);
                    ch2mch2MeanSqSum += ((double)this.ch2 - ch2Mean) * ((double)this.ch2 - ch2Mean);
                    ch3mch3MeanSqSum += ((double)this.ch3 - ch3Mean) * ((double)this.ch3 - ch3Mean);
                    if (this.ch1 + this.ch2 == 0) {
                        ++Nzero;
                    }
                    sumX += (double)this.ch1;
                    sumXY += (double)(this.ch1 * this.ch2);
                    sumXX += (double)(this.ch1 * this.ch1);
                    sumYY += (double)(this.ch2 * this.ch2);
                    sumY += (double)this.ch2;
                    ++N;
                }
            }
        }
        pearsons1 = sumXY - sumX * sumY / (double)(N -= Nzero);
        pearsons2 = sumXX - sumX * sumX / (double)N;
        pearsons3 = sumYY - sumY * sumY / (double)N;
        double rTotal = pearsons1 / Math.sqrt(pearsons2 * pearsons3);
        long finishTime = System.currentTimeMillis();
        long elapsed = finishTime - startTime;
        System.out.println("Pearson calculation took " + elapsed + " ms.");
        double ch1Var = ch1mch1MeanSqSum / (double)(N - 1);
        double ch2Var = ch2mch2MeanSqSum / (double)(N - 1);
        double ch3Var = ch3mch3MeanSqSum / (double)(N - 1);
        double ch1ch2covar = 0.5 * (ch3Var - (ch1Var + ch2Var));
        double denom = 2.0 * ch1ch2covar;
        double num = ch2Var - ch1Var + Math.sqrt((ch2Var - ch1Var) * (ch2Var - ch1Var) + 4.0 * ch1ch2covar * ch1ch2covar);
        double m = num / denom;
        double b = ch2Mean - m * ch1Mean;
        boolean prevDivByZero = false;
        double newMax = ch1Max;
        double r2Prev = 0.0;
        double r2Prev2 = 1.0;
        r2 = 0.0;
        boolean prevByZero = false;
        double tolerance = 0.01;
        for (int iteration = 1; !thresholdFound && iteration < 30; ++iteration) {
            if (iteration == 2 && r2 < 0.0) {
                IJ.showMessage((String)"No positive correlations found. Ending");
                IJ.showStatus((String)"Done");
                return;
            }
            ch1threshmax = Math.round(newMax);
            ch2threshmax = Math.round(ch1threshmax * m + b);
            if (IJ.escapePressed()) {
                IJ.beep();
                return;
            }
            IJ.showStatus((String)("2/4: Calculating Threshold. i = " + iteration + " Press 'Esc' to abort"));
            sumX = 0.0;
            sumXY = 0.0;
            sumXX = 0.0;
            sumYY = 0.0;
            sumY = 0.0;
            N2 = false;
            N = 0;
            Nzero = 0;
            for (int s = 1; s <= this.nslices; ++s) {
                ip1 = img1.getProcessor(s);
                ip2 = img2.getProcessor(s);
                for (int y = 0; y < this.rheight; ++y) {
                    for (int x = 0; x < this.rwidth; ++x) {
                        mask = 1;
                        if (useRoi) {
                            mask = (int)ipMask.getPixelValue(x, y);
                        }
                        if (mask == 0) continue;
                        this.ch1 = ip1.getPixel(x + this.xOffset, y + this.yOffset);
                        this.ch2 = ip2.getPixel(x + this.xOffset, y + this.yOffset);
                        if (!((double)this.ch1 < ch1threshmax) && !((double)this.ch2 < ch2threshmax)) continue;
                        if (this.ch1 + this.ch2 == 0) {
                            ++Nzero;
                        }
                        sumX += (double)this.ch1;
                        sumXY += (double)(this.ch1 * this.ch2);
                        sumXX += (double)(this.ch1 * this.ch1);
                        sumYY += (double)(this.ch2 * this.ch2);
                        sumY += (double)this.ch2;
                        ++N;
                    }
                }
            }
            if (!this.opt0) {
                N -= Nzero;
            }
            pearsons1 = sumXY - sumX * sumY / (double)N;
            pearsons2 = sumXX - sumX * sumX / (double)N;
            pearsons3 = sumYY - sumY * sumY / (double)N;
            r2Prev2 = r2Prev;
            r2Prev = r2;
            r2 = pearsons1 / Math.sqrt(pearsons2 * pearsons3);
            divByZero = Math.sqrt(pearsons2 * pearsons3) == 0.0 || N == 0;
            if (bestr2 * bestr2 > r2 * r2) {
                ch1BestThresh = ch1threshmax;
                bestr2 = r2;
            }
            if (r2 < tolerance && r2 > -tolerance) {
                thresholdFound = true;
            }
            if (Math.round(ch1threshmax) == 0L) {
                thresholdFound = true;
            }
            oldMax = newMax;
            if (r2 >= 0.0) {
                if (r2 >= r2Prev && !divByZero) {
                    newMax /= 2.0;
                }
                if (r2 < r2Prev || divByZero) {
                    newMax += newMax / 2.0;
                }
            }
            if (!(r2 < 0.0) && !divByZero) continue;
            newMax += newMax / 2.0;
        }
        ch1threshmax = Math.round(ch1BestThresh);
        ch2threshmax = Math.round(ch1BestThresh * m + b);
        Nzero = 0;
        imp1.setSlice(i);
        imp2.setSlice(i);
        int sumColocCh1 = 0;
        int sumColocCh2 = 0;
        int Ncoloc = 0;
        sumXYm = 0.0;
        sumCh1gtT = 0;
        sumCh2gtT = 0;
        double mCh2coloc = 0.0;
        double mCh1coloc = 0.0;
        double sumCh1total = 0.0;
        double sumCh2total = 0.0;
        sumXYm = 0.0;
        sumX = 0.0;
        sumXY = 0.0;
        sumXX = 0.0;
        sumYY = 0.0;
        sumY = 0.0;
        N2 = false;
        N = 0;
        Ncoloc = 0;
        for (int s = 1; s <= this.nslices; ++s) {
            IJ.showStatus((String)("3/4: Calculating statistics. Slice = " + s + " Press 'Esc' to abort"));
            ip1 = img1.getProcessor(s);
            ip2 = img2.getProcessor(s);
            for (int y = 0; y < this.rheight; ++y) {
                for (int x = 0; x < this.rwidth; ++x) {
                    mask = 1;
                    if (useRoi) {
                        mask = (int)ipMask.getPixelValue(x, y);
                    }
                    if (mask == 0) continue;
                    this.ch1 = ip1.getPixel(x + this.xOffset, y + this.yOffset);
                    this.ch2 = ip2.getPixel(x + this.xOffset, y + this.yOffset);
                    sumCh1total += (double)this.ch1;
                    sumCh2total += (double)this.ch2;
                    ++N;
                    scaledXvalue = (int)((double)this.ch1 * chScaling);
                    scaledYvalue = 255 - (int)((double)this.ch2 * chScaling);
                    count = plot32.getPixel(scaledXvalue, scaledYvalue);
                    plot32.putPixel(scaledXvalue, scaledYvalue, ++count);
                    if (count < 65535) {
                        plot16.putPixel(scaledXvalue, scaledYvalue, count);
                    }
                    if (this.ch1 + this.ch2 == 0) {
                        ++Nzero;
                    }
                    if (this.ch1 > 0) {
                        ++Nch1;
                        mCh2coloc += (double)this.ch2;
                    }
                    if (this.ch2 > 0) {
                        ++Nch2;
                        mCh1coloc += (double)this.ch1;
                    }
                    if ((double)this.ch2 >= ch2threshmax) {
                        ++Nch2gtT;
                        sumCh2gtT += this.ch2;
                        colocX += (double)this.ch1;
                    }
                    if ((double)this.ch1 >= ch1threshmax) {
                        ++Nch1gtT;
                        sumCh1gtT += this.ch1;
                        colocY += (double)this.ch2;
                    }
                    if (!((double)this.ch1 > ch1threshmax) || !((double)this.ch2 > ch2threshmax)) continue;
                    sumColocCh1 += this.ch1;
                    sumColocCh2 += this.ch2;
                    ++Ncoloc;
                    sumX += (double)this.ch1;
                    sumXY += (double)(this.ch1 * this.ch2);
                    sumXX += (double)(this.ch1 * this.ch1);
                    sumYY += (double)(this.ch2 * this.ch2);
                    sumY += (double)this.ch2;
                }
            }
        }
        pearsons1 = sumXY - sumX * sumY / (double)Ncoloc;
        pearsons2 = sumXX - sumX * sumX / (double)Ncoloc;
        pearsons3 = sumYY - sumY * sumY / (double)Ncoloc;
        double Rcoloc = pearsons1 / Math.sqrt(pearsons2 * pearsons3);
        double M1 = mCh1coloc / sumCh1total;
        double M2 = mCh2coloc / sumCh2total;
        double colocM1 = colocX / sumCh1total;
        double colocM2 = colocY / sumCh2total;
        double colocC1 = (double)sumCh1gtT / sumCh1total;
        double colocC2 = (double)sumCh2gtT / sumCh2total;
        double percVolCh1 = (double)Ncoloc / (double)Nch1gtT;
        double percVolCh2 = (double)Ncoloc / (double)Nch2gtT;
        double percTotCh1 = (double)sumColocCh1 / sumCh1total;
        double percTotCh2 = (double)sumColocCh2 / sumCh2total;
        double percMatCh1 = (double)sumColocCh1 / (double)sumCh1gtT;
        double percMatCh2 = (double)sumColocCh2 / (double)sumCh2gtT;
        sb.append(fileName + "\n");
        str = fileName + "\tROI" + this.indexRoi + "\t";
        str = str + (this.opt0 ? "incl.\t" : "excl.\t");
        if (this.opt2) {
            str = str + this.df3.format(rTotal) + "\t";
        }
        if (this.opt1a) {
            str = str + this.df3.format(m) + "\t " + this.df1.format(b) + "\t";
        }
        if (this.opt1) {
            str = str + IJ.d2s((double)ch1threshmax, (int)0) + "\t" + IJ.d2s((double)ch2threshmax, (int)0) + "\t";
        }
        if (this.opt3a) {
            str = str + this.df4.format(Rcoloc) + "\t";
        }
        if (this.opt3b) {
            str = str + this.df3.format(bestr2) + "\t";
        }
        if (this.opt4) {
            str = str + this.df4.format(M1) + "\t " + this.df4.format(M2) + "\t";
        }
        if (this.opt5) {
            str = str + this.df4.format(colocM1) + "\t" + this.df4.format(colocM2) + "\t";
        }
        if (this.opt6) {
            str = str + Ncoloc + "\t";
        }
        if (this.opt7) {
            str = str + this.df2.format((double)Ncoloc * 100.0 / ((double)this.width * (double)this.height * (double)this.nslices)) + "%\t";
        }
        if (this.opt8) {
            str = str + this.df2.format(percVolCh1 * 100.0) + "%\t";
        }
        if (this.opt8) {
            str = str + this.df2.format(percVolCh2 * 100.0) + "%\t";
        }
        if (this.opt9) {
            str = str + this.df2.format(percTotCh1 * 100.0) + "%\t";
        }
        if (this.opt9) {
            str = str + this.df2.format(percTotCh2 * 100.0) + "%\t";
        }
        if (this.opt10) {
            str = str + this.df2.format(percMatCh1 * 100.0) + "%\t";
        }
        if (this.opt10) {
            str = str + this.df2.format(percMatCh2 * 100.0) + "%\t";
        }
        String heading = "Images\tMask\tZeroZero\t";
        if (this.opt2) {
            heading = heading + "Rtotal\t";
        }
        if (this.opt1a) {
            heading = heading + "m\tb\t";
        }
        if (this.opt1) {
            heading = heading + "Ch1 thresh\tCh2 thresh\t";
        }
        if (this.opt3a) {
            heading = heading + "Rcoloc\t";
        }
        if (this.opt3b) {
            heading = heading + "R<threshold\t";
        }
        if (this.opt4) {
            heading = heading + "M1\tM2\t";
        }
        if (this.opt5) {
            heading = heading + "tM1\ttM2\t";
        }
        if (this.opt6) {
            heading = heading + "Ncoloc\t";
        }
        if (this.opt7) {
            heading = heading + "%Volume\t";
        }
        if (this.opt8) {
            heading = heading + "%Ch1 Vol\t";
        }
        if (this.opt8) {
            heading = heading + "%Ch2 Vol\t";
        }
        if (this.opt9) {
            heading = heading + "%Ch1 Int\t";
        }
        if (this.opt9) {
            heading = heading + "%Ch2 Int\t";
        }
        if (this.opt10) {
            heading = heading + "%Ch1 Int > thresh\t";
        }
        if (this.opt10) {
            heading = heading + "%Ch2 Int >thresh\t";
        }
        heading = heading + "\n";
        double plotY = 0.0;
        double plotY2 = 0.0;
        if (textWindow == null || !textWindow.isVisible()) {
            textWindow = new TextWindow("Results", heading, "", 400, 250);
        }
        textWindow.getTextPanel().appendLine(str);
        Prefs.set((String)"CTC_annels.int", (int)this.dualChannelIndex);
        Prefs.set((String)"CTC_channels.int", (int)this.dualChannelIndex);
        Prefs.set((String)"CTC_show.boolean", (boolean)bShowLocalisation);
        Prefs.set((String)"CTC_colocConst.boolean", (boolean)colocValConst);
        Prefs.set((String)"CTC_bScatter.boolean", (boolean)bScatter);
        Prefs.set((String)"CTC_opt0.boolean", (boolean)this.opt0);
        Prefs.set((String)"CTC_opt1.boolean", (boolean)this.opt1);
        Prefs.set((String)"CTC_opt1a.boolean", (boolean)this.opt1a);
        Prefs.set((String)"CTC_opt2.boolean", (boolean)this.opt2);
        Prefs.set((String)"CTC_opt3a.boolean", (boolean)this.opt3a);
        Prefs.set((String)"CTC_opt3b.boolean", (boolean)this.opt3b);
        Prefs.set((String)"CTC_opt4.boolean", (boolean)this.opt4);
        Prefs.set((String)"CTC_opt5.boolean", (boolean)this.opt5);
        Prefs.set((String)"CTC_opt6.boolean", (boolean)this.opt6);
        Prefs.set((String)"CTC_opt7.boolean", (boolean)this.opt7);
        Prefs.set((String)"CTC_opt8.boolean", (boolean)this.opt8);
        Prefs.set((String)"CTC_opt9.boolean", (boolean)this.opt9);
        Prefs.set((String)"CTC_opt10.boolean", (boolean)this.opt10);
        Prefs.set((String)"CTC_indexRoi.int", (int)this.indexRoi);
        if (bShowLocalisation) {
            stackColoc = this.createColocalizedPixelsImage(imp1, imp2, ipMask, ch1threshmax, ch2threshmax);
            this.colocPix = new ImagePlus("Colocalized Pixel Map RGB Image", stackColoc);
            this.colocPix.setCalibration(spatialCalibration);
            this.colocPix.show();
        }
        if (bScatter) {
            if (imp2.getBitDepth() != 8) {
                b = b * 256.0 / minMax2.max;
            }
            Autoscaler.autoscale((ImageProcessor)plot16);
            for (int c = 0; c < 256; ++c) {
                plotY = (double)c * m + b;
                int plotmax2 = (int)plot16.getMax();
                int plotmax = plotmax2 / 2;
                plot16.putPixel(c, 255 - (int)plotY, plotmax);
                plot16.putPixel(c, 255 - (int)(ch2threshmax * chScaling), plotmax);
                plot16.putPixel((int)(ch1threshmax * chScaling), c, plotmax);
            }
            ImagePlus imp3 = new ImagePlus("Correlation Plot", (ImageProcessor)plot16);
            imp3.show();
            IJ.run((ImagePlus)imp3, (String)"Enhance Contrast", (String)"saturated=50 equalize");
            IJ.run((ImagePlus)imp3, (String)"Fire", null);
            imp3.setTitle(fileName + " Freq. CP");
        }
        IJ.selectWindow((String)"Results");
        IJ.showStatus((String)"Done");
    }

    private MinMaxContainer getMinMax(ImageProcessor ip) {
        ImageStatistics stats = ImageStatistics.getStatistics((ImageProcessor)ip, (int)16, null);
        return new MinMaxContainer(stats.min, stats.max);
    }

    private ImageStack createColocalizedPixelsImage(ImagePlus imp1, ImagePlus imp2, ImageProcessor ipMask, double ch1threshmax, double ch2threshmax) {
        double colocPixelsImageThresh1 = ch1threshmax;
        double colocPixelsImageThresh2 = ch2threshmax;
        ImageStack img1 = imp1.getStack();
        ImageStack img2 = imp2.getStack();
        ImageStack stackColocPix = new ImageStack(this.rwidth, this.rheight);
        boolean needsScaling1 = imp1.getBitDepth() != 8;
        boolean needsScaling2 = imp2.getBitDepth() != 8;
        int mask = 0;
        int colocInt = 255;
        int[] color = new int[3];
        for (int s = 1; s <= this.nslices; ++s) {
            ImageConverter ic;
            ImagePlus imp;
            IJ.showStatus((String)("4/4: Creating colocalized pixels image. Slice = " + s + " Press 'Esc' to abort"));
            this.ip1 = img1.getProcessor(s);
            ImageProcessor ip1Stretch = this.ip1.duplicate();
            this.ip2 = img2.getProcessor(s);
            ImageProcessor ip2Stretch = this.ip2.duplicate();
            if (needsScaling1) {
                imp = new ImagePlus("", ip1Stretch);
                IJ.run((ImagePlus)imp, (String)"Enhance Contrast", (String)"saturated=0.0");
                ic = new ImageConverter(imp);
                ImageConverter.setDoScaling((boolean)true);
                ic.convertToGray8();
                imp.changes = true;
                ip1Stretch = imp.getStack().getProcessor(1);
                colocPixelsImageThresh1 = ch1threshmax * 256.0 / this.getMinMax((ImageProcessor)this.ip1).max;
            }
            if (needsScaling2) {
                imp = new ImagePlus("", ip2Stretch);
                IJ.run((ImagePlus)imp, (String)"Enhance Contrast", (String)"saturated=0.0");
                ic = new ImageConverter(imp);
                ImageConverter.setDoScaling((boolean)true);
                ic.convertToGray8();
                imp.changes = true;
                ip2Stretch = imp.getStack().getProcessor(1);
                colocPixelsImageThresh2 = ch2threshmax * 256.0 / this.getMinMax((ImageProcessor)this.ip2).max;
            }
            this.ipColoc = new ColorProcessor(this.rwidth, this.rheight);
            for (int y = 0; y < this.rheight; ++y) {
                for (int x = 0; x < this.rwidth; ++x) {
                    mask = 1;
                    if (useRoi) {
                        mask = (int)ipMask.getPixelValue(x, y);
                    }
                    if (mask == 0) continue;
                    this.ch1 = ip1Stretch.getPixel(x + this.xOffset, y + this.yOffset);
                    this.ch2 = ip2Stretch.getPixel(x + this.xOffset, y + this.yOffset);
                    color[this.colIndex1] = this.ch1;
                    color[this.colIndex2] = this.ch2;
                    color[this.colIndex3] = 0;
                    this.ipColoc.putPixel(x, y, color);
                    if (!((double)this.ch1 > colocPixelsImageThresh1) || !((double)this.ch2 > colocPixelsImageThresh2)) continue;
                    colocInt = 255;
                    if (!colocValConst) {
                        colocInt = (int)Math.sqrt(this.ch1 * this.ch2);
                    }
                    color[this.colIndex1] = colocInt;
                    color[this.colIndex2] = colocInt;
                    color[this.colIndex3] = colocInt;
                    this.ipColoc.putPixel(x, y, color);
                }
            }
            stackColocPix.addSlice("Colocalized Pixel Map Image", (ImageProcessor)this.ipColoc);
        }
        return stackColocPix;
    }

    static {
        colocValConst = Prefs.get((String)"CTC_colocConst.boolean", (boolean)false);
        bScatter = Prefs.get((String)"CTC_bScatter.boolean", (boolean)false);
        bShowLocalisation = Prefs.get((String)"CTC_show.boolean", (boolean)false);
    }

    private class MinMaxContainer {
        public double min;
        public double max;

        public MinMaxContainer(double min, double max) {
            this.min = min;
            this.max = max;
        }
    }
}

