/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.ref;

import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.LoaderCache;
import net.imglib2.cache.ref.WeakRefLoaderCache;

public class BoundedSoftRefLoaderCache<K, V>
implements LoaderCache<K, V> {
    private final LoaderCache<K, V> cache;
    private final SoftRefs softRefs;

    public BoundedSoftRefLoaderCache(int maxSoftRefs, LoaderCache<K, V> cache) {
        this.cache = cache;
        this.softRefs = new SoftRefs(maxSoftRefs);
    }

    public BoundedSoftRefLoaderCache(int maxSoftRefs) {
        this.cache = new WeakRefLoaderCache();
        this.softRefs = new SoftRefs(maxSoftRefs);
    }

    @Override
    public V getIfPresent(K key) {
        Object value = this.cache.getIfPresent(key);
        if (value != null) {
            this.softRefs.touch(key, value);
        }
        return value;
    }

    @Override
    public V get(K key, CacheLoader<? super K, ? extends V> loader) throws ExecutionException {
        V value = this.cache.get((K)key, loader);
        this.softRefs.touch(key, value);
        return value;
    }

    @Override
    public void persist(K key) {
    }

    @Override
    public void persistIf(Predicate<K> condition) {
    }

    @Override
    public void persistAll() {
    }

    @Override
    public void invalidate(K key) {
        this.cache.invalidate(key);
        this.softRefs.remove(key);
    }

    @Override
    public void invalidateIf(long parallelismThreshold, Predicate<K> condition) {
        this.cache.invalidateIf(parallelismThreshold, condition);
        this.softRefs.keySet().removeIf(condition);
    }

    @Override
    public void invalidateAll(long parallelismThreshold) {
        this.softRefs.clear();
        this.cache.invalidateAll(parallelismThreshold);
    }

    class SoftRefs
    extends LinkedHashMap<K, SoftReference<V>> {
        private static final long serialVersionUID = 1L;
        private final int maxSoftRefs;

        public SoftRefs(int maxSoftRefs) {
            super(maxSoftRefs, 0.75f, true);
            this.maxSoftRefs = maxSoftRefs;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, SoftReference<V>> eldest) {
            if (this.size() > this.maxSoftRefs) {
                eldest.getValue().clear();
                return true;
            }
            return false;
        }

        synchronized void touch(K key, V value) {
            SoftReference ref = (SoftReference)this.get(key);
            if (ref == null || ref.get() == null) {
                this.put(key, new SoftReference(value));
            }
        }

        @Override
        public synchronized void clear() {
            for (SoftReference ref : this.values()) {
                ref.clear();
            }
            super.clear();
        }
    }
}

