/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.lazy;

import java.util.Set;
import java.util.function.Consumer;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.CellLoader;
import net.imglib2.cache.img.LoadedCellCacheLoader;
import net.imglib2.cache.ref.SoftRefLoaderCache;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.type.numeric.integer.GenericLongType;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

public class Lazy {
    private Lazy() {
    }

    private static <T extends NativeType<T>> CachedCellImg<T, ?> createImg(CellGrid grid, Cache<Long, Cell<?>> cache, T type, Set<AccessFlags> accessFlags) {
        Object img = GenericByteType.class.isInstance(type) ? new CachedCellImg(grid, type, cache, ArrayDataAccessFactory.get(PrimitiveType.BYTE, accessFlags)) : (GenericShortType.class.isInstance(type) ? new CachedCellImg(grid, type, cache, ArrayDataAccessFactory.get(PrimitiveType.SHORT, accessFlags)) : (GenericIntType.class.isInstance(type) ? new CachedCellImg(grid, type, cache, ArrayDataAccessFactory.get(PrimitiveType.INT, accessFlags)) : (GenericLongType.class.isInstance(type) ? new CachedCellImg(grid, type, cache, ArrayDataAccessFactory.get(PrimitiveType.LONG, accessFlags)) : (FloatType.class.isInstance(type) ? new CachedCellImg(grid, type, cache, ArrayDataAccessFactory.get(PrimitiveType.FLOAT, accessFlags)) : (DoubleType.class.isInstance(type) ? new CachedCellImg(grid, type, cache, ArrayDataAccessFactory.get(PrimitiveType.DOUBLE, accessFlags)) : null)))));
        return img;
    }

    private static <T extends NativeType<T>> CachedCellImg<T, ?> createImg(Interval targetInterval, int[] blockSize, T type, Set<AccessFlags> accessFlags, Consumer<RandomAccessibleInterval<T>> loader) {
        CellLoader offsetLoader;
        long[] dimensions = Intervals.dimensionsAsLongArray(targetInterval);
        CellGrid grid = new CellGrid(dimensions, blockSize);
        if (Views.isZeroMin(targetInterval)) {
            offsetLoader = loader::accept;
        } else {
            long[] offset = targetInterval.minAsLongArray();
            offsetLoader = cell -> loader.accept(Views.translate(cell, offset));
        }
        Cache cache = new SoftRefLoaderCache().withLoader((CacheLoader)LoadedCellCacheLoader.get((CellGrid)grid, (CellLoader)offsetLoader, type, accessFlags));
        return Lazy.createImg(grid, cache, type, accessFlags);
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> generate(Interval targetInterval, int[] blockSize, T type, Set<AccessFlags> accessFlags, Consumer<RandomAccessibleInterval<T>> op) {
        return Lazy.createImg(targetInterval, blockSize, type, accessFlags, op);
    }
}

