/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipException;
import net.imagej.updater.Conflicts;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.POMParser;
import net.imagej.updater.util.AbstractProgressable;
import net.imagej.updater.util.Platforms;
import net.imagej.updater.util.Progress;
import net.imagej.updater.util.UpdaterUtil;

public class Checksummer
extends AbstractProgressable {
    private final FilesCollection files;
    private int counter;
    private int total;
    private Map<String, FileObject.Version> cachedChecksums;
    private final boolean isWindows;
    private Map<String, List<StringAndFile>> queue;
    public static final String[][] directories = new String[][]{{"jars", "retro", "misc"}, {".jar", ".class"}, {"config"}, {".toml", ".class", ".py", ".txt"}, {"plugins"}, {".jar", ".class", ".txt", ".ijm", ".py", ".rb", ".clj", ".js", ".bsh", ".groovy", ".gvy"}, {"scripts"}, {".m", ".ijm", ".py", ".rb", ".clj", ".js", ".bsh", ".groovy", ".gvy"}, {"macros"}, {".txt", ".ijm", ".png"}, {"models"}, {""}, {"luts"}, {".lut"}, {"images"}, {".png", ".tif", ".txt", ".ico"}, {"Contents"}, {".icns", ".plist"}, {"lib"}, {""}, {"config"}, {""}, {"licenses"}, {""}, {"mm"}, {""}, {"mmautofocus"}, {""}, {"mmplugins"}, {""}};
    protected static final Map<String, Set<String>> extensions = new HashMap<String, Set<String>>();

    public Checksummer(FilesCollection files, Progress progress) {
        this.files = files;
        if (progress != null) {
            this.addProgress(progress);
        }
        this.setTitle("Checksummer");
        this.isWindows = Platforms.isWindows(files.platform());
    }

    public Map<String, FileObject.Version> getCachedChecksums() {
        return this.cachedChecksums;
    }

    protected boolean exists(File file) {
        try {
            return file.getCanonicalFile().exists();
        }
        catch (IOException e) {
            this.files.log.error((Throwable)e);
            return false;
        }
    }

    public void queueDir(String[] dirs, String[] extensions) {
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, extensions);
        for (String dir : dirs) {
            this.queueDir(dir, set);
        }
    }

    public void queueDir(String dir, Set<String> extensions) {
        File file = this.files.prefix(dir);
        if (!this.exists(file)) {
            return;
        }
        for (String item : file.list()) {
            int dot;
            String path = dir + "/" + item;
            file = this.files.prefix(path);
            if (item.startsWith(".")) continue;
            if (file.isDirectory()) {
                this.queueDir(path, extensions);
                continue;
            }
            if (!extensions.contains("") && ((dot = item.lastIndexOf(46)) < 0 || !extensions.contains(item.substring(dot))) || !this.exists(file)) continue;
            this.queue(path, file);
        }
    }

    protected void queueIfExists(String path) {
        File file = this.files.prefix(path);
        if (file.exists()) {
            this.queue(path, file);
        }
    }

    protected void queue(String path) {
        this.queue(path, this.files.prefix(path));
    }

    protected void queue(String path, File file) {
        StringAndFile entry;
        List<StringAndFile> list;
        String unversioned = FileObject.getFilename(path, true);
        if (unversioned.contains(".old")) {
            return;
        }
        if (!this.queue.containsKey(unversioned)) {
            this.queue.put(unversioned, new ArrayList());
        }
        if (!(list = this.queue.get(unversioned)).contains(entry = new StringAndFile(path, file))) {
            list.add(entry);
        }
    }

    protected void handle(String unversioned) {
        List<StringAndFile> pairs = this.queue.get(unversioned);
        for (StringAndFile pair : pairs) {
            this.addItem(pair.path);
            if (pair.file.exists()) {
                try {
                    pair.timestamp = UpdaterUtil.getTimestamp(pair.file);
                    pair.checksum = this.getDigest(pair.path, pair.file, pair.timestamp);
                }
                catch (ZipException e) {
                    this.files.log.error((Object)("Problem digesting " + pair.file));
                }
                catch (Exception e) {
                    this.files.log.error((Throwable)e);
                }
            }
            this.counter += (int)pair.file.length();
            this.itemDone(pair.path);
            this.setCount(this.counter, this.total);
        }
        if (pairs.size() == 1) {
            this.handle(pairs.get(0));
            return;
        }
        StringAndFile pair = null;
        FileObject object = this.files.get(unversioned);
        if (object == null || object.isObsolete()) {
            for (StringAndFile stringAndFile : pairs) {
                if (pair != null && (stringAndFile.file.lastModified() <= pair.file.lastModified() || !pair.path.equals(FileObject.getFilename(pair.path, true)))) continue;
                pair = stringAndFile;
            }
            ArrayList<File> obsoletes = new ArrayList<File>();
            for (StringAndFile p : pairs) {
                if (p == pair) continue;
                obsoletes.add(p.file);
            }
            if (pair != null) {
                this.addConflict(pair.path, "", false, obsoletes);
            }
        } else {
            ArrayList<StringAndFile> upToDates = new ArrayList<StringAndFile>();
            ArrayList<StringAndFile> arrayList = new ArrayList<StringAndFile>();
            ArrayList<StringAndFile> locallyModifieds = new ArrayList<StringAndFile>();
            for (StringAndFile p : pairs) {
                if (object.current.checksum.equals(p.checksum)) {
                    upToDates.add(p);
                    continue;
                }
                if (object.hasPreviousVersion(p.checksum)) {
                    arrayList.add(p);
                    continue;
                }
                locallyModifieds.add(p);
            }
            Comparator comparator = (a, b) -> {
                long diff = ((StringAndFile)a).file.lastModified() - ((StringAndFile)b).file.lastModified();
                return diff < 0L ? 1 : (diff > 0L ? -1 : 0);
            };
            upToDates.sort(comparator);
            arrayList.sort(comparator);
            locallyModifieds.sort(comparator);
            pair = !upToDates.isEmpty() ? Checksummer.pickNewest(upToDates) : (!arrayList.isEmpty() ? Checksummer.pickNewest(arrayList) : Checksummer.pickNewest(locallyModifieds));
            if (!locallyModifieds.isEmpty()) {
                this.addConflict(pair.path, "locally-modified", true, Checksummer.convert(locallyModifieds));
            }
            if (!arrayList.isEmpty()) {
                this.addConflict(pair.path, "obsolete", false, Checksummer.convert(arrayList));
            }
            if (!upToDates.isEmpty()) {
                this.addConflict(pair.path, "up-to-date", false, Checksummer.convert(upToDates));
            }
        }
        this.handle(pair);
    }

    protected static StringAndFile pickNewest(List<StringAndFile> list) {
        String filename;
        int index = 0;
        if (list.size() > 1 && (filename = list.get(0).path).equals(FileObject.getFilename(filename, true))) {
            ++index;
        }
        StringAndFile result = list.get(index);
        list.remove(index);
        return result;
    }

    protected static List<File> convert(List<StringAndFile> pairs) {
        ArrayList<File> result = new ArrayList<File>();
        for (StringAndFile pair : pairs) {
            result.add(pair.file);
        }
        return result;
    }

    protected void addConflict(final String filename, String adjective, boolean isCritical, final List<File> toDelete) {
        if (!adjective.isEmpty() && !adjective.endsWith(" ")) {
            adjective = adjective + " ";
        }
        String conflictMessage = "Multiple " + adjective + "versions of " + filename + " exist: " + UpdaterUtil.join(", ", toDelete);
        Conflicts.Resolution ignore = new Conflicts.Resolution("Ignore for now"){

            @Override
            public void resolve() {
                Checksummer.this.removeConflict(filename);
            }
        };
        Conflicts.Resolution delete = new Conflicts.Resolution("Delete!"){

            @Override
            public void resolve() {
                for (File file : toDelete) {
                    if (file.delete()) continue;
                    String prefix = Checksummer.this.files.prefix("").getAbsolutePath() + File.separator;
                    String absolute = file.getAbsolutePath();
                    if (absolute.startsWith(prefix)) {
                        try {
                            FileObject.touch(Checksummer.this.files.prefixUpdate(absolute.substring(prefix.length())));
                        }
                        catch (IOException e) {
                            ((Checksummer)Checksummer.this).files.log.error((Throwable)e);
                            file.deleteOnExit();
                        }
                        continue;
                    }
                    file.deleteOnExit();
                }
                Checksummer.this.removeConflict(filename);
            }
        };
        this.files.conflicts.add(new Conflicts.Conflict(isCritical ? Conflicts.Conflict.Severity.CRITICAL_ERROR : Conflicts.Conflict.Severity.ERROR, filename, conflictMessage, ignore, delete));
    }

    protected void removeConflict(String filename) {
        if (this.files.conflicts == null) {
            return;
        }
        Iterator<Conflicts.Conflict> iterator = this.files.conflicts.iterator();
        while (iterator.hasNext()) {
            Conflicts.Conflict conflict = iterator.next();
            if (!conflict.filename.equals(filename)) continue;
            iterator.remove();
            return;
        }
    }

    protected void handle(StringAndFile pair) {
        if (pair.checksum != null) {
            FileObject object = this.files.get(pair.path);
            if (object == null) {
                object = new FileObject(null, pair.path, pair.file.length(), pair.checksum, pair.timestamp, FileObject.Status.LOCAL_ONLY);
                object.localFilename = pair.path;
                object.localChecksum = pair.checksum;
                object.localTimestamp = pair.timestamp;
                if (!this.isWindows && UpdaterUtil.canExecute(pair.file) || pair.path.endsWith(".exe")) {
                    object.executable = true;
                }
                this.guessPlatform(object);
                this.files.add(object);
            } else {
                FileObject.Version obsoletes = this.cachedChecksums.get(":" + pair.checksum);
                if (!object.hasPreviousVersion(pair.checksum)) {
                    if (obsoletes != null) {
                        for (String obsolete : obsoletes.checksum.split(":")) {
                            if (!object.hasPreviousVersion(obsolete)) continue;
                            pair.checksum = obsolete;
                            break;
                        }
                    }
                } else if (object.current != null && obsoletes != null && (":" + obsoletes.checksum + ":").contains(":" + object.current.checksum + ":")) {
                    pair.checksum = object.current.checksum;
                }
                object.setLocalVersion(pair.path, pair.checksum, pair.timestamp);
                if (object.getStatus() == FileObject.Status.OBSOLETE_UNINSTALLED) {
                    object.setStatus(FileObject.Status.OBSOLETE);
                }
            }
            if (pair.path.endsWith(".jar")) {
                try {
                    POMParser.fillMetadataFromJar(object, pair.file);
                }
                catch (Exception e) {
                    this.files.log.error((Object)("Could not read pom.xml from " + pair.path));
                }
            }
        } else {
            FileObject object = this.files.get(pair.path);
            if (object != null) {
                switch (object.getStatus()) {
                    case OBSOLETE: 
                    case OBSOLETE_MODIFIED: {
                        object.setStatus(FileObject.Status.OBSOLETE_UNINSTALLED);
                        break;
                    }
                    case INSTALLED: 
                    case MODIFIED: 
                    case UPDATEABLE: {
                        object.setStatus(FileObject.Status.NOT_INSTALLED);
                        break;
                    }
                    case LOCAL_ONLY: {
                        this.files.remove(pair.path);
                        break;
                    }
                    case NEW: 
                    case NOT_INSTALLED: 
                    case OBSOLETE_UNINSTALLED: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unhandled status!");
                    }
                }
            }
        }
    }

    protected void handleQueue() {
        this.total = 0;
        for (String unversioned : this.queue.keySet()) {
            for (StringAndFile pair : this.queue.get(unversioned)) {
                this.total += (int)pair.file.length();
            }
        }
        this.counter = 0;
        for (String unversioned : this.queue.keySet()) {
            this.handle(unversioned);
        }
        this.done();
        this.writeCachedChecksums();
    }

    public void updateFromLocal(List<String> files) {
        this.queue = new LinkedHashMap<String, List<StringAndFile>>();
        for (String file : files) {
            this.queue(file);
        }
        this.handleQueue();
    }

    protected boolean guessPlatform(FileObject file) {
        String platform;
        if (file.executable) {
            platform = Platforms.platformForLauncher(file.filename);
            if (platform == null) {
                return false;
            }
        } else {
            if (file.filename.startsWith("jars/")) {
                platform = file.filename.substring(5);
            } else if (file.filename.startsWith("lib/")) {
                platform = file.filename.substring(4);
            } else if (file.filename.startsWith("mm/")) {
                platform = file.filename.substring(3);
            } else {
                return false;
            }
            int slash = platform.indexOf(47);
            if (slash < 0) {
                return false;
            }
            platform = platform.substring(0, slash);
        }
        if (platform.equals("linux")) {
            platform = "linux32";
        }
        for (String valid : Platforms.known()) {
            if (!platform.equals(valid)) continue;
            file.addPlatform(platform);
            return true;
        }
        return false;
    }

    public boolean isCandidate(String path) {
        int slash = (path = path.replace('\\', '/')).indexOf(47);
        if (slash < 0) {
            return Platforms.isLauncher(path);
        }
        Set<String> exts = extensions.get(path.substring(0, slash));
        int dot = path.lastIndexOf(46);
        return exts != null && dot >= 0 && exts.contains(path.substring(dot));
    }

    protected void initializeQueue() {
        this.queue = new LinkedHashMap<String, List<StringAndFile>>();
        this.queueIfExists("README.md");
        this.queueIfExists("WELCOME.md");
        this.queueIfExists("fiji");
        this.queueIfExists("fiji.bat");
        this.queueIfExists("ImageJ.sh");
        for (String launcher : Platforms.launchers()) {
            this.queueIfExists(launcher);
        }
        File appDir = this.files.getAppRoot();
        if (appDir != null) {
            Set<String> allExtensions = Collections.singleton("");
            for (File file : appDir.listFiles()) {
                if (!file.isDirectory() || !file.getName().endsWith(".app")) continue;
                this.queueDir(file.getName(), allExtensions);
            }
        }
        for (int i = 0; i < directories.length; i += 2) {
            this.queueDir(directories[i], directories[i + 1]);
        }
        for (FileObject file : this.files) {
            if (this.queue.containsKey(file.getFilename(true))) continue;
            this.queue(file.getFilename());
        }
    }

    public void updateFromLocal() {
        this.initializeQueue();
        this.handleQueue();
    }

    protected void readCachedChecksums() {
        this.cachedChecksums = new TreeMap<String, FileObject.Version>();
        File file = this.files.prefix(".checksums");
        if (!file.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                try {
                    int space = line.indexOf(32);
                    if (space < 0) continue;
                    String checksum = line.substring(0, space);
                    int space2 = line.indexOf(32, space + 1);
                    if (space2 < 0) continue;
                    long timestamp = Long.parseLong(line.substring(space + 1, space2));
                    String filename = line.substring(space2 + 1);
                    this.cachedChecksums.put(filename, new FileObject.Version(checksum, timestamp));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeCachedChecksums() {
        if (this.cachedChecksums == null) {
            return;
        }
        File file = this.files.prefix(".checksums");
        try {
            FileWriter writer = new FileWriter(file);
            for (String filename : this.cachedChecksums.keySet()) {
                if (!filename.startsWith(":") && !this.files.prefix(filename).exists()) continue;
                FileObject.Version version = this.cachedChecksums.get(filename);
                writer.write(version.checksum + " " + version.timestamp + " " + filename + "\n");
            }
            ((Writer)writer).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getDigest(String path, File file, long timestamp) throws IOException, NoSuchAlgorithmException {
        List<String> obsoletes;
        FileObject.Version version;
        if (this.cachedChecksums == null) {
            this.readCachedChecksums();
        }
        if ((version = this.cachedChecksums.get(path)) == null || timestamp != version.timestamp) {
            String checksum = path.equals("plugins/Fiji_Updater.jar") ? UpdaterUtil.getJarDigest(file, false, false, false) : UpdaterUtil.getDigest(path, file);
            version = new FileObject.Version(checksum, timestamp);
            this.cachedChecksums.put(path, version);
        }
        if (!this.cachedChecksums.containsKey(":" + version.checksum) && (obsoletes = UpdaterUtil.getObsoleteDigests(path, file)) != null) {
            StringBuilder builder = new StringBuilder();
            for (String obsolete : obsoletes) {
                if (builder.length() > 0) {
                    builder.append(':');
                }
                builder.append(obsolete);
            }
            this.cachedChecksums.put(":" + version.checksum, new FileObject.Version(builder.toString(), timestamp));
        }
        return version.checksum;
    }

    static {
        for (int i = 0; i < directories.length; i += 2) {
            HashSet<String> set = new HashSet<String>(Arrays.asList(directories[i + 1]));
            for (String dir : directories[i + 1]) {
                extensions.put(dir, set);
            }
        }
    }

    protected static class StringAndFile {
        private final String path;
        private final File file;
        public long timestamp;
        public String checksum;

        protected StringAndFile(String path, File file) {
            this.path = path;
            this.file = file;
        }

        public String toString() {
            return "{" + this.path + " - " + this.file + "}";
        }

        public boolean equals(Object o) {
            if (!(o instanceof StringAndFile)) {
                return false;
            }
            StringAndFile that = (StringAndFile)o;
            return Objects.equals(this.path, that.path) && Objects.equals(this.file, that.file);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.file);
        }
    }
}

